/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.KettleAuthenticationException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransAdapter;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

public class ExecuteTransServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = ExecuteTransServlet.class;
    private static final long serialVersionUID = -5879219287669847357L;
    private static final String UNABLE_TO_FIND_TRANS = "Unable to find transformation";
    private static final String REP = "rep";
    private static final String USER = "user";
    private static final String PASS = "pass";
    private static final String TRANS = "trans";
    private static final String LEVEL = "level";
    public static final String CONTEXT_PATH = "/kettle/executeTrans";

    public ExecuteTransServlet() {
    }

    public ExecuteTransServlet(TransformationMap transformationMap) {
        super(transformationMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ExecuteTransServlet.Log.ExecuteTransRequested", (String[])new String[0]));
        }
        String[] knownOptions = new String[]{REP, USER, PASS, TRANS, LEVEL};
        String repOption = request.getParameter(REP);
        String userOption = request.getParameter(USER);
        String passOption = Encr.decryptPasswordOptionallyEncrypted((String)request.getParameter(PASS));
        String transOption = request.getParameter(TRANS);
        String levelOption = request.getParameter(LEVEL);
        response.setStatus(200);
        String encoding = System.getProperty("KETTLE_DEFAULT_SERVLET_ENCODING", null);
        if (encoding != null && !Utils.isEmpty((CharSequence)encoding.trim())) {
            response.setCharacterEncoding(encoding);
            response.setContentType("text/html; charset=" + encoding);
        }
        PrintWriter out = response.getWriter();
        if (repOption == null || transOption == null) {
            response.setStatus(400);
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"ExecuteTransServlet.Error.MissingMandatoryParameter", (String[])new String[]{repOption == null ? REP : TRANS})));
            return;
        }
        try {
            final Repository repository = this.openRepository(repOption, userOption, passOption);
            TransMeta transMeta = this.loadTransformation(repository, transOption);
            String[] parameters = transMeta.listParameters();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameter = (String)parameterNames.nextElement();
                String[] values = request.getParameterValues(parameter);
                if (Const.indexOfString((String)parameter, (String[])knownOptions) >= 0) continue;
                if (Const.indexOfString((String)parameter, (String[])parameters) < 0) {
                    transMeta.setVariable(parameter, values[0]);
                    continue;
                }
                transMeta.setParameterValue(parameter, values[0]);
            }
            TransExecutionConfiguration transExecutionConfiguration = new TransExecutionConfiguration();
            LogLevel logLevel = LogLevel.getLogLevelForCode((String)levelOption);
            transExecutionConfiguration.setLogLevel(logLevel);
            TransConfiguration transConfiguration = new TransConfiguration(transMeta, transExecutionConfiguration);
            String carteObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.CARTE, null);
            servletLoggingObject.setContainerObjectId(carteObjectId);
            servletLoggingObject.setLogLevel(logLevel);
            Trans trans = new Trans(transMeta, (LoggingObjectInterface)servletLoggingObject);
            trans.setRepository(repository);
            trans.setSocketRepository(this.getSocketRepository());
            this.getTransformationMap().addTransformation(transMeta.getName(), carteObjectId, trans, transConfiguration);
            trans.setContainerObjectId(carteObjectId);
            if (repository != null) {
                trans.addTransListener(new TransAdapter(){

                    @Override
                    public void transFinished(Trans trans) {
                        repository.disconnect();
                    }
                });
            }
            trans.setServletPrintWriter(out);
            trans.setServletReponse(response);
            trans.setServletRequest(request);
            try {
                this.executeTrans(trans);
                String logging = KettleLogStore.getAppender().getBuffer(trans.getLogChannelId(), false).toString();
                if (trans.isFinishedOrStopped() && trans.getErrors() > 0) {
                    response.setStatus(500);
                    out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"ExecuteTransServlet.Error.ErrorExecutingTrans", (String[])new String[]{logging})));
                } else {
                    out.println(new WebResult("OK", BaseMessages.getString(PKG, (String)"ExecuteTransServlet.Log.ExecuteTransFinished", (String[])new String[]{logging})));
                }
                out.flush();
            }
            catch (Exception executionException) {
                String logging = KettleLogStore.getAppender().getBuffer(trans.getLogChannelId(), false).toString();
                throw new KettleException(BaseMessages.getString(PKG, (String)"ExecuteTransServlet.Error.ErrorExecutingTrans", (String[])new String[]{logging}), (Throwable)executionException);
            }
        }
        catch (Exception ex) {
            Throwable kettleExceptionCause = ex.getCause();
            if (kettleExceptionCause != null && kettleExceptionCause instanceof ExecutionException) {
                Throwable executionExceptionCause = kettleExceptionCause.getCause();
                if (executionExceptionCause != null && executionExceptionCause instanceof KettleAuthenticationException) {
                    response.setStatus(401);
                    out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"ExecuteTransServlet.Error.Authentication", (String[])new String[]{this.getContextPath()})));
                }
            }
            if (ex.getMessage().contains(UNABLE_TO_FIND_TRANS)) {
                response.setStatus(404);
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"ExecuteTransServlet.Error.UnableToFindTransformation", (String[])new String[]{transOption})));
            }
            response.setStatus(500);
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"ExecuteTransServlet.Error.UnexpectedError", (String[])new String[]{Const.CR + Const.getStackTracker((Throwable)ex)})));
        }
    }

    private TransMeta loadTransformation(Repository repository, String trans) throws KettleException {
        String name;
        String directoryPath;
        if (repository == null) {
            TransMeta transMeta = new TransMeta(trans);
            return transMeta;
        }
        int lastSlash = trans.lastIndexOf("/");
        if (lastSlash < 0) {
            directoryPath = "/";
            name = trans;
        } else {
            directoryPath = trans.substring(0, lastSlash);
            name = trans.substring(lastSlash + 1);
        }
        RepositoryDirectoryInterface directory = repository.loadRepositoryDirectoryTree().findDirectory(directoryPath);
        if (directory == null) {
            throw new KettleException("Unable to find directory path '" + directoryPath + "' in the repository");
        }
        ObjectId transformationID = repository.getTransformationID(name, directory);
        if (transformationID == null) {
            throw new KettleException("Unable to find transformation '" + name + "' in directory :" + directory);
        }
        TransMeta transMeta = repository.loadTransformation(transformationID, null);
        return transMeta;
    }

    private Repository openRepository(String repositoryName, String user, String pass) throws KettleException {
        if (Utils.isEmpty((CharSequence)repositoryName)) {
            return null;
        }
        RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
        repositoriesMeta.readData();
        RepositoryMeta repositoryMeta = repositoriesMeta.findRepository(repositoryName);
        if (repositoryMeta == null) {
            throw new KettleException("Unable to find repository: " + repositoryName);
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        Repository repository = (Repository)registry.loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
        repository.init(repositoryMeta);
        repository.connect(user, pass);
        return repository;
    }

    public String toString() {
        return "Start transformation";
    }

    @Override
    public String getService() {
        return "/kettle/executeTrans (" + this.toString() + ")";
    }

    protected void executeTrans(Trans trans) throws KettleException {
        trans.prepareExecution(null);
        trans.startThreads();
        trans.waitUntilFinished();
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

