/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteDelegationHandler;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Deprecated
public class AddExportServlet
extends BaseHttpServlet
implements CartePluginInterface {
    public static final String PARAMETER_LOAD = "load";
    public static final String PARAMETER_TYPE = "type";
    public static final String TYPE_JOB = "job";
    public static final String TYPE_TRANS = "trans";
    private static final long serialVersionUID = -6850701762586992604L;
    public static final String CONTEXT_PATH = "/kettle/addExport";

    public AddExportServlet() {
    }

    public AddExportServlet(JobMap jobMap, TransformationMap transformationMap) {
        super(transformationMap, jobMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getRequestURI().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("Addition of export requested");
        }
        PrintWriter out = response.getWriter();
        ServletInputStream in = request.getInputStream();
        if (this.log.isDetailed()) {
            this.logDetailed("Encoding: " + request.getCharacterEncoding());
        }
        boolean isJob = TYPE_JOB.equalsIgnoreCase(request.getParameter(PARAMETER_TYPE));
        String load = request.getParameter(PARAMETER_LOAD);
        response.setContentType("text/xml");
        out.print(XMLHandler.getXMLHeader());
        response.setStatus(200);
        try (OutputStream outputStream = null;){
            int c;
            FileObject tempFile = KettleVFS.createTempFile((String)"export", (String)".zip", (String)System.getProperty("java.io.tmpdir"));
            outputStream = KettleVFS.getOutputStream((FileObject)tempFile, (boolean)false);
            while ((c = in.read()) != -1) {
                outputStream.write(c);
            }
            outputStream.flush();
            outputStream.close();
            outputStream = null;
            String archiveUrl = tempFile.getName().toString();
            String fileUrl = null;
            String carteObjectId = null;
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.CARTE, null);
            if (!Utils.isEmpty((CharSequence)load)) {
                fileUrl = "zip:" + archiveUrl + "!" + load;
                if (isJob) {
                    KettleVFS.getFileObject((String)fileUrl);
                    JobMeta jobMeta = new JobMeta(fileUrl, null);
                    String configUrl = "zip:" + archiveUrl + "!" + "__job_execution_configuration__.xml";
                    Document configDoc = XMLHandler.loadXMLFile((String)configUrl);
                    JobExecutionConfiguration jobExecutionConfiguration = new JobExecutionConfiguration(XMLHandler.getSubNode((Node)configDoc, (String)"job_execution_configuration"));
                    carteObjectId = UUID.randomUUID().toString();
                    servletLoggingObject.setContainerObjectId(carteObjectId);
                    servletLoggingObject.setLogLevel(jobExecutionConfiguration.getLogLevel());
                    Job job = new Job(null, jobMeta, (LoggingObjectInterface)servletLoggingObject);
                    if (jobExecutionConfiguration.isExpandingRemoteJob()) {
                        job.addDelegationListener(new CarteDelegationHandler(this.getTransformationMap(), this.getJobMap()));
                    }
                    this.getJobMap().addJob(job.getJobname(), carteObjectId, job, new JobConfiguration(jobMeta, jobExecutionConfiguration));
                    this.log.setLogLevel(jobExecutionConfiguration.getLogLevel());
                    job.setArguments(jobExecutionConfiguration.getArgumentStrings());
                    jobMeta.injectVariables(jobExecutionConfiguration.getVariables());
                    Map<String, String> params = jobExecutionConfiguration.getParams();
                    for (String param : params.keySet()) {
                        String value = params.get(param);
                        jobMeta.setParameterValue(param, value);
                    }
                } else {
                    TransMeta transMeta = new TransMeta(fileUrl);
                    String configUrl = "zip:" + archiveUrl + "!" + "__job_execution_configuration__.xml";
                    Document configDoc = XMLHandler.loadXMLFile((String)configUrl);
                    TransExecutionConfiguration executionConfiguration = new TransExecutionConfiguration(XMLHandler.getSubNode((Node)configDoc, (String)"transformation_execution_configuration"));
                    carteObjectId = UUID.randomUUID().toString();
                    servletLoggingObject.setContainerObjectId(carteObjectId);
                    servletLoggingObject.setLogLevel(executionConfiguration.getLogLevel());
                    Trans trans = new Trans(transMeta, (LoggingObjectInterface)servletLoggingObject);
                    this.getTransformationMap().addTransformation(trans.getName(), carteObjectId, trans, new TransConfiguration(transMeta, executionConfiguration));
                }
            } else {
                fileUrl = archiveUrl;
            }
            out.println(new WebResult("OK", fileUrl, carteObjectId));
        }
    }

    public String toString() {
        return "Add export";
    }

    @Override
    public String getService() {
        return "/kettle/addExport (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

