/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.streaming.common;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.ISubTransAwareMeta;
import org.pentaho.di.trans.StepWithMappingMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.streaming.common.BaseStreamStep;
import org.pentaho.metastore.api.IMetaStore;

public abstract class BaseStreamStepMeta
extends StepWithMappingMeta
implements StepMetaInterface,
ISubTransAwareMeta {
    private static final Class<?> PKG = BaseStreamStep.class;
    public static final String TRANSFORMATION_PATH = "TRANSFORMATION_PATH";
    public static final String NUM_MESSAGES = "NUM_MESSAGES";
    public static final String DURATION = "DURATION";
    public static final String SUB_STEP = "SUB_STEP";
    public static final String PARALLELISM = "PARALLELISM";
    public static final String MESSAGE_DATA_TYPE = "MESSAGE_DATA_TYPE";
    @Injection(name="TRANSFORMATION_PATH")
    protected String transformationPath = "";
    @Injection(name="NUM_MESSAGES")
    protected String batchSize = "1000";
    @Injection(name="DURATION")
    protected String batchDuration = "1000";
    @Injection(name="SUB_STEP")
    protected String subStep = "";
    @Injection(name="PARALLELISM")
    protected String parallelism = "1";
    MappingMetaRetriever mappingMetaRetriever = StepWithMappingMeta::loadMappingMeta;

    public String getSubStep() {
        return this.subStep == null ? "" : this.subStep;
    }

    public void setSubStep(String subStep) {
        this.subStep = subStep;
    }

    public void setTransformationPath(String transformationPath) {
        this.transformationPath = transformationPath;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchDuration(String batchDuration) {
        this.batchDuration = batchDuration;
    }

    public void setParallelism(String parallelism) {
        this.parallelism = parallelism;
    }

    @Override
    public void setDefault() {
        this.batchSize = "1000";
        this.batchDuration = "1000";
        this.parallelism = "1";
    }

    public String getTransformationPath() {
        return this.transformationPath;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public String getBatchDuration() {
        return this.batchDuration;
    }

    public String getParallelism() {
        return this.parallelism;
    }

    public int getMessageDataType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceFileName(String fileName) {
        super.replaceFileName(fileName);
        this.setTransformationPath(fileName);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        long duration = Long.MIN_VALUE;
        try {
            duration = Long.parseLong(space.environmentSubstitute(this.getBatchDuration()));
        }
        catch (NumberFormatException e) {
            remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"BaseStreamStepMeta.CheckResult.NaN", (String[])new String[]{"Duration"}), (CheckResultSourceInterface)stepMeta));
        }
        long size = Long.MIN_VALUE;
        try {
            size = Long.parseLong(space.environmentSubstitute(this.getBatchSize()));
        }
        catch (NumberFormatException e) {
            remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"BaseStreamStepMeta.CheckResult.NaN", (String[])new String[]{"Number of records"}), (CheckResultSourceInterface)stepMeta));
        }
        if (duration == 0L && size == 0L) {
            remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"BaseStreamStepMeta.CheckResult.NoBatchDefined", (String[])new String[0]), (CheckResultSourceInterface)stepMeta));
        }
        try {
            TransMeta subMeta = this.mappingMetaRetriever.get(this, repository, metaStore, space);
            if (!StringUtil.isEmpty((String)this.getSubStep())) {
                String realSubStepName = space.environmentSubstitute(this.getSubStep());
                if (!subMeta.getSteps().stream().anyMatch(subStepMeta -> subStepMeta.getName().equals(realSubStepName))) {
                    remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"BaseStreamStepMeta.CheckResult.ResultStepMissing", (String[])new String[]{subMeta.getName(), realSubStepName}), (CheckResultSourceInterface)stepMeta));
                }
            }
        }
        catch (KettleException e) {
            this.getLog().logDebug("Error loading subtrans meta", new Object[]{e});
        }
    }

    @Override
    public String getFileName() {
        return Strings.isNullOrEmpty((String)this.fileName) ? this.getTransformationPath() : this.fileName;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        String realFilename = transMeta.environmentSubstitute(this.transformationPath);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        if (!Utils.isEmpty((CharSequence)realFilename)) {
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.ACTIONFILE));
        }
        return references;
    }

    @Override
    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"BaseStreamStepMeta.ReferencedObject.SubTrans.Description", (String[])new String[0])};
    }

    @Override
    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{!Utils.isEmpty((CharSequence)this.transformationPath)};
    }

    @Override
    public Object loadReferencedObject(int index, Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        return BaseStreamStepMeta.loadMappingMeta(this, rep, metaStore, space);
    }

    public abstract RowMeta getRowMeta(String var1, VariableSpace var2) throws KettleStepException;

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        block3: {
            try {
                TransMeta transMeta = this.mappingMetaRetriever.get(this, repository, metaStore, space);
                if (StringUtil.isEmpty((String)this.getSubStep())) break block3;
                String realSubStepName = space.environmentSubstitute(this.getSubStep());
                if (transMeta.getSteps().stream().anyMatch(stepMeta -> stepMeta.getName().equals(realSubStepName))) {
                    rowMeta.addRowMeta(transMeta.getPrevStepFields(realSubStepName));
                    transMeta.getSteps().stream().filter(stepMeta -> stepMeta.getName().equals(realSubStepName)).findFirst().ifPresent(stepMeta -> {
                        try {
                            stepMeta.getStepMetaInterface().getFields(rowMeta, origin, info, nextStep, space, repository, metaStore);
                        }
                        catch (KettleStepException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    break block3;
                }
                throw new RuntimeException(BaseMessages.getString(PKG, (String)"BaseStreamStepMeta.CheckResult.ResultStepMissing", (String[])new String[]{transMeta.getName(), realSubStepName}));
            }
            catch (KettleException e) {
                this.getLog().logDebug("could not get fields, probable AEL");
                rowMeta.addRowMeta((RowMetaInterface)this.getRowMeta(origin, space));
            }
        }
    }

    @FunctionalInterface
    static interface MappingMetaRetriever {
        public TransMeta get(StepWithMappingMeta var1, Repository var2, IMetaStore var3, VariableSpace var4) throws KettleException;
    }
}

