/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.transexecutor;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.HasRepositoryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryImportLocation;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.ISubTransAwareMeta;
import org.pentaho.di.trans.StepWithMappingMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.transexecutor.TransExecutor;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorData;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorParameters;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class TransExecutorMeta
extends StepWithMappingMeta
implements StepMetaInterface,
HasRepositoryInterface,
ISubTransAwareMeta {
    private static Class<?> PKG = TransExecutorMeta.class;
    static final String F_EXECUTION_RESULT_TARGET_STEP = "execution_result_target_step";
    static final String F_RESULT_FILE_TARGET_STEP = "result_files_target_step";
    static final String F_EXECUTOR_OUTPUT_STEP = "executors_output_step";
    private String groupSize;
    private String groupField;
    private String groupTime;
    private TransExecutorParameters parameters = new TransExecutorParameters();
    private String executionResultTargetStep;
    private StepMeta executionResultTargetStepMeta;
    private String executionTimeField;
    private String executionResultField;
    private String executionNrErrorsField;
    private String executionLinesReadField;
    private String executionLinesWrittenField;
    private String executionLinesInputField;
    private String executionLinesOutputField;
    private String executionLinesRejectedField;
    private String executionLinesUpdatedField;
    private String executionLinesDeletedField;
    private String executionFilesRetrievedField;
    private String executionExitStatusField;
    private String executionLogTextField;
    private String executionLogChannelIdField;
    private String outputRowsSourceStep;
    private StepMeta outputRowsSourceStepMeta;
    private String[] outputRowsField;
    private int[] outputRowsType;
    private int[] outputRowsLength;
    private int[] outputRowsPrecision;
    private String resultFilesTargetStep;
    private StepMeta resultFilesTargetStepMeta;
    private String resultFilesFileNameField;
    private String executorsOutputStep;
    private StepMeta executorsOutputStepMeta;
    private Repository repository;
    private IMetaStore metaStore;

    public TransExecutorMeta() {
        this.allocate(0);
    }

    public void allocate(int nrFields) {
        this.outputRowsField = new String[nrFields];
        this.outputRowsType = new int[nrFields];
        this.outputRowsLength = new int[nrFields];
        this.outputRowsPrecision = new int[nrFields];
    }

    @Override
    public Object clone() {
        TransExecutorMeta retval = (TransExecutorMeta)super.clone();
        int nrFields = this.outputRowsField.length;
        retval.allocate(nrFields);
        System.arraycopy(this.outputRowsField, 0, retval.outputRowsField, 0, nrFields);
        System.arraycopy(this.outputRowsType, 0, retval.outputRowsType, 0, nrFields);
        System.arraycopy(this.outputRowsLength, 0, retval.outputRowsLength, 0, nrFields);
        System.arraycopy(this.outputRowsPrecision, 0, retval.outputRowsPrecision, 0, nrFields);
        return retval;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"specification_method", this.specificationMethod == null ? null : this.specificationMethod.getCode()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"trans_object_id", this.transObjectId == null ? null : this.transObjectId.toString()));
        if (this.repository != null && this.transObjectId != null) {
            try {
                RepositoryObject objectInformation = this.repository.getObjectInformation(this.transObjectId, RepositoryObjectType.TRANSFORMATION);
                if (objectInformation != null) {
                    this.transName = objectInformation.getName();
                    this.directoryPath = objectInformation.getRepositoryDirectory().getPath();
                }
            }
            catch (KettleException objectInformation) {
                // empty catch block
            }
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"trans_name", (String)this.transName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.fileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"directory_path", (String)this.directoryPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"group_size", (String)this.groupSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"group_field", (String)this.groupField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"group_time", (String)this.groupTime));
        retval.append("      ").append(this.parameters.getXML()).append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)F_EXECUTION_RESULT_TARGET_STEP, this.executionResultTargetStepMeta == null ? null : this.executionResultTargetStepMeta.getName()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_time_field", (String)this.executionTimeField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_result_field", (String)this.executionResultField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_errors_field", (String)this.executionNrErrorsField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_lines_read_field", (String)this.executionLinesReadField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_lines_written_field", (String)this.executionLinesWrittenField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_lines_input_field", (String)this.executionLinesInputField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_lines_output_field", (String)this.executionLinesOutputField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_lines_rejected_field", (String)this.executionLinesRejectedField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_lines_updated_field", (String)this.executionLinesUpdatedField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_lines_deleted_field", (String)this.executionLinesDeletedField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_files_retrieved_field", (String)this.executionFilesRetrievedField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_exit_status_field", (String)this.executionExitStatusField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_log_text_field", (String)this.executionLogTextField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_log_channelid_field", (String)this.executionLogChannelIdField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"result_rows_target_step", this.outputRowsSourceStepMeta == null ? null : this.outputRowsSourceStepMeta.getName()));
        for (int i = 0; i < this.outputRowsField.length; ++i) {
            retval.append("      ").append(XMLHandler.openTag((String)"result_rows_field"));
            retval.append(XMLHandler.addTagValue((String)"name", (String)this.outputRowsField[i], (boolean)false, (String[])new String[0]));
            retval.append(XMLHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.outputRowsType[i]), (boolean)false, (String[])new String[0]));
            retval.append(XMLHandler.addTagValue((String)"length", (int)this.outputRowsLength[i], (boolean)false));
            retval.append(XMLHandler.addTagValue((String)"precision", (int)this.outputRowsPrecision[i], (boolean)false));
            retval.append(XMLHandler.closeTag((String)"result_rows_field")).append(Const.CR);
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)F_RESULT_FILE_TARGET_STEP, this.resultFilesTargetStepMeta == null ? null : this.resultFilesTargetStepMeta.getName()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"result_files_file_name_field", (String)this.resultFilesFileNameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)F_EXECUTOR_OUTPUT_STEP, this.executorsOutputStepMeta == null ? null : this.executorsOutputStepMeta.getName()));
        return retval.toString();
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            String method = XMLHandler.getTagValue((Node)stepnode, (String)"specification_method");
            this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
            String transId = XMLHandler.getTagValue((Node)stepnode, (String)"trans_object_id");
            this.transObjectId = Utils.isEmpty((CharSequence)transId) ? null : new StringObjectId(transId);
            this.transName = XMLHandler.getTagValue((Node)stepnode, (String)"trans_name");
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            this.directoryPath = XMLHandler.getTagValue((Node)stepnode, (String)"directory_path");
            this.groupSize = XMLHandler.getTagValue((Node)stepnode, (String)"group_size");
            this.groupField = XMLHandler.getTagValue((Node)stepnode, (String)"group_field");
            this.groupTime = XMLHandler.getTagValue((Node)stepnode, (String)"group_time");
            Node mappingParametersNode = XMLHandler.getSubNode((Node)stepnode, (String)"parameters");
            this.parameters = new TransExecutorParameters(mappingParametersNode);
            this.executionResultTargetStep = XMLHandler.getTagValue((Node)stepnode, (String)F_EXECUTION_RESULT_TARGET_STEP);
            this.executionTimeField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_time_field");
            this.executionResultField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_result_field");
            this.executionNrErrorsField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_errors_field");
            this.executionLinesReadField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_lines_read_field");
            this.executionLinesWrittenField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_lines_written_field");
            this.executionLinesInputField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_lines_input_field");
            this.executionLinesOutputField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_lines_output_field");
            this.executionLinesRejectedField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_lines_rejected_field");
            this.executionLinesUpdatedField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_lines_updated_field");
            this.executionLinesDeletedField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_lines_deleted_field");
            this.executionFilesRetrievedField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_files_retrieved_field");
            this.executionExitStatusField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_exit_status_field");
            this.executionLogTextField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_log_text_field");
            this.executionLogChannelIdField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_log_channelid_field");
            this.outputRowsSourceStep = XMLHandler.getTagValue((Node)stepnode, (String)"result_rows_target_step");
            int nrFields = XMLHandler.countNodes((Node)stepnode, (String)"result_rows_field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fieldNode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"result_rows_field", (int)i);
                this.outputRowsField[i] = XMLHandler.getTagValue((Node)fieldNode, (String)"name");
                this.outputRowsType[i] = ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)fieldNode, (String)"type"));
                this.outputRowsLength[i] = Const.toInt((String)XMLHandler.getTagValue((Node)fieldNode, (String)"length"), (int)-1);
                this.outputRowsPrecision[i] = Const.toInt((String)XMLHandler.getTagValue((Node)fieldNode, (String)"precision"), (int)-1);
            }
            this.resultFilesTargetStep = XMLHandler.getTagValue((Node)stepnode, (String)F_RESULT_FILE_TARGET_STEP);
            this.resultFilesFileNameField = XMLHandler.getTagValue((Node)stepnode, (String)"result_files_file_name_field");
            this.executorsOutputStep = XMLHandler.getTagValue((Node)stepnode, (String)F_EXECUTOR_OUTPUT_STEP);
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"TransExecutorMeta.Exception.ErrorLoadingTransExecutorDetailsFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        String method = rep.getStepAttributeString(id_step, "specification_method");
        this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
        String transId = rep.getStepAttributeString(id_step, "trans_object_id");
        this.transObjectId = Utils.isEmpty((CharSequence)transId) ? null : new StringObjectId(transId);
        this.transName = rep.getStepAttributeString(id_step, "trans_name");
        this.fileName = rep.getStepAttributeString(id_step, "filename");
        this.directoryPath = rep.getStepAttributeString(id_step, "directory_path");
        this.groupSize = rep.getStepAttributeString(id_step, "group_size");
        this.groupField = rep.getStepAttributeString(id_step, "group_field");
        this.groupTime = rep.getStepAttributeString(id_step, "group_time");
        this.parameters = new TransExecutorParameters(rep, id_step);
        this.executionResultTargetStep = rep.getStepAttributeString(id_step, F_EXECUTION_RESULT_TARGET_STEP);
        this.executionTimeField = rep.getStepAttributeString(id_step, "execution_time_field");
        this.executionResultField = rep.getStepAttributeString(id_step, "execution_result_field");
        this.executionNrErrorsField = rep.getStepAttributeString(id_step, "execution_errors_field");
        this.executionLinesReadField = rep.getStepAttributeString(id_step, "execution_lines_read_field");
        this.executionLinesWrittenField = rep.getStepAttributeString(id_step, "execution_lines_written_field");
        this.executionLinesInputField = rep.getStepAttributeString(id_step, "execution_lines_input_field");
        this.executionLinesOutputField = rep.getStepAttributeString(id_step, "execution_lines_output_field");
        this.executionLinesRejectedField = rep.getStepAttributeString(id_step, "execution_lines_rejected_field");
        this.executionLinesUpdatedField = rep.getStepAttributeString(id_step, "execution_lines_updated_field");
        this.executionLinesDeletedField = rep.getStepAttributeString(id_step, "execution_lines_deleted_field");
        this.executionFilesRetrievedField = rep.getStepAttributeString(id_step, "execution_files_retrieved_field");
        this.executionExitStatusField = rep.getStepAttributeString(id_step, "execution_exit_status_field");
        this.executionLogTextField = rep.getStepAttributeString(id_step, "execution_log_text_field");
        this.executionLogChannelIdField = rep.getStepAttributeString(id_step, "execution_log_channelid_field");
        this.outputRowsSourceStep = rep.getStepAttributeString(id_step, "result_rows_target_step");
        int nrFields = rep.countNrStepAttributes(id_step, "result_rows_field_name");
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.outputRowsField[i] = rep.getStepAttributeString(id_step, i, "result_rows_field_name");
            this.outputRowsType[i] = ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, i, "result_rows_field_type"));
            this.outputRowsLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "result_rows_field_length");
            this.outputRowsPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "result_rows_field_precision");
        }
        this.resultFilesTargetStep = rep.getStepAttributeString(id_step, F_RESULT_FILE_TARGET_STEP);
        this.resultFilesFileNameField = rep.getStepAttributeString(id_step, "result_files_file_name_field");
        this.executorsOutputStep = rep.getStepAttributeString(id_step, F_EXECUTOR_OUTPUT_STEP);
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, "specification_method", this.specificationMethod == null ? null : this.specificationMethod.getCode());
        rep.saveStepAttribute(id_transformation, id_step, "trans_object_id", this.transObjectId == null ? null : this.transObjectId.toString());
        rep.saveStepAttribute(id_transformation, id_step, "filename", this.fileName);
        rep.saveStepAttribute(id_transformation, id_step, "trans_name", this.transName);
        rep.saveStepAttribute(id_transformation, id_step, "directory_path", this.directoryPath);
        rep.saveStepAttribute(id_transformation, id_step, "group_size", this.groupSize);
        rep.saveStepAttribute(id_transformation, id_step, "group_field", this.groupField);
        rep.saveStepAttribute(id_transformation, id_step, "group_time", this.groupTime);
        this.parameters.saveRep(rep, metaStore, id_transformation, id_step);
        rep.saveStepAttribute(id_transformation, id_step, F_EXECUTION_RESULT_TARGET_STEP, this.executionResultTargetStepMeta == null ? null : this.executionResultTargetStepMeta.getName());
        rep.saveStepAttribute(id_transformation, id_step, "execution_time_field", this.executionTimeField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_result_field", this.executionResultField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_errors_field", this.executionNrErrorsField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_lines_read_field", this.executionLinesReadField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_lines_written_field", this.executionLinesWrittenField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_lines_input_field", this.executionLinesInputField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_lines_output_field", this.executionLinesOutputField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_lines_rejected_field", this.executionLinesRejectedField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_lines_updated_field", this.executionLinesUpdatedField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_lines_deleted_field", this.executionLinesDeletedField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_files_retrieved_field", this.executionFilesRetrievedField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_exit_status_field", this.executionExitStatusField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_log_text_field", this.executionLogTextField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_log_channelid_field", this.executionLogChannelIdField);
        rep.saveStepAttribute(id_transformation, id_step, "result_rows_target_step", this.outputRowsSourceStepMeta == null ? null : this.outputRowsSourceStepMeta.getName());
        for (int i = 0; i < this.outputRowsField.length; ++i) {
            rep.saveStepAttribute(id_transformation, id_step, i, "result_rows_field_name", this.outputRowsField[i]);
            rep.saveStepAttribute(id_transformation, id_step, i, "result_rows_field_type", ValueMetaFactory.getValueMetaName((int)this.outputRowsType[i]));
            rep.saveStepAttribute(id_transformation, id_step, i, "result_rows_field_length", this.outputRowsLength[i]);
            rep.saveStepAttribute(id_transformation, id_step, i, "result_rows_field_precision", this.outputRowsPrecision[i]);
        }
        rep.saveStepAttribute(id_transformation, id_step, F_RESULT_FILE_TARGET_STEP, this.resultFilesTargetStepMeta == null ? null : this.resultFilesTargetStepMeta.getName());
        rep.saveStepAttribute(id_transformation, id_step, "result_files_file_name_field", this.resultFilesFileNameField);
        rep.saveStepAttribute(id_transformation, id_step, F_EXECUTOR_OUTPUT_STEP, this.executorsOutputStepMeta == null ? null : this.executorsOutputStepMeta.getName());
    }

    @Override
    public void setDefault() {
        this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
        this.parameters = new TransExecutorParameters();
        this.parameters.setInheritingAllVariables(true);
        this.groupSize = "1";
        this.groupField = "";
        this.groupTime = "";
        this.executionTimeField = "ExecutionTime";
        this.executionResultField = "ExecutionResult";
        this.executionNrErrorsField = "ExecutionNrErrors";
        this.executionLinesReadField = "ExecutionLinesRead";
        this.executionLinesWrittenField = "ExecutionLinesWritten";
        this.executionLinesInputField = "ExecutionLinesInput";
        this.executionLinesOutputField = "ExecutionLinesOutput";
        this.executionLinesRejectedField = "ExecutionLinesRejected";
        this.executionLinesUpdatedField = "ExecutionLinesUpdated";
        this.executionLinesDeletedField = "ExecutionLinesDeleted";
        this.executionFilesRetrievedField = "ExecutionFilesRetrieved";
        this.executionExitStatusField = "ExecutionExitStatus";
        this.executionLogTextField = "ExecutionLogText";
        this.executionLogChannelIdField = "ExecutionLogChannelId";
        this.resultFilesFileNameField = "FileName";
    }

    void prepareExecutionResultsFields(RowMetaInterface row, StepMeta nextStep) throws KettleStepException {
        if (nextStep != null && this.executionResultTargetStepMeta != null) {
            this.addFieldToRow(row, this.executionTimeField, 5, 15, 0);
            this.addFieldToRow(row, this.executionResultField, 4);
            this.addFieldToRow(row, this.executionNrErrorsField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesReadField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesWrittenField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesInputField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesOutputField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesRejectedField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesUpdatedField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesDeletedField, 5, 9, 0);
            this.addFieldToRow(row, this.executionFilesRetrievedField, 5, 9, 0);
            this.addFieldToRow(row, this.executionExitStatusField, 5, 3, 0);
            this.addFieldToRow(row, this.executionLogTextField, 2);
            this.addFieldToRow(row, this.executionLogChannelIdField, 2, 50, 0);
        }
    }

    protected void addFieldToRow(RowMetaInterface row, String fieldName, int type) throws KettleStepException {
        this.addFieldToRow(row, fieldName, type, -1, -1);
    }

    protected void addFieldToRow(RowMetaInterface row, String fieldName, int type, int length, int precision) throws KettleStepException {
        if (!Utils.isEmpty((CharSequence)fieldName)) {
            try {
                ValueMetaInterface value = ValueMetaFactory.createValueMeta((String)fieldName, (int)type, (int)length, (int)precision);
                value.setOrigin(this.getParentStepMeta().getName());
                row.addValueMeta(value);
            }
            catch (KettlePluginException e) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"TransExecutorMeta.ValueMetaInterfaceCreation", (String[])new String[]{fieldName}), (Throwable)e);
            }
        }
    }

    void prepareExecutionResultsFileFields(RowMetaInterface row, StepMeta nextStep) throws KettleStepException {
        if (nextStep != null && this.resultFilesTargetStepMeta != null && nextStep.equals(this.resultFilesTargetStepMeta)) {
            this.addFieldToRow(row, this.resultFilesFileNameField, 2);
        }
    }

    void prepareResultsRowsFields(RowMetaInterface row) throws KettleStepException {
        for (int i = 0; i < this.outputRowsField.length; ++i) {
            this.addFieldToRow(row, this.outputRowsField[i], this.outputRowsType[i], this.outputRowsLength[i], this.outputRowsPrecision[i]);
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (nextStep != null) {
            if (nextStep.equals(this.executionResultTargetStepMeta)) {
                inputRowMeta.clear();
                this.prepareExecutionResultsFields(inputRowMeta, nextStep);
            } else if (nextStep.equals(this.resultFilesTargetStepMeta)) {
                inputRowMeta.clear();
                this.prepareExecutionResultsFileFields(inputRowMeta, nextStep);
            } else if (nextStep.equals(this.outputRowsSourceStepMeta)) {
                inputRowMeta.clear();
                this.prepareResultsRowsFields(inputRowMeta);
            }
        }
    }

    public String[] getInfoSteps() {
        String[] infoSteps = this.getStepIOMeta().getInfoStepnames();
        return infoSteps.length == 0 ? null : infoSteps;
    }

    @Deprecated
    public static TransMeta loadTransMeta(TransExecutorMeta executorMeta, Repository rep, VariableSpace space) throws KettleException {
        return TransExecutorMeta.loadMappingMeta(executorMeta, rep, null, space);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"TransExecutorMeta.CheckResult.NotReceivingAnyFields", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TransExecutorMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TransExecutorMeta.CheckResult.StepReceivingFieldsFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TransExecutorMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new TransExecutor(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        String realFilename = transMeta.environmentSubstitute(this.fileName);
        String realTransname = transMeta.environmentSubstitute(this.transName);
        String realDirectoryPath = transMeta.environmentSubstitute(this.directoryPath);
        ResourceReference reference = new ResourceReference(stepInfo);
        if (!Utils.isEmpty((CharSequence)realFilename)) {
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.ACTIONFILE));
        } else if (!Utils.isEmpty((CharSequence)realTransname)) {
            String realTransformation = realDirectoryPath + "/" + this.transName;
            reference.getEntries().add(new ResourceEntry(realTransformation, ResourceEntry.ResourceType.ACTIONFILE));
        }
        references.add(reference);
        return references;
    }

    @Override
    public StepDataInterface getStepData() {
        return new TransExecutorData();
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        StepIOMetaInterface ioMeta = super.getStepIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new StepIOMeta(true, true, true, false, true, false);
            ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, this.executionResultTargetStepMeta, BaseMessages.getString(PKG, (String)"TransExecutorMeta.ResultStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, this.outputRowsSourceStepMeta, BaseMessages.getString(PKG, (String)"TransExecutorMeta.ResultRowsStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, this.resultFilesTargetStepMeta, BaseMessages.getString(PKG, (String)"TransExecutorMeta.ResultFilesStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, this.executorsOutputStepMeta, BaseMessages.getString(PKG, (String)"TransExecutorMeta.ExecutorOutputStream.Description", (String[])new String[0]), StreamIcon.OUTPUT, null));
            this.setStepIOMeta(ioMeta);
        }
        return ioMeta;
    }

    @Override
    public void handleStreamSelection(StreamInterface stream) {
        List<StreamInterface> targets = this.getStepIOMeta().getTargetStreams();
        int index = targets.indexOf(stream);
        StepMeta step = targets.get(index).getStepMeta();
        switch (index) {
            case 0: {
                this.setExecutionResultTargetStepMeta(step);
                break;
            }
            case 1: {
                this.setOutputRowsSourceStepMeta(step);
                break;
            }
            case 2: {
                this.setResultFilesTargetStepMeta(step);
                break;
            }
            case 3: {
                this.setExecutorsOutputStepMeta(step);
            }
        }
    }

    @Override
    public void resetStepIoMeta() {
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        this.executionResultTargetStepMeta = StepMeta.findStep(steps, this.executionResultTargetStep);
        this.outputRowsSourceStepMeta = StepMeta.findStep(steps, this.outputRowsSourceStep);
        this.resultFilesTargetStepMeta = StepMeta.findStep(steps, this.resultFilesTargetStep);
        this.executorsOutputStepMeta = StepMeta.findStep(steps, this.executorsOutputStep);
    }

    @Override
    public TransMeta.TransformationType[] getSupportedTransformationTypes() {
        return new TransMeta.TransformationType[]{TransMeta.TransformationType.Normal};
    }

    @Override
    public boolean hasRepositoryReferences() {
        return this.specificationMethod == ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
    }

    @Override
    public void lookupRepositoryReferences(Repository repository) throws KettleException {
        RepositoryDirectoryInterface repositoryDirectoryInterface = RepositoryImportLocation.getRepositoryImportLocation().findDirectory(this.directoryPath);
        this.transObjectId = repository.getTransformationID(this.transName, repositoryDirectoryInterface);
    }

    public TransExecutorParameters getMappingParameters() {
        return this.parameters;
    }

    public void setMappingParameters(TransExecutorParameters mappingParameters) {
        this.parameters = mappingParameters;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public TransExecutorParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(TransExecutorParameters parameters) {
        this.parameters = parameters;
    }

    public String getExecutionTimeField() {
        return this.executionTimeField;
    }

    public void setExecutionTimeField(String executionTimeField) {
        this.executionTimeField = executionTimeField;
    }

    public String getExecutionResultField() {
        return this.executionResultField;
    }

    public void setExecutionResultField(String executionResultField) {
        this.executionResultField = executionResultField;
    }

    public String getExecutionNrErrorsField() {
        return this.executionNrErrorsField;
    }

    public void setExecutionNrErrorsField(String executionNrErrorsField) {
        this.executionNrErrorsField = executionNrErrorsField;
    }

    public String getExecutionLinesReadField() {
        return this.executionLinesReadField;
    }

    public void setExecutionLinesReadField(String executionLinesReadField) {
        this.executionLinesReadField = executionLinesReadField;
    }

    public String getExecutionLinesWrittenField() {
        return this.executionLinesWrittenField;
    }

    public void setExecutionLinesWrittenField(String executionLinesWrittenField) {
        this.executionLinesWrittenField = executionLinesWrittenField;
    }

    public String getExecutionLinesInputField() {
        return this.executionLinesInputField;
    }

    public void setExecutionLinesInputField(String executionLinesInputField) {
        this.executionLinesInputField = executionLinesInputField;
    }

    public String getExecutionLinesOutputField() {
        return this.executionLinesOutputField;
    }

    public void setExecutionLinesOutputField(String executionLinesOutputField) {
        this.executionLinesOutputField = executionLinesOutputField;
    }

    public String getExecutionLinesRejectedField() {
        return this.executionLinesRejectedField;
    }

    public void setExecutionLinesRejectedField(String executionLinesRejectedField) {
        this.executionLinesRejectedField = executionLinesRejectedField;
    }

    public String getExecutionLinesUpdatedField() {
        return this.executionLinesUpdatedField;
    }

    public void setExecutionLinesUpdatedField(String executionLinesUpdatedField) {
        this.executionLinesUpdatedField = executionLinesUpdatedField;
    }

    public String getExecutionLinesDeletedField() {
        return this.executionLinesDeletedField;
    }

    public void setExecutionLinesDeletedField(String executionLinesDeletedField) {
        this.executionLinesDeletedField = executionLinesDeletedField;
    }

    public String getExecutionFilesRetrievedField() {
        return this.executionFilesRetrievedField;
    }

    public void setExecutionFilesRetrievedField(String executionFilesRetrievedField) {
        this.executionFilesRetrievedField = executionFilesRetrievedField;
    }

    public String getExecutionExitStatusField() {
        return this.executionExitStatusField;
    }

    public void setExecutionExitStatusField(String executionExitStatusField) {
        this.executionExitStatusField = executionExitStatusField;
    }

    public String getExecutionLogTextField() {
        return this.executionLogTextField;
    }

    public void setExecutionLogTextField(String executionLogTextField) {
        this.executionLogTextField = executionLogTextField;
    }

    public String getExecutionLogChannelIdField() {
        return this.executionLogChannelIdField;
    }

    public void setExecutionLogChannelIdField(String executionLogChannelIdField) {
        this.executionLogChannelIdField = executionLogChannelIdField;
    }

    public String getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(String groupSize) {
        this.groupSize = groupSize;
    }

    public String getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String groupField) {
        this.groupField = groupField;
    }

    public String getGroupTime() {
        return this.groupTime;
    }

    public void setGroupTime(String groupTime) {
        this.groupTime = groupTime;
    }

    @Override
    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }

    public String getExecutionResultTargetStep() {
        return this.executionResultTargetStep;
    }

    public void setExecutionResultTargetStep(String executionResultTargetStep) {
        this.executionResultTargetStep = executionResultTargetStep;
    }

    public StepMeta getExecutionResultTargetStepMeta() {
        return this.executionResultTargetStepMeta;
    }

    public void setExecutionResultTargetStepMeta(StepMeta executionResultTargetStepMeta) {
        this.executionResultTargetStepMeta = executionResultTargetStepMeta;
    }

    public String getResultFilesFileNameField() {
        return this.resultFilesFileNameField;
    }

    public void setResultFilesFileNameField(String resultFilesFileNameField) {
        this.resultFilesFileNameField = resultFilesFileNameField;
    }

    @Override
    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"TransExecutorMeta.ReferencedObject.Description", (String[])new String[0])};
    }

    private boolean isTransDefined() {
        return !Utils.isEmpty((CharSequence)this.fileName) || this.transObjectId != null || !Utils.isEmpty((CharSequence)this.directoryPath) && !Utils.isEmpty((CharSequence)this.transName);
    }

    @Override
    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isTransDefined()};
    }

    @Override
    public Object loadReferencedObject(int index, Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        return TransExecutorMeta.loadMappingMeta(this, rep, metaStore, space);
    }

    public IMetaStore getMetaStore() {
        return this.metaStore;
    }

    public void setMetaStore(IMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    public String getOutputRowsSourceStep() {
        return this.outputRowsSourceStep;
    }

    public void setOutputRowsSourceStep(String outputRowsSourceStep) {
        this.outputRowsSourceStep = outputRowsSourceStep;
    }

    public StepMeta getOutputRowsSourceStepMeta() {
        return this.outputRowsSourceStepMeta;
    }

    public void setOutputRowsSourceStepMeta(StepMeta outputRowsSourceStepMeta) {
        this.outputRowsSourceStepMeta = outputRowsSourceStepMeta;
    }

    public String[] getOutputRowsField() {
        return this.outputRowsField;
    }

    public void setOutputRowsField(String[] outputRowsField) {
        this.outputRowsField = outputRowsField;
    }

    public int[] getOutputRowsType() {
        return this.outputRowsType;
    }

    public void setOutputRowsType(int[] outputRowsType) {
        this.outputRowsType = outputRowsType;
    }

    public int[] getOutputRowsLength() {
        return this.outputRowsLength;
    }

    public void setOutputRowsLength(int[] outputRowsLength) {
        this.outputRowsLength = outputRowsLength;
    }

    public int[] getOutputRowsPrecision() {
        return this.outputRowsPrecision;
    }

    public void setOutputRowsPrecision(int[] outputRowsPrecision) {
        this.outputRowsPrecision = outputRowsPrecision;
    }

    public String getResultFilesTargetStep() {
        return this.resultFilesTargetStep;
    }

    public void setResultFilesTargetStep(String resultFilesTargetStep) {
        this.resultFilesTargetStep = resultFilesTargetStep;
    }

    public StepMeta getResultFilesTargetStepMeta() {
        return this.resultFilesTargetStepMeta;
    }

    public void setResultFilesTargetStepMeta(StepMeta resultFilesTargetStepMeta) {
        this.resultFilesTargetStepMeta = resultFilesTargetStepMeta;
    }

    public String getExecutorsOutputStep() {
        return this.executorsOutputStep;
    }

    public void setExecutorsOutputStep(String executorsOutputStep) {
        this.executorsOutputStep = executorsOutputStep;
    }

    public StepMeta getExecutorsOutputStepMeta() {
        return this.executorsOutputStepMeta;
    }

    public void setExecutorsOutputStepMeta(StepMeta executorsOutputStepMeta) {
        this.executorsOutputStepMeta = executorsOutputStepMeta;
    }

    @Override
    public boolean cleanAfterHopFromRemove() {
        this.setExecutionResultTargetStepMeta(null);
        this.setOutputRowsSourceStepMeta(null);
        this.setResultFilesTargetStepMeta(null);
        this.setExecutorsOutputStepMeta(null);
        return true;
    }

    @Override
    public boolean cleanAfterHopFromRemove(StepMeta toStep) {
        if (null == toStep || null == toStep.getName()) {
            return false;
        }
        boolean hasChanged = false;
        String toStepName = toStep.getName();
        if (this.getExecutionResultTargetStepMeta() != null && toStepName.equals(this.getExecutionResultTargetStepMeta().getName())) {
            this.setExecutionResultTargetStepMeta(null);
            hasChanged = true;
        } else if (this.getOutputRowsSourceStepMeta() != null && toStepName.equals(this.getOutputRowsSourceStepMeta().getName())) {
            this.setOutputRowsSourceStepMeta(null);
            hasChanged = true;
        } else if (this.getResultFilesTargetStepMeta() != null && toStepName.equals(this.getResultFilesTargetStepMeta().getName())) {
            this.setResultFilesTargetStepMeta(null);
            hasChanged = true;
        } else if (this.getExecutorsOutputStepMeta() != null && toStepName.equals(this.getExecutorsOutputStepMeta().getName())) {
            this.setExecutorsOutputStepMeta(null);
            hasChanged = true;
        }
        return hasChanged;
    }
}

