/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.stepmeta;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.stepmeta.StepMetastructure;
import org.pentaho.di.trans.steps.stepmeta.StepMetastructureData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class StepMetastructureMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = StepMetastructureMeta.class;
    private String fieldName;
    private String comments;
    private String typeName;
    private String positionName;
    private String lengthName;
    private String precisionName;
    private String originName;
    private boolean outputRowcount;
    private String rowcountField;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("      ").append(XMLHandler.addTagValue((String)"outputRowcount", (boolean)this.outputRowcount));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rowcountField", (String)this.rowcountField));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.outputRowcount = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"outputRowcount"));
            this.rowcountField = XMLHandler.getTagValue((Node)stepnode, (String)"rowcountField");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.outputRowcount = rep.getStepAttributeBoolean(id_step, "outputRowcount");
            this.rowcountField = rep.getStepAttributeString(id_step, "rowcountField");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "outputRowcount", this.outputRowcount);
            rep.saveStepAttribute(id_transformation, id_step, "rowcountField", this.rowcountField);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new StepMetastructure(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new StepMetastructureData();
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = new CheckResult(1, "Not implemented", (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        r.clear();
        this.setDefault();
        ValueMetaInteger positionFieldValue = new ValueMetaInteger(this.positionName);
        positionFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)positionFieldValue);
        ValueMetaString nameFieldValue = new ValueMetaString(this.fieldName);
        nameFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)nameFieldValue);
        ValueMetaString commentsFieldValue = new ValueMetaString(this.comments);
        nameFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)commentsFieldValue);
        ValueMetaString typeFieldValue = new ValueMetaString(this.typeName);
        typeFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)typeFieldValue);
        ValueMetaInteger lengthFieldValue = new ValueMetaInteger(this.lengthName);
        lengthFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)lengthFieldValue);
        ValueMetaInteger precisionFieldValue = new ValueMetaInteger(this.precisionName);
        precisionFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)precisionFieldValue);
        ValueMetaString originFieldValue = new ValueMetaString(this.originName);
        originFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)originFieldValue);
        if (this.isOutputRowcount()) {
            ValueMetaInteger v = new ValueMetaInteger(this.getRowcountField());
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void setDefault() {
        this.positionName = BaseMessages.getString(PKG, (String)"StepMetastructureMeta.PositionName", (String[])new String[0]);
        this.fieldName = BaseMessages.getString(PKG, (String)"StepMetastructureMeta.FieldName", (String[])new String[0]);
        this.comments = BaseMessages.getString(PKG, (String)"StepMetastructureMeta.Comments", (String[])new String[0]);
        this.typeName = BaseMessages.getString(PKG, (String)"StepMetastructureMeta.TypeName", (String[])new String[0]);
        this.lengthName = BaseMessages.getString(PKG, (String)"StepMetastructureMeta.LengthName", (String[])new String[0]);
        this.precisionName = BaseMessages.getString(PKG, (String)"StepMetastructureMeta.PrecisionName", (String[])new String[0]);
        this.originName = BaseMessages.getString(PKG, (String)"StepMetastructureMeta.OriginName", (String[])new String[0]);
    }

    public boolean isOutputRowcount() {
        return this.outputRowcount;
    }

    public void setOutputRowcount(boolean outputRowcount) {
        this.outputRowcount = outputRowcount;
    }

    public String getRowcountField() {
        return this.rowcountField;
    }

    public void setRowcountField(String rowcountField) {
        this.rowcountField = rowcountField;
    }
}

