/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.setvalueconstant;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.setvalueconstant.SetValueConstant;
import org.pentaho.di.trans.steps.setvalueconstant.SetValueConstantData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="SetValueConstant.Injection.", groups={"FIELDS", "OPTIONS"})
public class SetValueConstantMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SetValueConstantMeta.class;
    @InjectionDeep
    private List<Field> fields = new ArrayList<Field>();
    @Injection(name="USE_VARIABLE", group="OPTIONS")
    private boolean usevar;

    public Field getField(int i) {
        return this.fields.get(i);
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void setUseVars(boolean usevar) {
        this.usevar = usevar;
    }

    public boolean isUseVars() {
        return this.usevar;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.usevar = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"usevar"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                Field field = new Field();
                field.setFieldName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                field.setReplaceValue(XMLHandler.getTagValue((Node)fnode, (String)"value"));
                field.setReplaceMask(XMLHandler.getTagValue((Node)fnode, (String)"mask"));
                String emptyString = XMLHandler.getTagValue((Node)fnode, (String)"set_empty_string");
                field.setEmptyString(!Utils.isEmpty((CharSequence)emptyString) && "Y".equalsIgnoreCase(emptyString));
                fieldList.add(field);
            }
            this.setFields(fieldList);
        }
        catch (Exception e) {
            throw new KettleXMLException("It was not possible to load the metadata for this step from XML", (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("   " + XMLHandler.addTagValue((String)"usevar", (boolean)this.usevar));
        retval.append("    <fields>" + Const.CR);
        this.fields.forEach(field -> {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)field.getFieldName()));
            retval.append("        " + XMLHandler.addTagValue((String)"value", (String)field.getReplaceValue()));
            retval.append("        " + XMLHandler.addTagValue((String)"mask", (String)field.getReplaceMask()));
            retval.append("        " + XMLHandler.addTagValue((String)"set_empty_string", (boolean)field.isEmptyString()));
            retval.append("        </field>" + Const.CR);
        });
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void setDefault() {
        this.usevar = false;
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.usevar = rep.getStepAttributeBoolean(id_step, "usevar");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (int i = 0; i < nrfields; ++i) {
                Field field = new Field();
                field.setFieldName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setReplaceValue(rep.getStepAttributeString(id_step, i, "replace_value"));
                field.setReplaceMask(rep.getStepAttributeString(id_step, i, "replace_mask"));
                field.setEmptyString(rep.getStepAttributeBoolean(id_step, i, "set_empty_string", false));
                fieldList.add(field);
            }
            this.setFields(fieldList);
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "usevar", this.usevar);
            for (int i = 0; i < this.fields.size(); ++i) {
                Field field = this.fields.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "replace_value", field.getReplaceValue());
                rep.saveStepAttribute(id_transformation, id_step, i, "replace_mask", field.getReplaceMask());
                rep.saveStepAttribute(id_transformation, id_step, i, "set_empty_string", field.isEmptyString());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.fields.size(); ++i) {
                int idx = prev.indexOfValue(this.fields.get(i).getFieldName());
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.fields.get(i).getFieldName() + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.FieldsFound", (String[])new String[]{error_message});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = Utils.isEmpty(this.fields) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.NoFieldsEntered", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new SetValueConstant(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SetValueConstantData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public static class Field {
        @Injection(name="FIELD_NAME", group="FIELDS")
        private String fieldName;
        @Injection(name="REPLACE_VALUE", group="FIELDS")
        private String replaceValue;
        @Injection(name="REPLACE_MASK", group="FIELDS")
        private String replaceMask;
        @Injection(name="EMPTY_STRING", group="FIELDS")
        private boolean setEmptyString;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getReplaceValue() {
            return this.replaceValue;
        }

        public void setReplaceValue(String replaceValue) {
            this.replaceValue = replaceValue;
        }

        public String getReplaceMask() {
            return this.replaceMask;
        }

        public void setReplaceMask(String replaceMask) {
            this.replaceMask = replaceMask;
        }

        public boolean isEmptyString() {
            return this.setEmptyString;
        }

        public void setEmptyString(boolean setEmptyString) {
            this.setEmptyString = setEmptyString;
        }

        public boolean equals(Object obj) {
            return this.fieldName.equals(((Field)obj).getFieldName()) && this.replaceValue.equals(((Field)obj).getReplaceValue()) && this.replaceMask.equals(((Field)obj).getReplaceMask()) && this.setEmptyString == ((Field)obj).isEmptyString();
        }
    }
}

