/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.samplerows;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.samplerows.SampleRows;
import org.pentaho.di.trans.steps.samplerows.SampleRowsData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SampleRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SampleRowsMeta.class;
    private String linesrange;
    private String linenumfield;
    public static String DEFAULT_RANGE = "1";

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (!Utils.isEmpty((CharSequence)this.linenumfield)) {
            ValueMetaInteger v = new ValueMetaInteger(space.environmentSubstitute(this.linenumfield));
            v.setLength(10, 0);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.linesrange = XMLHandler.getTagValue((Node)stepnode, (String)"linesrange");
            this.linenumfield = XMLHandler.getTagValue((Node)stepnode, (String)"linenumfield");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"SampleRowsMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public String getLinesRange() {
        return this.linesrange;
    }

    public void setLinesRange(String linesrange) {
        this.linesrange = linesrange;
    }

    public String getLineNumberField() {
        return this.linenumfield;
    }

    public void setLineNumberField(String linenumfield) {
        this.linenumfield = linenumfield;
    }

    @Override
    public void setDefault() {
        this.linesrange = DEFAULT_RANGE;
        this.linenumfield = null;
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.linesrange = rep.getStepAttributeString(id_step, "linesrange");
            this.linenumfield = rep.getStepAttributeString(id_step, "linenumfield");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SampleRowsMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "linesrange", this.linesrange);
            rep.saveStepAttribute(id_transformation, id_step, "linenumfield", this.linenumfield);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SampleRowsMeta.Exception.UnexpectedErrorSavingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XMLHandler.addTagValue((String)"linesrange", (String)this.linesrange));
        retval.append("    " + XMLHandler.addTagValue((String)"linenumfield", (String)this.linenumfield));
        return retval.toString();
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = Utils.isEmpty((CharSequence)this.linesrange) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.LinesRangeMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.LinesRangeOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = prev == null || prev.size() == 0 ? new CheckResult(3, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new SampleRows(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SampleRowsData();
    }
}

