/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pgpdecryptstream;

import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.pgpencryptfiles.GPG;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.pgpdecryptstream.PGPDecryptStreamData;
import org.pentaho.di.trans.steps.pgpdecryptstream.PGPDecryptStreamMeta;

public class PGPDecryptStream
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = PGPDecryptStreamMeta.class;
    private PGPDecryptStreamMeta meta;
    private PGPDecryptStreamData data;

    public PGPDecryptStream(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block18: {
            this.meta = (PGPDecryptStreamMeta)smi;
            this.data = (PGPDecryptStreamData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            try {
                String encryptedData;
                if (this.first) {
                    this.first = false;
                    this.data.previousRowMeta = this.getInputRowMeta().clone();
                    this.data.NrPrevFields = this.data.previousRowMeta.size();
                    this.data.outputRowMeta = this.data.previousRowMeta;
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                    if (Utils.isEmpty((CharSequence)this.meta.getStreamField())) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Error.DataStreamFieldMissing", (String[])new String[0]));
                    }
                    if (this.meta.isPassphraseFromField()) {
                        String fieldname = this.meta.getPassphraseFieldName();
                        if (Utils.isEmpty((CharSequence)fieldname)) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Error.PassphraseFieldMissing", (String[])new String[0]));
                        }
                        this.data.indexOfPassphraseField = this.data.previousRowMeta.indexOfValue(fieldname);
                        if (this.data.indexOfPassphraseField < 0) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Exception.CouldnotFindField", (String[])new String[]{fieldname}));
                        }
                    } else {
                        this.data.passPhrase = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.meta.getPassphrase()));
                        if (Utils.isEmpty((CharSequence)this.data.passPhrase)) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Error.PassphraseMissing", (String[])new String[0]));
                        }
                    }
                    if (this.data.indexOfField < 0) {
                        this.data.indexOfField = this.data.previousRowMeta.indexOfValue(this.meta.getStreamField());
                        if (this.data.indexOfField < 0) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Exception.CouldnotFindField", (String[])new String[]{this.meta.getStreamField()}));
                        }
                    }
                }
                Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
                for (int i = 0; i < this.data.NrPrevFields; ++i) {
                    outputRow[i] = r[i];
                }
                if (this.meta.isPassphraseFromField()) {
                    this.data.passPhrase = this.data.previousRowMeta.getString(r, this.data.indexOfPassphraseField);
                    if (Utils.isEmpty((CharSequence)this.data.passPhrase)) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Error.PassphraseMissing", (String[])new String[0]));
                    }
                }
                if (Utils.isEmpty((CharSequence)(encryptedData = this.data.previousRowMeta.getString(r, this.data.indexOfField)))) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Error.DataToDecryptEmpty", (String[])new String[0]));
                }
                String decryptedData = this.data.gpg.decrypt(encryptedData, this.data.passPhrase);
                outputRow[this.data.NrPrevFields] = decryptedData;
                this.putRow(this.data.outputRowMeta, outputRow);
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"PGPDecryptStream.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"PGPDecryptStream.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block18;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "PGPDecryptStreamO01");
            }
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PGPDecryptStreamMeta)smi;
        this.data = (PGPDecryptStreamData)sdi;
        if (super.init(smi, sdi)) {
            if (Utils.isEmpty((CharSequence)this.meta.getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            try {
                this.data.gpg = new GPG(this.environmentSubstitute(this.meta.getGPGLocation()), this.log);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Init.Error", (String[])new String[0]), e);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PGPDecryptStreamMeta)smi;
        this.data = (PGPDecryptStreamData)sdi;
        super.dispose(smi, sdi);
    }
}

