/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mappingoutput;

import java.util.List;
import org.pentaho.di.core.BlockingRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutputData;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutputMeta;

public class MappingOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MappingOutputMeta.class;
    private MappingOutputMeta meta;
    private MappingOutputData data;

    public MappingOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (MappingOutputMeta)smi;
        this.data = (MappingOutputData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.setOutputValueRenames(this.data.outputValueRenames);
            this.meta.setInputValueRenames(this.data.inputValueRenames);
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            int totalsleep = 0;
            if (this.getTrans().getParentTrans() != null) {
                while (!this.isStopped() && !this.getTrans().getParentTrans().isRunning()) {
                    try {
                        totalsleep += 10;
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        this.stopAll();
                    }
                    if (totalsleep <= 60000) continue;
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingOutput.Exception.UnableToConnectWithParentMapping", (String[])new String[]{"" + totalsleep / 1000}));
                }
            }
            if (this.data.targetSteps == null) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"MappingOutput.NoTargetStepSpecified", (String[])new String[]{this.getStepname()}));
            }
        }
        this.putRow(this.data.outputRowMeta, r);
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"MappingOutput.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MappingOutputMeta)smi;
        this.data = (MappingOutputData)sdi;
        return super.init(smi, sdi);
    }

    public void setConnectorSteps(StepInterface[] targetSteps, List<MappingValueRename> inputValueRenames, List<MappingValueRename> outputValueRenames) {
        for (int i = 0; i < targetSteps.length; ++i) {
            BlockingRowSet rowSet = new BlockingRowSet(this.getTransMeta().getSizeRowset());
            rowSet.setThreadNameFromToCopy(this.getStepname(), 0, targetSteps[i].getStepname(), 0);
            this.addRowSetToOutputRowSets((RowSet)rowSet);
            targetSteps[i].addRowSetToInputRowSets((RowSet)rowSet);
        }
        this.data.inputValueRenames = inputValueRenames;
        this.data.outputValueRenames = outputValueRenames;
        this.data.targetSteps = targetSteps;
    }
}

