/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldifinput;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ldifinput.LDIFInput;
import org.pentaho.di.trans.steps.ldifinput.LDIFInputData;
import org.pentaho.di.trans.steps.ldifinput.LDIFInputField;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class LDIFInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = LDIFInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private static final String NO = "N";
    private static final String YES = "Y";
    private String[] fileName;
    private String[] fileMask;
    private String[] excludeFileMask;
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    private LDIFInputField[] inputFields;
    private boolean addtoresultfilename;
    private String multiValuedSeparator;
    private boolean includeContentType;
    private String contentTypeField;
    private String DNField;
    private boolean includeDN;
    private boolean filefield;
    private String dynamicFilenameField;
    private String[] fileRequired;
    private String[] includeSubFolders;
    private String shortFileFieldName;
    private String pathFieldName;
    private String hiddenFieldName;
    private String lastModificationTimeFieldName;
    private String uriNameFieldName;
    private String rootUriNameFieldName;
    private String extensionFieldName;
    private String sizeFieldName;

    public String getExtensionField() {
        return this.extensionFieldName;
    }

    public void setExtensionField(String field) {
        this.extensionFieldName = field;
    }

    public String getSizeField() {
        return this.sizeFieldName;
    }

    public void setSizeField(String field) {
        this.sizeFieldName = field;
    }

    public String getShortFileNameField() {
        return this.shortFileFieldName;
    }

    public void setShortFileNameField(String field) {
        this.shortFileFieldName = field;
    }

    public String getPathField() {
        return this.pathFieldName;
    }

    public void setPathField(String field) {
        this.pathFieldName = field;
    }

    @Deprecated
    public String isHiddenField() {
        return this.hiddenFieldName;
    }

    public String getHiddenField() {
        return this.hiddenFieldName;
    }

    @Deprecated
    public void setIsHiddenField(String field) {
        this.hiddenFieldName = field;
    }

    public void setHiddenField(String field) {
        this.hiddenFieldName = field;
    }

    public String getLastModificationDateField() {
        return this.lastModificationTimeFieldName;
    }

    public void setLastModificationDateField(String field) {
        this.lastModificationTimeFieldName = field;
    }

    public String getUriField() {
        return this.uriNameFieldName;
    }

    public void setUriField(String field) {
        this.uriNameFieldName = field;
    }

    public String getRootUriField() {
        return this.rootUriNameFieldName;
    }

    public void setRootUriField(String field) {
        this.rootUriNameFieldName = field;
    }

    @Deprecated
    public String[] getExludeFileMask() {
        return this.excludeFileMask;
    }

    public String[] getExcludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public LDIFInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(LDIFInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public void setFileField(boolean filefield) {
        this.filefield = filefield;
    }

    public boolean isFileField() {
        return this.filefield;
    }

    @Deprecated
    public boolean includeFilename() {
        return this.includeFilename;
    }

    public boolean getIncludeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    @Deprecated
    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public boolean getIncludeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    @Deprecated
    public boolean includeContentType() {
        return this.includeContentType;
    }

    public boolean getIncludeContentType() {
        return this.includeContentType;
    }

    public void setIncludeContentType(boolean includeContentType) {
        this.includeContentType = includeContentType;
    }

    public void setIncludeDN(boolean includeDN) {
        this.includeDN = includeDN;
    }

    @Deprecated
    public boolean IncludeDN() {
        return this.includeDN;
    }

    public boolean getIncludeDN() {
        return this.includeDN;
    }

    public void setMultiValuedSeparator(String multiValuedSeparator) {
        this.multiValuedSeparator = multiValuedSeparator;
    }

    public String getMultiValuedSeparator() {
        return this.multiValuedSeparator;
    }

    public void setAddToResultFilename(boolean addtoresultfilename) {
        this.addtoresultfilename = addtoresultfilename;
    }

    @Deprecated
    public boolean AddToResultFilename() {
        return this.addtoresultfilename;
    }

    public boolean getAddToResultFilename() {
        return this.addtoresultfilename;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public String getDynamicFilenameField() {
        return this.dynamicFilenameField;
    }

    public void setDynamicFilenameField(String dynamicFilenameField) {
        this.dynamicFilenameField = dynamicFilenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public String getContentTypeField() {
        return this.contentTypeField;
    }

    public void setContentTypeField(String contentTypeField) {
        this.contentTypeField = contentTypeField;
    }

    public String getDNField() {
        return this.DNField;
    }

    public void setDNField(String DNField) {
        this.DNField = DNField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        LDIFInputMeta retval = (LDIFInputMeta)super.clone();
        int nrFiles = this.fileName.length;
        int nrFields = this.inputFields.length;
        retval.allocate(nrFiles, nrFields);
        System.arraycopy(this.fileName, 0, retval.fileName, 0, nrFiles);
        System.arraycopy(this.fileMask, 0, retval.fileMask, 0, nrFiles);
        System.arraycopy(this.excludeFileMask, 0, retval.excludeFileMask, 0, nrFiles);
        System.arraycopy(this.fileRequired, 0, retval.fileRequired, 0, nrFiles);
        System.arraycopy(this.includeSubFolders, 0, retval.includeSubFolders, 0, nrFiles);
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (LDIFInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XMLHandler.addTagValue((String)"filefield", (boolean)this.filefield));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dynamicFilenameField", (String)this.dynamicFilenameField));
        retval.append("    " + XMLHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    " + XMLHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    " + XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    " + XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    " + XMLHandler.addTagValue((String)"contenttype", (boolean)this.includeContentType));
        retval.append("    " + XMLHandler.addTagValue((String)"contenttype_field", (String)this.contentTypeField));
        retval.append("    " + XMLHandler.addTagValue((String)"dn_field", (String)this.DNField));
        retval.append("    " + XMLHandler.addTagValue((String)"dn", (boolean)this.includeDN));
        retval.append("    " + XMLHandler.addTagValue((String)"addtoresultfilename", (boolean)this.addtoresultfilename));
        retval.append("    " + XMLHandler.addTagValue((String)"multiValuedSeparator", (String)this.multiValuedSeparator));
        retval.append("    <file>" + Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      " + XMLHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      " + XMLHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_filemask", (String)this.excludeFileMask[i]));
            retval.append("      " + XMLHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append("      " + XMLHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append("      </file>" + Const.CR);
        retval.append("    <fields>" + Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            LDIFInputField field = this.inputFields[i];
            retval.append(field.getXML());
        }
        retval.append("      </fields>" + Const.CR);
        retval.append("    " + XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"shortFileFieldName", (String)this.shortFileFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"pathFieldName", (String)this.pathFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"hiddenFieldName", (String)this.hiddenFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"lastModificationTimeFieldName", (String)this.lastModificationTimeFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"uriNameFieldName", (String)this.uriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rootUriNameFieldName", (String)this.rootUriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"extensionFieldName", (String)this.extensionFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sizeFieldName", (String)this.sizeFieldName));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            this.filefield = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"filefield"));
            this.dynamicFilenameField = XMLHandler.getTagValue((Node)stepnode, (String)"dynamicFilenameField");
            this.includeFilename = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include"));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"include_field");
            this.includeRowNumber = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.includeContentType = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"contenttype"));
            this.contentTypeField = XMLHandler.getTagValue((Node)stepnode, (String)"contenttype_field");
            this.DNField = XMLHandler.getTagValue((Node)stepnode, (String)"dn_field");
            this.includeDN = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"dn"));
            this.addtoresultfilename = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addtoresultfilename"));
            this.multiValuedSeparator = XMLHandler.getTagValue((Node)stepnode, (String)"multiValuedSeparator");
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XMLHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            for (i = 0; i < nrFields; ++i) {
                LDIFInputField field;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = field = new LDIFInputField(fnode);
            }
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            this.shortFileFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"shortFileFieldName");
            this.pathFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"pathFieldName");
            this.hiddenFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"hiddenFieldName");
            this.lastModificationTimeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"lastModificationTimeFieldName");
            this.uriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"uriNameFieldName");
            this.rootUriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"rootUriNameFieldName");
            this.extensionFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"extensionFieldName");
            this.sizeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"sizeFieldName");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrfiles, int nrfields) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
        this.inputFields = new LDIFInputField[nrfields];
    }

    @Override
    public void setDefault() {
        int i;
        this.shortFileFieldName = null;
        this.pathFieldName = null;
        this.hiddenFieldName = null;
        this.lastModificationTimeFieldName = null;
        this.uriNameFieldName = null;
        this.rootUriNameFieldName = null;
        this.extensionFieldName = null;
        this.sizeFieldName = null;
        this.filefield = false;
        this.dynamicFilenameField = "";
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.includeContentType = false;
        this.includeDN = false;
        this.contentTypeField = "";
        this.DNField = "";
        this.multiValuedSeparator = ",";
        this.addtoresultfilename = false;
        int nrFiles = 0;
        int nrFields = 0;
        this.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = RequiredFilesCode[0];
            this.includeSubFolders[i] = RequiredFilesCode[0];
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new LDIFInputField("field" + (i + 1));
        }
        this.rowLimit = 0L;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaString v;
        for (int i = 0; i < this.inputFields.length; ++i) {
            LDIFInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            try {
                ValueMetaInterface v2 = ValueMetaFactory.createValueMeta((String)space.environmentSubstitute(field.getName()), (int)type);
                v2.setLength(field.getLength(), field.getPrecision());
                v2.setOrigin(name);
                r.addValueMeta(v2);
                continue;
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.includeFilename) {
            v = new ValueMetaString(space.environmentSubstitute(this.filenameField));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber) {
            v = new ValueMetaInteger(space.environmentSubstitute(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeContentType) {
            v = new ValueMetaString(space.environmentSubstitute(this.contentTypeField));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeDN) {
            v = new ValueMetaString(space.environmentSubstitute(this.DNField));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getShortFileNameField() != null && this.getShortFileNameField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getShortFileNameField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getExtensionField() != null && this.getExtensionField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getExtensionField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getPathField() != null && this.getPathField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getPathField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getSizeField() != null && this.getSizeField().length() > 0) {
            v = new ValueMetaInteger(space.environmentSubstitute(this.getSizeField()));
            v.setOrigin(name);
            v.setLength(9);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.isHiddenField() != null && this.isHiddenField().length() > 0) {
            v = new ValueMetaBoolean(space.environmentSubstitute(this.isHiddenField()));
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getLastModificationDateField() != null && this.getLastModificationDateField().length() > 0) {
            v = new ValueMetaDate(space.environmentSubstitute(this.getLastModificationDateField()));
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getUriField() != null && this.getUriField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getUriField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getRootUriField() != null && this.getRootUriField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getRootUriField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.filefield = rep.getStepAttributeBoolean(id_step, "filefield");
            this.dynamicFilenameField = rep.getStepAttributeString(id_step, "dynamicFilenameField");
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.addtoresultfilename = rep.getStepAttributeBoolean(id_step, "addtoresultfilename");
            this.multiValuedSeparator = rep.getStepAttributeString(id_step, "multiValuedSeparator");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.includeContentType = rep.getStepAttributeBoolean(id_step, "contenttype");
            this.contentTypeField = rep.getStepAttributeString(id_step, "contenttype_field");
            this.DNField = rep.getStepAttributeString(id_step, "dn_field");
            this.includeDN = rep.getStepAttributeBoolean(id_step, "dn");
            this.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            int nrFiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
                this.excludeFileMask[i] = rep.getStepAttributeString(id_step, i, "exclude_file_mask");
                this.fileRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
                if (!YES.equalsIgnoreCase(this.fileRequired[i])) {
                    this.fileRequired[i] = NO;
                }
                this.includeSubFolders[i] = rep.getStepAttributeString(id_step, i, "include_subfolders");
                if (YES.equalsIgnoreCase(this.includeSubFolders[i])) continue;
                this.includeSubFolders[i] = NO;
            }
            for (i = 0; i < nrFields; ++i) {
                LDIFInputField field = new LDIFInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setAttribut(rep.getStepAttributeString(id_step, i, "field_attribut"));
                field.setType(ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(LDIFInputField.getTrimTypeByCode(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.inputFields[i] = field;
            }
            this.shortFileFieldName = rep.getStepAttributeString(id_step, "shortFileFieldName");
            this.pathFieldName = rep.getStepAttributeString(id_step, "pathFieldName");
            this.hiddenFieldName = rep.getStepAttributeString(id_step, "hiddenFieldName");
            this.lastModificationTimeFieldName = rep.getStepAttributeString(id_step, "lastModificationTimeFieldName");
            this.rootUriNameFieldName = rep.getStepAttributeString(id_step, "rootUriNameFieldName");
            this.extensionFieldName = rep.getStepAttributeString(id_step, "extensionFieldName");
            this.sizeFieldName = rep.getStepAttributeString(id_step, "sizeFieldName");
            this.uriNameFieldName = rep.getStepAttributeString(id_step, "uriNameFieldName");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDIFInputMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "filefield", this.filefield);
            rep.saveStepAttribute(id_transformation, id_step, "dynamicFilenameField", this.dynamicFilenameField);
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "contenttype", this.includeContentType);
            rep.saveStepAttribute(id_transformation, id_step, "contenttype_field", this.contentTypeField);
            rep.saveStepAttribute(id_transformation, id_step, "dn_field", this.DNField);
            rep.saveStepAttribute(id_transformation, id_step, "dn", this.includeDN);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "addtoresultfilename", this.addtoresultfilename);
            rep.saveStepAttribute(id_transformation, id_step, "multiValuedSeparator", this.multiValuedSeparator);
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", this.fileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "exclude_file_mask", this.excludeFileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_required", this.fileRequired[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "include_subfolders", this.includeSubFolders[i]);
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                LDIFInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_attribut", field.getAttribut());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_repeat", field.isRepeated());
            }
            rep.saveStepAttribute(id_transformation, id_step, "shortFileFieldName", this.shortFileFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "pathFieldName", this.pathFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "hiddenFieldName", this.hiddenFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "lastModificationTimeFieldName", this.lastModificationTimeFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "uriNameFieldName", this.uriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "sizeFieldName", this.sizeFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "rootUriNameFieldName", this.rootUriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "extensionFieldName", this.extensionFieldName);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDIFInputMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    public FileInputList getFiles(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    private boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"LDIFInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LDIFInputMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        FileInputList fileInputList = this.getFiles(transMeta);
        if (fileInputList == null || fileInputList.getFiles().size() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"LDIFInputMeta.CheckResult.NoFiles", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LDIFInputMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepDataInterface getStepData() {
        return new LDIFInputData();
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new LDIFInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            if (!this.filefield) {
                for (int i = 0; i < this.fileName.length; ++i) {
                    FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName[i]), (VariableSpace)space);
                    this.fileName[i] = resourceNamingInterface.nameResource(fileObject, space, Utils.isEmpty((CharSequence)this.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

