/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput.store;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputMeta;
import org.pentaho.di.trans.steps.ldapinput.store.KettleTrustManager;
import org.pentaho.di.trans.steps.ldapinput.store.TrustAlwaysManager;

public class CustomSocketFactory
extends SSLSocketFactory {
    private static Class<?> PKG = LDAPInputMeta.class;
    private static AtomicBoolean configured = new AtomicBoolean(false);
    private static TrustManager[] trustManagers = null;
    private static final TrustManager[] ALWAYS_TRUST_MANAGER = new TrustManager[]{new TrustAlwaysManager()};
    private SSLSocketFactory factory;

    public CustomSocketFactory() {
    }

    protected CustomSocketFactory(SSLSocketFactory factory) {
        this.factory = factory;
    }

    public static CustomSocketFactory getDefault() {
        SSLContext ctx;
        if (!configured.get()) {
            throw new IllegalStateException();
        }
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(null, trustManagers, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return new CustomSocketFactory(ctx.getSocketFactory());
    }

    public static synchronized void configure(String path, String password) throws KettleException {
        KeyStore keyStore;
        try {
            keyStore = !Utils.isEmpty((CharSequence)path) && path.endsWith(".p12") ? KeyStore.getInstance("PKCS12") : KeyStore.getInstance("JKS");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"KettleTrustManager.Exception.CouldNotCreateCertStore", (String[])new String[0]), (Throwable)e);
        }
        trustManagers = new KettleTrustManager[]{new KettleTrustManager(keyStore, path, password)};
        configured.set(true);
    }

    public static synchronized void configure() {
        trustManagers = ALWAYS_TRUST_MANAGER;
        configured.set(true);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress client_host, int client_port) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port, client_host, client_port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress client_host, int client_port) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port, client_host, client_port);
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoclose) throws IOException, UnknownHostException {
        return this.factory.createSocket(socket, host, port, autoclose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

