/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.execsqlrow;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.execsqlrow.ExecSQLRow;
import org.pentaho.di.trans.steps.execsqlrow.ExecSQLRowData;
import org.pentaho.di.trans.steps.sql.ExecSQL;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="ExecSQLRowMeta.Injection.", groups={"OUTPUT_FIELDS"})
public class ExecSQLRowMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ExecSQLRowMeta.class;
    private List<? extends SharedObjectInterface> databasesList;
    private DatabaseMeta databaseMeta;
    @Injection(name="SQL_FIELD_NAME")
    private String sqlField;
    @Injection(name="UPDATE_STATS", group="OUTPUT_FIELDS")
    private String updateField;
    @Injection(name="INSERT_STATS", group="OUTPUT_FIELDS")
    private String insertField;
    @Injection(name="DELETE_STATS", group="OUTPUT_FIELDS")
    private String deleteField;
    @Injection(name="READ_STATS", group="OUTPUT_FIELDS")
    private String readField;
    @Injection(name="COMMIT_SIZE")
    private int commitSize;
    @Injection(name="READ_SQL_FROM_FILE")
    private boolean sqlFromfile;
    @Injection(name="SEND_SINGLE_STATEMENT")
    private boolean sendOneStatement;

    @Injection(name="CONNECTION_NAME")
    public void setConnection(String connectionName) {
        this.databaseMeta = DatabaseMeta.findDatabase(this.getDatabasesList(), (String)connectionName);
    }

    public boolean IsSendOneStatement() {
        return this.sendOneStatement;
    }

    public void SetSendOneStatement(boolean sendOneStatement) {
        this.sendOneStatement = sendOneStatement;
    }

    public boolean isSqlFromfile() {
        return this.sqlFromfile;
    }

    public void setSqlFromfile(boolean sqlFromfile) {
        this.sqlFromfile = sqlFromfile;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getSqlFieldName() {
        return this.sqlField;
    }

    public void setSqlFieldName(String sqlField) {
        this.sqlField = sqlField;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public String getDeleteField() {
        return this.deleteField;
    }

    public void setDeleteField(String deleteField) {
        this.deleteField = deleteField;
    }

    public String getInsertField() {
        return this.insertField;
    }

    public void setInsertField(String insertField) {
        this.insertField = insertField;
    }

    public String getReadField() {
        return this.readField;
    }

    public void setReadField(String readField) {
        this.readField = readField;
    }

    public String getUpdateField() {
        return this.updateField;
    }

    public List<? extends SharedObjectInterface> getDatabasesList() {
        return this.databasesList;
    }

    public void setDatabasesList(List<? extends SharedObjectInterface> dbList) {
        this.databasesList = dbList;
    }

    public void setUpdateField(String updateField) {
        this.updateField = updateField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        ExecSQLRowMeta retval = (ExecSQLRowMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        this.databasesList = databases;
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            String csize = XMLHandler.getTagValue((Node)stepnode, (String)"commit");
            this.commitSize = Const.toInt((String)csize, (int)0);
            this.sqlField = XMLHandler.getTagValue((Node)stepnode, (String)"sql_field");
            this.insertField = XMLHandler.getTagValue((Node)stepnode, (String)"insert_field");
            this.updateField = XMLHandler.getTagValue((Node)stepnode, (String)"update_field");
            this.deleteField = XMLHandler.getTagValue((Node)stepnode, (String)"delete_field");
            this.readField = XMLHandler.getTagValue((Node)stepnode, (String)"read_field");
            this.sqlFromfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"sqlFromfile"));
            this.sendOneStatement = "Y".equalsIgnoreCase(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"sendOneStatement"), (String)"Y"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"ExecSQLRowMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.sqlFromfile = false;
        this.commitSize = 1;
        this.databaseMeta = null;
        this.sqlField = null;
        this.sendOneStatement = true;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        RowMetaAndData add = ExecSQL.getResultRow(new Result(), this.getUpdateField(), this.getInsertField(), this.getDeleteField(), this.getReadField());
        r.mergeRowMeta(add.getRowMeta());
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"commit", (int)this.commitSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sql_field", (String)this.sqlField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"insert_field", (String)this.insertField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"update_field", (String)this.updateField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"delete_field", (String)this.deleteField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"read_field", (String)this.readField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sqlFromfile", (boolean)this.sqlFromfile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sendOneStatement", (boolean)this.sendOneStatement));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        this.databasesList = databases;
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.commitSize = (int)rep.getStepAttributeInteger(id_step, "commit");
            this.sqlField = rep.getStepAttributeString(id_step, "sql_field");
            this.insertField = rep.getStepAttributeString(id_step, "insert_field");
            this.updateField = rep.getStepAttributeString(id_step, "update_field");
            this.deleteField = rep.getStepAttributeString(id_step, "delete_field");
            this.readField = rep.getStepAttributeString(id_step, "read_field");
            this.sqlFromfile = rep.getStepAttributeBoolean(id_step, "sqlFromfile");
            String sendOneStatementString = rep.getStepAttributeString(id_step, "sendOneStatement");
            this.sendOneStatement = Utils.isEmpty((CharSequence)sendOneStatementString) ? true : rep.getStepAttributeBoolean(id_step, "sendOneStatement");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ExecSQLRowMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "commit", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "sql_field", this.sqlField);
            rep.saveStepAttribute(id_transformation, id_step, "insert_field", this.insertField);
            rep.saveStepAttribute(id_transformation, id_step, "update_field", this.updateField);
            rep.saveStepAttribute(id_transformation, id_step, "delete_field", this.deleteField);
            rep.saveStepAttribute(id_transformation, id_step, "read_field", this.readField);
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
            rep.saveStepAttribute(id_transformation, id_step, "sqlFromfile", this.sqlFromfile);
            rep.saveStepAttribute(id_transformation, id_step, "sendOneStatement", this.sendOneStatement);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ExecSQLRowMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (this.databaseMeta != null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSQLRowMeta.CheckResult.ConnectionExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            Database db = new Database(loggingObject, this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSQLRowMeta.CheckResult.DBConnectionOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                cr = this.sqlField != null && this.sqlField.length() != 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSQLRowMeta.CheckResult.SQLFieldNameEntered", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSQLRowMeta.CheckResult.SQLFieldNameMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSQLRowMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage(), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSQLRowMeta.CheckResult.ConnectionNeeded", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSQLRowMeta.CheckResult.StepReceivingInfoOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSQLRowMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ExecSQLRow(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ExecSQLRowData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

