/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.exceloutput;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import jxl.format.Alignment;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.UnderlineStyle;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WriteException;

public class ExcelFontMap {
    public static Colour getColour(int stepValue, Colour defaultColour) {
        Colour retval = null;
        if (defaultColour != null) {
            retval = defaultColour;
        }
        if (stepValue != 0) {
            switch (stepValue) {
                case 1: {
                    retval = Colour.BLACK;
                    break;
                }
                case 2: {
                    retval = Colour.WHITE;
                    break;
                }
                case 3: {
                    retval = Colour.RED;
                    break;
                }
                case 4: {
                    retval = Colour.BRIGHT_GREEN;
                    break;
                }
                case 5: {
                    retval = Colour.BLUE;
                    break;
                }
                case 6: {
                    retval = Colour.YELLOW;
                    break;
                }
                case 7: {
                    retval = Colour.PINK;
                    break;
                }
                case 8: {
                    retval = Colour.TURQUOISE;
                    break;
                }
                case 9: {
                    retval = Colour.DARK_RED;
                    break;
                }
                case 10: {
                    retval = Colour.GREEN;
                    break;
                }
                case 11: {
                    retval = Colour.DARK_BLUE;
                    break;
                }
                case 12: {
                    retval = Colour.DARK_YELLOW;
                    break;
                }
                case 13: {
                    retval = Colour.VIOLET;
                    break;
                }
                case 14: {
                    retval = Colour.TEAL;
                    break;
                }
                case 15: {
                    retval = Colour.GREY_25_PERCENT;
                    break;
                }
                case 16: {
                    retval = Colour.GRAY_50;
                    break;
                }
                case 46: {
                    retval = Colour.GRAY_80;
                    break;
                }
                case 17: {
                    retval = Colour.PERIWINKLE;
                    break;
                }
                case 18: {
                    retval = Colour.PLUM;
                    break;
                }
                case 19: {
                    retval = Colour.IVORY;
                    break;
                }
                case 20: {
                    retval = Colour.LIGHT_TURQUOISE;
                    break;
                }
                case 21: {
                    retval = Colour.DARK_PURPLE;
                    break;
                }
                case 22: {
                    retval = Colour.CORAL;
                    break;
                }
                case 23: {
                    retval = Colour.OCEAN_BLUE;
                    break;
                }
                case 24: {
                    retval = Colour.ICE_BLUE;
                    break;
                }
                case 25: {
                    retval = Colour.TURQUOISE;
                    break;
                }
                case 26: {
                    retval = Colour.SKY_BLUE;
                    break;
                }
                case 27: {
                    retval = Colour.LIGHT_GREEN;
                    break;
                }
                case 28: {
                    retval = Colour.VERY_LIGHT_YELLOW;
                    break;
                }
                case 29: {
                    retval = Colour.PALE_BLUE;
                    break;
                }
                case 30: {
                    retval = Colour.ROSE;
                    break;
                }
                case 31: {
                    retval = Colour.LAVENDER;
                    break;
                }
                case 32: {
                    retval = Colour.TAN;
                    break;
                }
                case 33: {
                    retval = Colour.LIGHT_BLUE;
                    break;
                }
                case 34: {
                    retval = Colour.AQUA;
                    break;
                }
                case 35: {
                    retval = Colour.LIME;
                    break;
                }
                case 36: {
                    retval = Colour.GOLD;
                    break;
                }
                case 37: {
                    retval = Colour.LIGHT_ORANGE;
                    break;
                }
                case 38: {
                    retval = Colour.ORANGE;
                    break;
                }
                case 39: {
                    retval = Colour.BLUE_GREY;
                    break;
                }
                case 40: {
                    retval = Colour.GREY_40_PERCENT;
                    break;
                }
                case 41: {
                    retval = Colour.DARK_TEAL;
                    break;
                }
                case 42: {
                    retval = Colour.SEA_GREEN;
                    break;
                }
                case 43: {
                    retval = Colour.DARK_GREEN;
                    break;
                }
                case 44: {
                    retval = Colour.OLIVE_GREEN;
                    break;
                }
                case 45: {
                    retval = Colour.BROWN;
                    break;
                }
            }
        }
        return retval;
    }

    public static WritableCellFormat getOrientation(int stepValue, WritableCellFormat cellFormat) throws WriteException {
        if (stepValue != 0) {
            switch (stepValue) {
                case 1: {
                    cellFormat.setOrientation(Orientation.MINUS_45);
                    break;
                }
                case 2: {
                    cellFormat.setOrientation(Orientation.MINUS_90);
                    break;
                }
                case 3: {
                    cellFormat.setOrientation(Orientation.PLUS_45);
                    break;
                }
                case 4: {
                    cellFormat.setOrientation(Orientation.PLUS_90);
                    break;
                }
                case 5: {
                    cellFormat.setOrientation(Orientation.STACKED);
                    break;
                }
                case 6: {
                    cellFormat.setOrientation(Orientation.VERTICAL);
                    break;
                }
            }
        }
        return cellFormat;
    }

    public static WritableFont.FontName getFontName(int stepValue) {
        WritableFont.FontName headerFontName = WritableFont.ARIAL;
        switch (stepValue) {
            case 1: {
                headerFontName = WritableFont.COURIER;
                break;
            }
            case 2: {
                headerFontName = WritableFont.TAHOMA;
                break;
            }
            case 3: {
                headerFontName = WritableFont.TIMES;
                break;
            }
        }
        return headerFontName;
    }

    public static UnderlineStyle getUnderlineStyle(int stepValue) {
        UnderlineStyle underline = UnderlineStyle.NO_UNDERLINE;
        switch (stepValue) {
            case 1: {
                underline = UnderlineStyle.SINGLE;
                break;
            }
            case 2: {
                underline = UnderlineStyle.SINGLE_ACCOUNTING;
                break;
            }
            case 3: {
                underline = UnderlineStyle.DOUBLE;
                break;
            }
            case 4: {
                underline = UnderlineStyle.DOUBLE_ACCOUNTING;
                break;
            }
        }
        return underline;
    }

    public static WritableCellFormat getAlignment(int stepValue, WritableCellFormat format) throws WriteException {
        if (stepValue != 0) {
            switch (stepValue) {
                case 1: {
                    format.setAlignment(Alignment.RIGHT);
                    break;
                }
                case 2: {
                    format.setAlignment(Alignment.CENTRE);
                    break;
                }
                case 3: {
                    format.setAlignment(Alignment.FILL);
                    break;
                }
                case 4: {
                    format.setAlignment(Alignment.GENERAL);
                    break;
                }
                case 5: {
                    format.setAlignment(Alignment.JUSTIFY);
                    break;
                }
            }
        }
        return format;
    }

    public static Dimension getImageDimension(String filename) throws Exception {
        Dimension m = new Dimension();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(filename);
        int height = image.getHeight(null);
        int width = image.getWidth(null);
        boolean continueLoop = true;
        long timeStart = System.currentTimeMillis();
        while (continueLoop) {
            height = image.getHeight(null);
            width = image.getWidth(null);
            if (height > -1) {
                continueLoop = false;
                continue;
            }
            long now = System.currentTimeMillis();
            if (now >= timeStart + 10000L) {
                throw new Exception("Time out! Can not load image [" + filename + "]!");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        m.height = height;
        m.width = width;
        return m;
    }
}

