/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.dynamicsqlrow;

import java.sql.ResultSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dynamicsqlrow.DynamicSQLRowData;
import org.pentaho.di.trans.steps.dynamicsqlrow.DynamicSQLRowMeta;

public class DynamicSQLRow
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = DynamicSQLRowMeta.class;
    private DynamicSQLRowMeta meta;
    private DynamicSQLRowData data;

    public DynamicSQLRow(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized void lookupValues(RowMetaInterface rowMeta, Object[] rowData) throws KettleException {
        boolean loadFromBuffer = true;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = rowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), new RowMetaInterface[]{this.meta.getTableFields()}, null, this, this.repository, this.metaStore);
            loadFromBuffer = false;
        }
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Log.CheckingRow", (String[])new String[0]) + rowMeta.getString(rowData));
        }
        String sqlTemp = this.getInputRowMeta().getString(rowData, this.data.indexOfSQLField);
        String sql = null;
        sql = this.meta.isVariableReplace() ? this.environmentSubstitute(sqlTemp) : sqlTemp;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Log.SQLStatement", (String[])new String[]{sql}));
        }
        if (this.meta.isQueryOnlyOnChange()) {
            if (loadFromBuffer && this.data.previousSQL != null && !this.data.previousSQL.equals(sql)) {
                loadFromBuffer = false;
            }
            this.data.previousSQL = sql;
        } else {
            loadFromBuffer = false;
        }
        if (loadFromBuffer) {
            this.incrementLinesInput();
            if (!this.data.skipPreviousRow) {
                Object[] newRow = RowDataUtil.resizeArray((Object[])rowData, (int)this.data.outputRowMeta.size());
                int newIndex = rowMeta.size();
                RowMetaInterface addMeta = this.data.db.getReturnRowMeta();
                for (int p = 0; p < this.data.previousrowbuffer.size(); ++p) {
                    Object[] getBufferRow = this.data.previousrowbuffer.get(p);
                    for (int i = 0; i < addMeta.size(); ++i) {
                        newRow[newIndex++] = getBufferRow[i];
                    }
                    this.putRow(this.data.outputRowMeta, this.data.outputRowMeta.cloneRow(newRow));
                }
            }
        } else {
            int newIndex;
            Object[] newRow;
            if (this.meta.isQueryOnlyOnChange()) {
                this.data.previousrowbuffer.clear();
            }
            ResultSet rs = this.data.db.openQuery(sql);
            Object[] add = this.data.db.getRow(rs);
            RowMetaInterface addMeta = this.data.db.getReturnRowMeta();
            if (add != null) {
                int nrTemplateFields = this.data.outputRowMeta.size() - this.getInputRowMeta().size();
                if (addMeta.size() != nrTemplateFields) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Exception.IncorrectNrTemplateFields", (Object[])new Object[]{nrTemplateFields, addMeta.size(), sql}));
                }
                StringBuilder typeErrors = new StringBuilder();
                for (int i = 0; i < addMeta.size(); ++i) {
                    ValueMetaInterface templateValueMeta = addMeta.getValueMeta(i);
                    ValueMetaInterface outputValueMeta = this.data.outputRowMeta.getValueMeta(this.getInputRowMeta().size() + i);
                    if (templateValueMeta.getType() == outputValueMeta.getType()) continue;
                    if (typeErrors.length() > 0) {
                        typeErrors.append(Const.CR);
                    }
                    typeErrors.append(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Exception.TemplateReturnDataTypeError", (String[])new String[]{templateValueMeta.toString(), outputValueMeta.toString()}));
                }
                if (typeErrors.length() > 0) {
                    throw new KettleException(typeErrors.toString());
                }
            }
            this.incrementLinesInput();
            int counter = 0;
            while (add != null && (this.meta.getRowLimit() == 0 || counter < this.meta.getRowLimit())) {
                ++counter;
                newRow = RowDataUtil.resizeArray((Object[])rowData, (int)this.data.outputRowMeta.size());
                newIndex = rowMeta.size();
                for (int i = 0; i < addMeta.size(); ++i) {
                    newRow[newIndex++] = add[i];
                }
                this.putRow(this.data.outputRowMeta, this.data.outputRowMeta.cloneRow(newRow));
                if (this.meta.isQueryOnlyOnChange()) {
                    this.data.previousrowbuffer.add(add);
                    this.data.skipPreviousRow = false;
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Log.PutoutRow", (String[])new String[0]) + this.data.outputRowMeta.getString(newRow));
                }
                if (this.meta.getRowLimit() != 0 && counter >= this.meta.getRowLimit()) continue;
                add = this.data.db.getRow(rs);
                this.incrementLinesInput();
            }
            if (counter == 0 && this.meta.isOuterJoin()) {
                if (this.data.notfound == null) {
                    this.data.notfound = new Object[this.data.db.getReturnRowMeta().size()];
                }
                newRow = RowDataUtil.resizeArray((Object[])rowData, (int)this.data.outputRowMeta.size());
                newIndex = rowMeta.size();
                for (int i = 0; i < this.data.notfound.length; ++i) {
                    newRow[newIndex++] = this.data.notfound[i];
                }
                this.putRow(this.data.outputRowMeta, newRow);
                if (this.meta.isQueryOnlyOnChange()) {
                    this.data.previousrowbuffer.add(this.data.notfound);
                    this.data.skipPreviousRow = false;
                }
            } else if (this.meta.isQueryOnlyOnChange() && counter == 0 && !this.meta.isOuterJoin()) {
                this.data.skipPreviousRow = true;
            }
            if (this.data.db != null) {
                this.data.db.closeQuery(rs);
            }
        }
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block10: {
            this.meta = (DynamicSQLRowMeta)smi;
            this.data = (DynamicSQLRowData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                if (Utils.isEmpty((CharSequence)this.meta.getSQLFieldName())) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Exception.SQLFieldNameEmpty", (String[])new String[0]));
                }
                if (Utils.isEmpty((CharSequence)this.meta.getSql())) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Exception.SQLEmpty", (String[])new String[0]));
                }
                if (this.data.indexOfSQLField < 0) {
                    this.data.indexOfSQLField = this.getInputRowMeta().indexOfValue(this.meta.getSQLFieldName());
                    if (this.data.indexOfSQLField < 0) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Exception.FieldNotFound", (String[])new String[]{this.meta.getSQLFieldName()}));
                    }
                }
            }
            try {
                this.lookupValues(this.getInputRowMeta(), r);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Log.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block10;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "DynamicSQLRow001");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRunning(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (DynamicSQLRowMeta)smi;
        this.data = (DynamicSQLRowData)sdi;
        if (this.data.db != null && !this.data.isCanceled) {
            Database database = this.data.db;
            synchronized (database) {
                this.data.db.cancelQuery();
            }
            this.setStopped(true);
            this.data.isCanceled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        block10: {
            this.meta = (DynamicSQLRowMeta)smi;
            this.data = (DynamicSQLRowData)sdi;
            if (super.init(smi, sdi)) {
                if (this.meta.getDatabaseMeta() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"DynmaicSQLRow.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                    return false;
                }
                this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
                this.data.db.shareVariablesWith((VariableSpace)this);
                try {
                    if (this.getTransMeta().isUsingUniqueConnections()) {
                        Trans trans = this.getTrans();
                        synchronized (trans) {
                            this.data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                        }
                    } else {
                        this.data.db.connect(this.getPartitionID());
                    }
                    this.data.db.setCommit(100);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Log.ConnectedToDB", (String[])new String[0]));
                    }
                    this.data.db.setQueryLimit(this.meta.getRowLimit());
                    return true;
                }
                catch (KettleException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Log.DatabaseError", (String[])new String[0]) + e.getMessage());
                    if (this.data.db == null) break block10;
                    this.data.db.disconnect();
                }
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DynamicSQLRowMeta)smi;
        this.data = (DynamicSQLRowData)sdi;
        if (this.data.db != null) {
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }
}

