/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.RepositoriesMeta;
import org.w3c.dom.Node;

public class BaseRepositoryMeta {
    public static final String ID = "id";
    public static final String DISPLAY_NAME = "displayName";
    public static final String DESCRIPTION = "description";
    public static final String IS_DEFAULT = "isDefault";
    protected String id;
    protected String name;
    protected String description;
    protected Boolean isDefault = false;

    public BaseRepositoryMeta(String id) {
        this.id = id;
    }

    public String getDialogClassName() {
        String className = this.getClass().getCanonicalName();
        if ((className = className.replaceFirst("\\.di\\.", ".di.ui.")).endsWith("Meta")) {
            className = className.substring(0, className.length() - 4);
        }
        className = className + "Dialog";
        return className;
    }

    public String getRevisionBrowserDialogClassName() {
        String className = this.getClass().getCanonicalName();
        if ((className = className.replaceFirst("\\.di\\.", ".di.ui.")).endsWith("Meta")) {
            className = className.substring(0, className.length() - 4);
        }
        className = className + "RevisionBrowserDialog";
        return className;
    }

    public BaseRepositoryMeta(String id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public BaseRepositoryMeta(String id, String name, String description, boolean isDefault) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.isDefault = isDefault;
    }

    public void loadXML(Node repnode, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.id = Const.NVL((String)XMLHandler.getTagValue((Node)repnode, (String)ID), (String)this.id);
            this.name = XMLHandler.getTagValue((Node)repnode, (String)"name");
            this.description = XMLHandler.getTagValue((Node)repnode, (String)DESCRIPTION);
            this.isDefault = Boolean.valueOf(XMLHandler.getTagValue((Node)repnode, (String)"is_default"));
        }
        catch (Exception e) {
            throw new KettleException("Unable to load repository meta object", (Throwable)e);
        }
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(100);
        retval.append("    ").append(XMLHandler.addTagValue((String)ID, (String)this.id));
        retval.append("    ").append(XMLHandler.addTagValue((String)"name", (String)this.name));
        retval.append("    ").append(XMLHandler.addTagValue((String)DESCRIPTION, (String)this.description));
        retval.append("    ").append(XMLHandler.addTagValue((String)"is_default", (String)this.isDefault.toString()));
        return retval.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)ID, (Object)this.getId());
        jsonObject.put((Object)DISPLAY_NAME, (Object)this.getName());
        jsonObject.put((Object)DESCRIPTION, (Object)this.getDescription());
        jsonObject.put((Object)IS_DEFAULT, (Object)this.isDefault());
        return jsonObject;
    }

    public void populate(Map<String, Object> properties, RepositoriesMeta repositoriesMeta) {
        String displayName = (String)properties.get(DISPLAY_NAME);
        String description = (String)properties.get(DESCRIPTION);
        Boolean isDefault = (Boolean)properties.get(IS_DEFAULT);
        this.setName(displayName);
        this.setDescription(description);
        this.setDefault(isDefault);
    }
}

