/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.getpop;

import com.google.common.annotations.VisibleForTesting;
import com.sun.mail.imap.IMAPSSLStore;
import com.sun.mail.pop3.POP3SSLStore;
import jakarta.mail.BodyPart;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.URLName;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.search.AndTerm;
import jakarta.mail.search.BodyTerm;
import jakarta.mail.search.FlagTerm;
import jakarta.mail.search.FromStringTerm;
import jakarta.mail.search.NotTerm;
import jakarta.mail.search.ReceivedDateTerm;
import jakarta.mail.search.RecipientStringTerm;
import jakarta.mail.search.SearchTerm;
import jakarta.mail.search.SubjectTerm;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.getpop.JobEntryGetPOP;

public class MailConnection {
    private static Class<?> PKG = JobEntryGetPOP.class;
    private String server;
    private int port;
    private String username;
    private String password;
    private boolean usessl;
    private boolean write;
    private boolean useproxy;
    private String proxyusername;
    private int protocol;
    private Properties prop;
    private Session session = null;
    private Store store = null;
    private Folder folder = null;
    private Message[] messages;
    private Message message;
    private SearchTerm searchTerm = null;
    private int messagenr;
    private int nrSavedMessages;
    private int nrMovedMessages;
    private int nrDeletedMessages;
    private int nrSavedAttachedFiles;
    private Folder destinationIMAPFolder = null;
    private LogChannelInterface log;

    public MailConnection(LogChannelInterface log, int protocol, String server, int port, String username, String password, boolean usessl, boolean useproxy, String proxyusername) throws KettleException {
        this.log = log;
        try {
            this.prop = System.getProperties();
        }
        catch (SecurityException s) {
            this.prop = new Properties();
        }
        this.port = port;
        this.server = server;
        this.username = username;
        this.password = password;
        this.usessl = usessl;
        this.protocol = protocol;
        this.nrSavedMessages = 0;
        this.nrDeletedMessages = 0;
        this.nrMovedMessages = 0;
        this.nrSavedAttachedFiles = 0;
        this.messagenr = -1;
        this.useproxy = useproxy;
        this.proxyusername = proxyusername;
        try {
            String protocolString;
            if (useproxy) {
                this.prop.put("mail.imap.sasl.enable", "true");
                this.prop.put("mail.imap.sasl.authorizationid", proxyusername);
            }
            if (protocol == 0) {
                this.prop.setProperty("mail.pop3s.rsetbeforequit", "true");
                this.prop.setProperty("mail.pop3.rsetbeforequit", "true");
            } else if (protocol == 2) {
                this.prop.setProperty("mstor.mbox.metadataStrategy", "none");
                this.prop.setProperty("mstor.cache.disabled", "true");
            }
            String string = protocol == 0 ? "pop3" : (protocolString = protocol == 2 ? "mstor" : "imap");
            if (usessl && protocol != 2) {
                this.prop.setProperty("mail." + protocolString + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                this.prop.setProperty("mail." + protocolString + ".socketFactory.fallback", "false");
                this.prop.setProperty("mail." + protocolString + ".port", "" + port);
                this.prop.setProperty("mail." + protocolString + ".socketFactory.port", "" + port);
                this.session = Session.getInstance((Properties)this.prop, null);
                this.session.setDebug(log.isDebug());
                if (this.port == -1) {
                    this.port = protocol == 0 ? 995 : 993;
                }
                URLName url = new URLName(protocolString, server, port, "", username, password);
                this.store = protocol == 0 ? new POP3SSLStore(this.session, url) : new IMAPSSLStore(this.session, url);
                url = null;
            } else {
                this.session = Session.getInstance((Properties)this.prop, null);
                this.session.setDebug(log.isDebug());
                this.store = protocol == 2 ? this.session.getStore(new URLName(protocolString + ":" + server)) : this.session.getStore(protocolString);
            }
            if (log.isDetailed()) {
                log.logDetailed(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.NewConnectionDefined", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.NewConnection", (String[])new String[]{Const.NVL((String)this.server, (String)"")}), (Throwable)e);
        }
    }

    public boolean isConnected() {
        return this.store != null && this.store.isConnected();
    }

    public boolean isUseSSL() {
        return this.usessl;
    }

    public boolean isUseProxy() {
        return this.useproxy;
    }

    public String getProxyUsername() {
        return this.proxyusername;
    }

    public Store getStore() {
        return this.store;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public void connect() throws KettleException {
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Connecting", (String[])new String[]{this.server, this.username, "" + this.port}));
        }
        try {
            if (this.usessl || this.protocol == 2) {
                this.store.connect();
            } else if (this.port > -1) {
                this.store.connect(this.server, this.port, this.username, this.password);
            } else {
                this.store.connect(this.server, this.username, this.password);
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Connected", (String[])new String[]{this.server, this.username, "" + this.port}));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.Connecting", (String[])new String[]{this.server, this.username, Const.NVL((String)("" + this.port), (String)"")}), (Throwable)e);
        }
    }

    public void openFolder(boolean write) throws KettleException {
        this.openFolder(null, true, write);
    }

    public void openFolder(String foldername, boolean write) throws KettleException {
        this.openFolder(foldername, false, write);
    }

    public void openFolder(String foldername, boolean defaultFolder, boolean write) throws KettleException {
        this.write = write;
        try {
            if (this.getFolder() != null) {
                this.closeFolder(true);
            }
            if (defaultFolder) {
                this.folder = this.protocol == 2 ? this.store.getDefaultFolder() : this.getRecursiveFolder("INBOX");
                if (this.folder == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.InvalidDefaultFolder.Label", (String[])new String[0]));
                }
                if ((this.folder.getType() & 1) == 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.DefaultFolderCanNotHoldMessage", (String[])new String[0]));
                }
            } else {
                if (this.protocol == 1 || this.protocol == 2) {
                    this.folder = this.getRecursiveFolder(foldername);
                }
                if (this.folder == null || !this.folder.exists()) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.InvalidFolder.Label", (String[])new String[0]));
                }
            }
            if (this.write) {
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"MailConnection.OpeningFolderInWriteMode.Label", (String[])new String[]{this.getFolderName()}));
                }
                this.folder.open(2);
            } else {
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"MailConnection.OpeningFolderInReadMode.Label", (String[])new String[]{this.getFolderName()}));
                }
                this.folder.open(1);
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.FolderOpened.Label", (String[])new String[]{this.getFolderName()}));
            }
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.FolderOpened.Name", (String[])new String[]{this.getFolderName()}));
                this.log.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.FolderOpened.FullName", (String[])new String[]{this.folder.getFullName()}));
                this.log.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.FolderOpened.Url", (String[])new String[]{this.folder.getURLName().toString()}));
                this.log.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.FolderOpened.Subscribed", (String[])new String[]{"" + this.folder.isSubscribed()}));
            }
        }
        catch (Exception e) {
            throw new KettleException(defaultFolder ? BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.OpeningDefaultFolder", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.OpeningFolder", (String[])new String[]{foldername}), (Throwable)e);
        }
    }

    private Folder getRecursiveFolder(String foldername) throws MessagingException {
        String[] folderparts = foldername.split("/");
        Folder dfolder = this.getStore().getDefaultFolder();
        for (int i = 0; i < folderparts.length; ++i) {
            dfolder = dfolder.getFolder(folderparts[i]);
        }
        return dfolder;
    }

    public void clearFilters() {
        this.nrSavedMessages = 0;
        this.nrDeletedMessages = 0;
        this.nrMovedMessages = 0;
        this.nrSavedAttachedFiles = 0;
        if (this.searchTerm != null) {
            this.searchTerm = null;
        }
    }

    public void disconnect() throws KettleException {
        this.disconnect(true);
    }

    public void closeFolder(boolean expunge) throws KettleException {
        try {
            if (this.folder != null && this.folder.isOpen()) {
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"MailConnection.ClosingFolder", (String[])new String[]{this.getFolderName()}));
                }
                this.folder.close(expunge);
                this.folder = null;
                this.messages = null;
                this.message = null;
                this.messagenr = -1;
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"MailConnection.FolderClosed", (String[])new String[]{this.getFolderName()}));
                }
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.ClosingFolder", (String[])new String[]{this.getFolderName()}), (Throwable)e);
        }
    }

    private void addSearchTerm(SearchTerm term) {
        this.searchTerm = this.searchTerm != null ? new AndTerm(this.searchTerm, term) : term;
    }

    public SearchTerm getSearchTerm() {
        return this.searchTerm;
    }

    public void setSubjectTerm(String subject, boolean notTerm) {
        if (!Utils.isEmpty((CharSequence)subject)) {
            if (notTerm) {
                this.addSearchTerm((SearchTerm)new NotTerm((SearchTerm)new SubjectTerm(subject)));
            } else {
                this.addSearchTerm((SearchTerm)new SubjectTerm(subject));
            }
        }
    }

    public void setBodyTerm(String bodyfilter, boolean notTerm) {
        if (!Utils.isEmpty((CharSequence)bodyfilter)) {
            if (notTerm) {
                this.addSearchTerm((SearchTerm)new NotTerm((SearchTerm)new BodyTerm(bodyfilter)));
            } else {
                this.addSearchTerm((SearchTerm)new BodyTerm(bodyfilter));
            }
        }
    }

    public void setSenderTerm(String sender, boolean notTerm) {
        if (!Utils.isEmpty((CharSequence)sender)) {
            if (notTerm) {
                this.addSearchTerm((SearchTerm)new NotTerm((SearchTerm)new FromStringTerm(sender)));
            } else {
                this.addSearchTerm((SearchTerm)new FromStringTerm(sender));
            }
        }
    }

    public void setReceipientTerm(String receipient) {
        if (!Utils.isEmpty((CharSequence)receipient)) {
            this.addSearchTerm((SearchTerm)new RecipientStringTerm(Message.RecipientType.TO, receipient));
        }
    }

    public void setReceivedDateTermEQ(Date receiveddate) {
        if (this.protocol == 0) {
            this.log.logError(BaseMessages.getString(PKG, (String)"MailConnection.Error.ReceivedDatePOP3Unsupported", (String[])new String[0]));
        } else {
            this.addSearchTerm((SearchTerm)new ReceivedDateTerm(3, receiveddate));
        }
    }

    public void setReceivedDateTermLT(Date futureDate) {
        if (this.protocol == 0) {
            this.log.logError(BaseMessages.getString(PKG, (String)"MailConnection.Error.ReceivedDatePOP3Unsupported", (String[])new String[0]));
        } else {
            this.addSearchTerm((SearchTerm)new ReceivedDateTerm(2, futureDate));
        }
    }

    public void setReceivedDateTermGT(Date pastDate) {
        if (this.protocol == 0) {
            this.log.logError(BaseMessages.getString(PKG, (String)"MailConnection.Error.ReceivedDatePOP3Unsupported", (String[])new String[0]));
        } else {
            this.addSearchTerm((SearchTerm)new ReceivedDateTerm(5, pastDate));
        }
    }

    public void setReceivedDateTermBetween(Date beginDate, Date endDate) {
        if (this.protocol == 0) {
            this.log.logError(BaseMessages.getString(PKG, (String)"MailConnection.Error.ReceivedDatePOP3Unsupported", (String[])new String[0]));
        } else {
            this.addSearchTerm((SearchTerm)new AndTerm((SearchTerm)new ReceivedDateTerm(2, endDate), (SearchTerm)new ReceivedDateTerm(5, beginDate)));
        }
    }

    public void setFlagTermNew() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.RECENT), true));
    }

    public void setFlagTermOld() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.RECENT), false));
    }

    public void setFlagTermRead() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), true));
    }

    public void setFlagTermUnread() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false));
    }

    public void setFlagTermFlagged() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.FLAGGED), true));
    }

    public void setFlagTermNotFlagged() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.FLAGGED), false));
    }

    public void setFlagTermDraft() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.DRAFT), true));
    }

    public void setFlagTermNotDraft() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.DRAFT), false));
    }

    public void retrieveMessages() throws KettleException {
        try {
            this.messages = this.searchTerm != null ? this.folder.search(this.searchTerm) : this.folder.getMessages();
        }
        catch (Exception e) {
            this.messages = null;
            throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.RetrieveMessages", (String[])new String[]{this.getFolderName()}), (Throwable)e);
        }
    }

    public void disconnect(boolean expunge) throws KettleException {
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"MailConnection.ClosingConnection", (String[])new String[0]));
        }
        try {
            this.closeFolder(expunge);
            this.clearFilters();
            if (this.store != null) {
                this.store.close();
                this.store = null;
            }
            if (this.session != null) {
                this.session = null;
            }
            if (this.destinationIMAPFolder != null) {
                this.destinationIMAPFolder.close(expunge);
            }
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"MailConnection.ConnectionClosed", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.ClosingConnection", (String[])new String[0]), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveMessageContentToFile(String filename, String foldername) throws KettleException {
        OutputStream os = null;
        try {
            os = KettleVFS.getOutputStream((String)(foldername + (foldername.endsWith("/") ? "" : "/") + filename), (boolean)false);
            this.getMessage().writeTo(os);
            this.updateSavedMessagesCounter();
            if (os == null) return;
        }
        catch (Exception e) {
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.SavingMessageContent", (String[])new String[]{"" + this.message.getMessageNumber(), filename, foldername}), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        return;
    }

    public void saveAttachedFiles(String foldername) throws KettleException {
        this.saveAttachedFiles(foldername, null);
    }

    public void saveAttachedFiles(String foldername, Pattern pattern) throws KettleException {
        Object content = null;
        try {
            content = this.getMessage().getContent();
            if (content instanceof Multipart) {
                this.handleMultipart(foldername, (Multipart)content, pattern);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.SavingAttachedFiles", (String[])new String[]{"" + this.message.getMessageNumber(), foldername}), (Throwable)e);
        }
        finally {
            if (content != null) {
                content = null;
            }
        }
    }

    private void handleMultipart(String foldername, Multipart multipart, Pattern pattern) throws KettleException {
        try {
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                this.handlePart(foldername, (Part)multipart.getBodyPart(i), pattern);
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    private void handlePart(String foldername, Part part, Pattern pattern) throws KettleException {
        block7: {
            try {
                String filename;
                String disposition = part.getDisposition();
                if (disposition == null || disposition.length() < 1) {
                    disposition = "attachment";
                }
                if (!disposition.equalsIgnoreCase("attachment") && !disposition.equalsIgnoreCase("inline")) break block7;
                String MimeText = null;
                try {
                    MimeText = MimeUtility.decodeText((String)part.getFileName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (MimeText != null && this.isWildcardMatch(filename = MimeUtility.decodeText((String)part.getFileName()), pattern)) {
                    MailConnection.saveFile(foldername, filename, part.getInputStream());
                    this.updateSavedAttachedFilesCounter();
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.AttachedFileSaved", (String[])new String[]{filename, "" + this.getMessage().getMessageNumber(), foldername}));
                    }
                }
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
        }
    }

    @VisibleForTesting
    static String findValidTarget(String folderName, String fileName) throws KettleException {
        if (fileName == null || folderName == null) {
            throw new IllegalArgumentException("Cannot have null arguments to findValidTarget");
        }
        String fileNameRoot = FilenameUtils.getBaseName((String)fileName);
        String ext = "." + FilenameUtils.getExtension((String)fileName);
        if (ext.length() == 1) {
            ext = "";
        }
        String rtn = "";
        String base = FilenameUtils.concat((String)folderName, (String)fileNameRoot);
        int baseSz = base.length();
        StringBuilder build = new StringBuilder(baseSz).append(base);
        int i = -1;
        do {
            build.setLength(baseSz);
            build.append(++i > 0 ? Integer.toString(i) : "").append(ext);
        } while (KettleVFS.fileExists((String)(rtn = build.toString())));
        return rtn;
    }

    private static void saveFile(String foldername, String filename, InputStream input) throws KettleException {
        BufferedOutputStream bos;
        block9: {
            OutputStream fos = null;
            bos = null;
            BufferedInputStream bis = null;
            try {
                String targetFileName;
                if (filename == null) {
                    File f = File.createTempFile("xx", ".out");
                    f.deleteOnExit();
                    filename = f.getName();
                    targetFileName = foldername + "/" + filename;
                } else {
                    targetFileName = MailConnection.findValidTarget(foldername, filename);
                }
                fos = KettleVFS.getOutputStream((String)targetFileName, (boolean)false);
                bos = new BufferedOutputStream(fos);
                bis = new BufferedInputStream(input);
                IOUtils.copy((InputStream)bis, (OutputStream)bos);
                bos.flush();
                if (bis == null) break block9;
            }
            catch (Exception e) {
                try {
                    throw new KettleException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (bis != null) {
                        IOUtils.closeQuietly(bis);
                        bis = null;
                    }
                    if (bos != null) {
                        IOUtils.closeQuietly(bos);
                        bos = null;
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)bis);
            bis = null;
        }
        if (bos != null) {
            IOUtils.closeQuietly((OutputStream)bos);
            bos = null;
        }
    }

    private boolean isWildcardMatch(String filename, Pattern pattern) {
        boolean retval = true;
        if (pattern != null) {
            Matcher matcher = pattern.matcher(filename);
            retval = matcher.matches();
        }
        return retval;
    }

    public void deleteMessage() throws KettleException {
        try {
            this.message.setFlag(Flags.Flag.DELETED, true);
            this.updateDeletedMessagesCounter();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.DeletingMessage", (String[])new String[]{"" + this.getMessage().getMessageNumber()}), (Throwable)e);
        }
    }

    public void setDestinationFolder(String foldername, boolean createFolder) throws KettleException {
        try {
            String[] folderparts = foldername.split("/");
            Folder f = this.getStore().getDefaultFolder();
            for (int i = 0; i < folderparts.length; ++i) {
                if ((f = f.getFolder(folderparts[i])).exists()) continue;
                if (createFolder) {
                    f.create(1);
                    continue;
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.FolderNotFound", (String[])new String[]{foldername}));
            }
            this.destinationIMAPFolder = f;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void moveMessage() throws KettleException {
        try {
            this.folder.copyMessages(new Message[]{this.message}, this.destinationIMAPFolder);
            this.updatedMovedMessagesCounter();
            this.deleteMessage();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.MovingMessage", (String[])new String[]{"" + this.getMessage().getMessageNumber(), this.destinationIMAPFolder.getName()}), (Throwable)e);
        }
    }

    public String getFolderName() {
        if (this.folder == null) {
            return "";
        }
        return this.folder.getName();
    }

    public String getServer() {
        return this.server;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public Message[] getMessages() {
        return this.messages;
    }

    private void updateMessageNr() {
        ++this.messagenr;
    }

    private int getMessageNr() {
        return this.messagenr;
    }

    public void fetchNext() throws KettleException {
        this.updateMessageNr();
        try {
            this.message = this.messages[this.getMessageNr()];
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.FetchingMessages", (String[])new String[0]), (Throwable)e);
        }
    }

    public Message getMessage() {
        return this.message;
    }

    public int getMessagesCount() {
        return this.messages.length;
    }

    public void updateSavedMessagesCounter() {
        ++this.nrSavedMessages;
    }

    public int getSavedMessagesCounter() {
        return this.nrSavedMessages;
    }

    public int getSavedAttachedFilesCounter() {
        return this.nrSavedAttachedFiles;
    }

    public void updateSavedAttachedFilesCounter() {
        ++this.nrSavedAttachedFiles;
    }

    public int getDeletedMessagesCounter() {
        return this.nrDeletedMessages;
    }

    private void updateDeletedMessagesCounter() {
        ++this.nrDeletedMessages;
    }

    private void setDeletedMessagesCounter() {
        this.nrDeletedMessages = this.getMessagesCount();
    }

    public int getMovedMessagesCounter() {
        return this.nrMovedMessages;
    }

    private void updatedMovedMessagesCounter() {
        ++this.nrMovedMessages;
    }

    private void setMovedMessagesCounter() {
        this.nrMovedMessages = this.getMessagesCount();
    }

    public void deleteMessages(boolean setCounter) throws KettleException {
        try {
            this.folder.setFlags(this.messages, new Flags(Flags.Flag.DELETED), true);
            if (setCounter) {
                this.setDeletedMessagesCounter();
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.DeletingMessage", (String[])new String[0]), (Throwable)e);
        }
    }

    public void moveMessages() throws KettleException {
        try {
            this.folder.copyMessages(this.messages, this.destinationIMAPFolder);
            this.deleteMessages(false);
            this.setMovedMessagesCounter();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.MovingMessages", (String[])new String[]{this.destinationIMAPFolder.getName()}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean folderExists(String foldername) {
        boolean retval = false;
        Folder dfolder = null;
        try {
            dfolder = this.getRecursiveFolder(foldername);
            if (dfolder.exists()) {
                retval = true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (dfolder != null) {
                    dfolder.close(false);
                }
            }
            catch (Exception exception) {}
        }
        return retval;
    }

    private HashSet<String> returnSubfolders(Folder folder) throws KettleException {
        HashSet<String> list = new HashSet<String>();
        try {
            if ((folder.getType() & 2) != 0) {
                Folder[] f = folder.list();
                for (int i = 0; i < f.length; ++i) {
                    if ((f[i].getType() & 2) == 0) continue;
                    list.add(f[i].getFullName());
                    list.addAll(this.returnSubfolders(f[i]));
                }
            }
        }
        catch (MessagingException m) {
            throw new KettleException((Throwable)m);
        }
        return list;
    }

    public String[] returnAllFolders(Folder folder) throws KettleException {
        HashSet<Object> list = new HashSet();
        list = this.returnSubfolders(folder);
        return list.toArray(new String[list.size()]);
    }

    public String[] returnAllFolders() throws KettleException {
        return this.returnAllFolders(this.getFolder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] returnAllFolders(String folder) throws KettleException {
        Folder dfolder = null;
        String[] retval = null;
        try {
            dfolder = Utils.isEmpty((CharSequence)folder) ? this.getStore().getDefaultFolder() : this.getStore().getFolder(folder);
            retval = this.returnAllFolders(dfolder);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (dfolder != null) {
                    dfolder.close(false);
                }
            }
            catch (Exception exception) {}
        }
        return retval;
    }

    public String getMessageBody() throws Exception {
        return this.getMessageBody(this.getMessage());
    }

    public String getMessageBody(Message m) throws MessagingException, IOException {
        return this.getMessageBodyOrContentType((Part)m, false);
    }

    public String getMessageBodyContentType(Message m) throws MessagingException, IOException {
        return this.getMessageBodyOrContentType((Part)m, true);
    }

    private String getMessageBodyOrContentType(Part p, boolean returnContentType) throws MessagingException, IOException {
        if (p.isMimeType("text/*")) {
            String s = (String)p.getContent();
            return returnContentType ? p.getContentType() : s;
        }
        if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            String text = null;
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart bp = mp.getBodyPart(i);
                if (!bp.isMimeType("text/plain") || text != null) continue;
                text = this.getMessageBodyOrContentType((Part)bp, returnContentType);
            }
            return text;
        }
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                String s = this.getMessageBodyOrContentType((Part)mp.getBodyPart(i), returnContentType);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    public boolean isMessageNew() {
        return this.isMessageNew(this.getMessage());
    }

    public boolean isMessageNew(Message msg) {
        try {
            return msg.isSet(Flags.Flag.RECENT);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public boolean isMessageRead() {
        return this.isMessageRead(this.getMessage());
    }

    public boolean isMessageRead(Message msg) {
        try {
            return msg.isSet(Flags.Flag.SEEN);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public boolean isMessageFlagged() {
        return this.isMessageFlagged(this.getMessage());
    }

    public boolean isMessageFlagged(Message msg) {
        try {
            return msg.isSet(Flags.Flag.FLAGGED);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public boolean isMessageDeleted() {
        return this.isMessageDeleted(this.getMessage());
    }

    public boolean isMessageDeleted(Message msg) {
        try {
            return msg.isSet(Flags.Flag.DELETED);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public boolean isMessageDraft() {
        return this.isMessageDraft(this.getMessage());
    }

    public boolean isMessageDraft(Message msg) {
        try {
            return msg.isSet(Flags.Flag.DRAFT);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public String toString() {
        if (this.getServer() != null) {
            return this.getServer();
        }
        return "-";
    }

    public int getAttachedFilesCount(Pattern pattern) throws KettleException {
        return this.getAttachedFilesCount(this.getMessage(), pattern);
    }

    public int getAttachedFilesCount(Message message, Pattern pattern) throws KettleException {
        int retval;
        block9: {
            Object content = null;
            retval = 0;
            try {
                content = message.getContent();
                if (!(content instanceof Multipart)) break block9;
                Multipart multipart = (Multipart)content;
                int n = multipart.getCount();
                for (int i = 0; i < n; ++i) {
                    String filename;
                    BodyPart part = multipart.getBodyPart(i);
                    String disposition = part.getDisposition();
                    if (disposition == null || !disposition.equalsIgnoreCase("attachment") && !disposition.equalsIgnoreCase("inline")) continue;
                    String MimeText = null;
                    try {
                        MimeText = MimeUtility.decodeText((String)part.getFileName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (MimeText == null || !this.isWildcardMatch(filename = MimeUtility.decodeText((String)part.getFileName()), pattern)) continue;
                    ++retval;
                }
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.CountingAttachedFiles", (String[])new String[]{"" + this.message.getMessageNumber()}), (Throwable)e);
            }
            finally {
                if (content != null) {
                    content = null;
                }
            }
        }
        return retval;
    }
}

