/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.eval;

import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryEval
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryEval.class;
    private String script;

    public JobEntryEval(String n, String scr) {
        super(n, "");
        this.script = scr;
    }

    public JobEntryEval() {
        this("", "");
    }

    @Override
    public Object clone() {
        JobEntryEval je = (JobEntryEval)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"script", (String)this.script));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.script = XMLHandler.getTagValue((Node)entrynode, (String)"script");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryEval.UnableToLoadFromXml", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.script = rep.getJobEntryAttributeString(id_jobentry, "script");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryEval.UnableToLoadFromRepo", (String[])new String[]{String.valueOf(id_jobentry)}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "script", this.script);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryEval.UnableToSaveToRepo", (String[])new String[]{String.valueOf(id_job)}), (Throwable)dbe);
        }
    }

    public void setScript(String s) {
        this.script = s;
    }

    public String getScript() {
        return this.script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate(Result result, Job parentJob, Result prev_result) {
        Context cx = ContextFactory.getGlobal().enterContext();
        try {
            Scriptable scope = cx.initStandardObjects(null);
            Long errors = new Long(result.getNrErrors());
            Long lines_input = new Long(result.getNrLinesInput());
            Long lines_output = new Long(result.getNrLinesOutput());
            Long lines_updated = new Long(result.getNrLinesUpdated());
            Long lines_rejected = new Long(result.getNrLinesRejected());
            Long lines_read = new Long(result.getNrLinesRead());
            Long lines_written = new Long(result.getNrLinesWritten());
            Long exit_status = new Long(result.getExitStatus());
            Long files_retrieved = new Long(result.getNrFilesRetrieved());
            Long nr = new Long(result.getEntryNr());
            scope.put("errors", scope, (Object)errors);
            scope.put("lines_input", scope, (Object)lines_input);
            scope.put("lines_output", scope, (Object)lines_output);
            scope.put("lines_updated", scope, (Object)lines_updated);
            scope.put("lines_rejected", scope, (Object)lines_rejected);
            scope.put("lines_read", scope, (Object)lines_read);
            scope.put("lines_written", scope, (Object)lines_written);
            scope.put("files_retrieved", scope, (Object)files_retrieved);
            scope.put("exit_status", scope, (Object)exit_status);
            scope.put("nr", scope, (Object)nr);
            scope.put("is_windows", scope, (Object)Const.isWindows());
            scope.put("_entry_", scope, (Object)this);
            Object[] array = null;
            if (result.getRows() != null) {
                array = result.getRows().toArray();
            }
            scope.put("rows", scope, (Object)array);
            scope.put("parent_job", scope, (Object)parentJob);
            scope.put("previous_result", scope, (Object)prev_result);
            try {
                Object res = cx.evaluateString(scope, this.script, "<cmd>", 1, null);
                boolean retval = Context.toBoolean((Object)res);
                result.setNrErrors(0L);
                boolean bl = retval;
                return bl;
            }
            catch (Exception e) {
                boolean bl;
                try {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryEval.CouldNotCompile", (String[])new String[]{e.toString()}));
                    bl = false;
                }
                catch (Exception e2) {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryEval.ErrorEvaluating", (String[])new String[]{e2.toString()}));
                    boolean bl2 = false;
                    return bl2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                Context.exit();
                return bl;
            }
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public Result execute(Result prev_result, int nr) {
        prev_result.setResult(this.evaluate(prev_result, this.parentJob, prev_result));
        return prev_result;
    }

    @Override
    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "script", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

