/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.BaseLogTable;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableCoreInterface;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.repository.RepositoryAttributeInterface;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.w3c.dom.Node;

public class JobLogTable
extends BaseLogTable
implements Cloneable,
LogTableInterface {
    private static Class<?> PKG = JobLogTable.class;
    public static final String XML_TAG = "job-log-table";
    private String logInterval;
    private String logSizeLimit;

    private JobLogTable(VariableSpace space, HasDatabasesInterface databasesInterface) {
        super(space, databasesInterface, null, null, null);
    }

    @Override
    public Object clone() {
        try {
            JobLogTable table = (JobLogTable)super.clone();
            table.fields = new ArrayList();
            for (LogTableField field : this.fields) {
                table.fields.add((LogTableField)field.clone());
            }
            return table;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("      ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        retval.append("        ").append(XMLHandler.addTagValue((String)"connection", (String)this.connectionName));
        retval.append("        ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("        ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("        ").append(XMLHandler.addTagValue((String)"size_limit_lines", (String)this.logSizeLimit));
        retval.append("        ").append(XMLHandler.addTagValue((String)"interval", (String)this.logInterval));
        retval.append("        ").append(XMLHandler.addTagValue((String)"timeout_days", (String)this.timeoutInDays));
        retval.append(super.getFieldsXML());
        retval.append("      ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node node, List<DatabaseMeta> databases, List<StepMeta> steps) {
        this.connectionName = XMLHandler.getTagValue((Node)node, (String)"connection");
        this.schemaName = XMLHandler.getTagValue((Node)node, (String)"schema");
        this.tableName = XMLHandler.getTagValue((Node)node, (String)"table");
        this.logSizeLimit = XMLHandler.getTagValue((Node)node, (String)"size_limit_lines");
        this.logInterval = XMLHandler.getTagValue((Node)node, (String)"interval");
        this.timeoutInDays = XMLHandler.getTagValue((Node)node, (String)"timeout_days");
        super.loadFieldsXML(node);
    }

    @Override
    public void saveToRepository(RepositoryAttributeInterface attributeInterface) throws KettleException {
        super.saveToRepository(attributeInterface);
        attributeInterface.setAttribute(this.getLogTableCode() + PROP_LOG_TABLE_INTERVAL, this.logInterval);
        attributeInterface.setAttribute(this.getLogTableCode() + PROP_LOG_TABLE_SIZE_LIMIT, this.logSizeLimit);
    }

    @Override
    public void loadFromRepository(RepositoryAttributeInterface attributeInterface) throws KettleException {
        super.loadFromRepository(attributeInterface);
        this.logInterval = attributeInterface.getAttributeString(this.getLogTableCode() + PROP_LOG_TABLE_INTERVAL);
        this.logSizeLimit = attributeInterface.getAttributeString(this.getLogTableCode() + PROP_LOG_TABLE_SIZE_LIMIT);
    }

    public void replaceMeta(LogTableCoreInterface logTableInterface) {
        if (!(logTableInterface instanceof JobLogTable)) {
            return;
        }
        JobLogTable logTable = (JobLogTable)logTableInterface;
        super.replaceMeta(logTable);
        this.logInterval = logTable.logInterval;
        this.logSizeLimit = logTable.logSizeLimit;
    }

    public static JobLogTable getDefault(VariableSpace space, HasDatabasesInterface databasesInterface) {
        JobLogTable table = new JobLogTable(space, databasesInterface);
        table.fields.add(new LogTableField(ID.ID_JOB.id, true, false, "ID_JOB", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.BatchID", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.BatchID", (String[])new String[0]), 5, 8));
        table.fields.add(new LogTableField(ID.CHANNEL_ID.id, true, false, "CHANNEL_ID", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.ChannelID", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.ChannelID", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.JOBNAME.id, true, false, "JOBNAME", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.JobName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.JobName", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.STATUS.id, true, false, "STATUS", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.Status", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.Status", (String[])new String[0]), 2, 15));
        table.fields.add(new LogTableField(ID.LINES_READ.id, true, false, "LINES_READ", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.LinesRead", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.LinesRead", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_WRITTEN.id, true, false, "LINES_WRITTEN", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.LinesWritten", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.LinesWritten", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_UPDATED.id, true, false, "LINES_UPDATED", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.LinesUpdated", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.LinesUpdated", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_INPUT.id, true, false, "LINES_INPUT", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.LinesInput", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.LinesInput", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_OUTPUT.id, true, false, "LINES_OUTPUT", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.LinesOutput", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.LinesOutput", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_REJECTED.id, true, false, "LINES_REJECTED", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.LinesRejected", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.LinesRejected", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.ERRORS.id, true, false, "ERRORS", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.Errors", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.Errors", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.STARTDATE.id, true, false, "STARTDATE", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.StartDateRange", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.StartDateRange", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.ENDDATE.id, true, false, "ENDDATE", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.EndDateRange", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.EndDateRange", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.LOGDATE.id, true, false, "LOGDATE", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.LogDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.LogDate", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.DEPDATE.id, true, false, "DEPDATE", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.DepDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.DepDate", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.REPLAYDATE.id, true, false, "REPLAYDATE", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.ReplayDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.ReplayDate", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.LOG_FIELD.id, true, false, "LOG_FIELD", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.LogField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.LogField", (String[])new String[0]), 2, 9999999));
        table.fields.add(new LogTableField(ID.EXECUTING_SERVER.id, false, false, "EXECUTING_SERVER", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.ExecutingServer", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.ExecutingServer", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.EXECUTING_USER.id, false, false, "EXECUTING_USER", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.ExecutingUser", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.ExecutingUser", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.START_JOB_ENTRY.id, false, false, "START_JOB_ENTRY", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.StartingJobEntry", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.StartingJobEntry", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.CLIENT.id, false, false, "CLIENT", BaseMessages.getString(PKG, (String)"JobLogTable.FieldName.Client", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLogTable.FieldDescription.Client", (String[])new String[0]), 2, 255));
        table.findField(ID.ID_JOB).setKey(true);
        table.findField(ID.LOGDATE).setLogDateField(true);
        table.findField(ID.LOG_FIELD).setLogField(true);
        table.findField(ID.CHANNEL_ID).setVisible(false);
        table.findField(ID.JOBNAME).setVisible(false);
        table.findField(ID.STATUS).setStatusField(true);
        table.findField(ID.ERRORS).setErrorsField(true);
        table.findField(ID.JOBNAME).setNameField(true);
        return table;
    }

    public LogTableField findField(ID id) {
        return super.findField(id.id);
    }

    public Object getSubject(ID id) {
        return super.getSubject(id.id);
    }

    public String getSubjectString(ID id) {
        return super.getSubjectString(id.id);
    }

    public void setBatchIdUsed(boolean use) {
        this.findField(ID.ID_JOB).setEnabled(use);
    }

    public boolean isBatchIdUsed() {
        return this.findField(ID.ID_JOB).isEnabled();
    }

    public void setLogFieldUsed(boolean use) {
        this.findField(ID.LOG_FIELD).setEnabled(use);
    }

    public boolean isLogFieldUsed() {
        return this.findField(ID.LOG_FIELD).isEnabled();
    }

    public String getStepnameRead() {
        return this.getSubjectString(ID.LINES_READ);
    }

    public String getStepnameWritten() {
        return this.getSubjectString(ID.LINES_WRITTEN);
    }

    public String getStepnameInput() {
        return this.getSubjectString(ID.LINES_INPUT);
    }

    public String getStepnameOutput() {
        return this.getSubjectString(ID.LINES_OUTPUT);
    }

    public String getStepnameUpdated() {
        return this.getSubjectString(ID.LINES_UPDATED);
    }

    public String getStepnameRejected() {
        return this.getSubjectString(ID.LINES_REJECTED);
    }

    public void setLogInterval(String logInterval) {
        this.logInterval = logInterval;
    }

    public String getLogInterval() {
        return this.logInterval;
    }

    public String getLogSizeLimit() {
        return this.logSizeLimit;
    }

    public void setLogSizeLimit(String logSizeLimit) {
        this.logSizeLimit = logSizeLimit;
    }

    public RowMetaAndData getLogRecord(LogStatus status, Object subject, Object parent) {
        if (subject == null || subject instanceof Job) {
            Job job = (Job)subject;
            Result result = null;
            if (job != null) {
                result = job.getResult();
            }
            RowMetaAndData row = new RowMetaAndData();
            for (LogTableField field : this.fields) {
                if (!field.isEnabled()) continue;
                Object value = null;
                if (job != null) {
                    switch (ID.valueOf(field.getId())) {
                        case ID_JOB: {
                            value = new Long(job.getBatchId());
                            break;
                        }
                        case CHANNEL_ID: {
                            value = job.getLogChannelId();
                            break;
                        }
                        case JOBNAME: {
                            value = job.getJobname();
                            break;
                        }
                        case STATUS: {
                            value = status.getStatus();
                            break;
                        }
                        case LINES_READ: {
                            value = result == null ? null : new Long(result.getNrLinesRead());
                            break;
                        }
                        case LINES_WRITTEN: {
                            value = result == null ? null : new Long(result.getNrLinesWritten());
                            break;
                        }
                        case LINES_INPUT: {
                            value = result == null ? null : new Long(result.getNrLinesInput());
                            break;
                        }
                        case LINES_OUTPUT: {
                            value = result == null ? null : new Long(result.getNrLinesOutput());
                            break;
                        }
                        case LINES_UPDATED: {
                            value = result == null ? null : new Long(result.getNrLinesUpdated());
                            break;
                        }
                        case LINES_REJECTED: {
                            value = result == null ? null : new Long(result.getNrLinesRejected());
                            break;
                        }
                        case ERRORS: {
                            value = result == null ? null : new Long(result.getNrErrors());
                            break;
                        }
                        case STARTDATE: {
                            value = job.getStartDate();
                            break;
                        }
                        case LOGDATE: {
                            value = job.getLogDate();
                            break;
                        }
                        case ENDDATE: {
                            value = job.getEndDate();
                            break;
                        }
                        case DEPDATE: {
                            value = job.getDepDate();
                            break;
                        }
                        case REPLAYDATE: {
                            value = job.getCurrentDate();
                            break;
                        }
                        case LOG_FIELD: {
                            value = this.getLogBuffer(job, job.getLogChannelId(), status, this.logSizeLimit);
                            break;
                        }
                        case EXECUTING_SERVER: {
                            value = job.getExecutingServer();
                            break;
                        }
                        case EXECUTING_USER: {
                            value = job.getExecutingUser();
                            break;
                        }
                        case START_JOB_ENTRY: {
                            value = job.getStartJobEntryCopy() != null ? job.getStartJobEntryCopy().getName() : null;
                            break;
                        }
                        case CLIENT: {
                            value = KettleClientEnvironment.getInstance().getClient() != null ? KettleClientEnvironment.getInstance().getClient().toString() : "unknown";
                            break;
                        }
                    }
                }
                row.addValue(field.getFieldName(), field.getDataType(), value);
                row.getRowMeta().getValueMeta(row.size() - 1).setLength(field.getLength());
            }
            return row;
        }
        return null;
    }

    @Override
    public String getLogTableCode() {
        return "JOB";
    }

    public String getLogTableType() {
        return BaseMessages.getString(PKG, (String)"JobLogTable.Type.Description", (String[])new String[0]);
    }

    @Override
    public String getConnectionNameVariable() {
        return "KETTLE_JOB_LOG_DB";
    }

    @Override
    public String getSchemaNameVariable() {
        return "KETTLE_JOB_LOG_SCHEMA";
    }

    @Override
    public String getTableNameVariable() {
        return "KETTLE_JOB_LOG_TABLE";
    }

    public List<RowMetaInterface> getRecommendedIndexes() {
        LogTableField transNameField;
        LogTableField statusField;
        ArrayList<RowMetaInterface> indexes = new ArrayList<RowMetaInterface>();
        if (this.isBatchIdUsed()) {
            RowMeta batchIndex = new RowMeta();
            LogTableField keyField = this.getKeyField();
            ValueMetaBase keyMeta = new ValueMetaBase(keyField.getFieldName(), keyField.getDataType());
            keyMeta.setLength(keyField.getLength());
            batchIndex.addValueMeta((ValueMetaInterface)keyMeta);
            indexes.add((RowMetaInterface)batchIndex);
        }
        RowMeta lookupIndex = new RowMeta();
        LogTableField errorsField = this.findField(ID.ERRORS);
        if (errorsField != null) {
            ValueMetaBase valueMeta = new ValueMetaBase(errorsField.getFieldName(), errorsField.getDataType());
            valueMeta.setLength(errorsField.getLength());
            lookupIndex.addValueMeta((ValueMetaInterface)valueMeta);
        }
        if ((statusField = this.findField(ID.STATUS)) != null) {
            ValueMetaBase valueMeta = new ValueMetaBase(statusField.getFieldName(), statusField.getDataType());
            valueMeta.setLength(statusField.getLength());
            lookupIndex.addValueMeta((ValueMetaInterface)valueMeta);
        }
        if ((transNameField = this.findField(ID.JOBNAME)) != null) {
            ValueMetaBase valueMeta = new ValueMetaBase(transNameField.getFieldName(), transNameField.getDataType());
            valueMeta.setLength(transNameField.getLength());
            lookupIndex.addValueMeta((ValueMetaInterface)valueMeta);
        }
        indexes.add((RowMetaInterface)lookupIndex);
        return indexes;
    }

    @Override
    public void setAllGlobalParametersToNull() {
        boolean clearGlobalVariables = Boolean.valueOf(System.getProperties().getProperty("KETTLE_GLOBAL_LOG_VARIABLES_CLEAR_ON_EXPORT", "false"));
        if (clearGlobalVariables) {
            super.setAllGlobalParametersToNull();
            this.logInterval = this.isGlobalParameter(this.logInterval) ? null : this.logInterval;
            this.logSizeLimit = this.isGlobalParameter(this.logSizeLimit) ? null : this.logSizeLimit;
        }
    }

    public static enum ID {
        ID_JOB("ID_JOB"),
        CHANNEL_ID("CHANNEL_ID"),
        JOBNAME("JOBNAME"),
        STATUS("STATUS"),
        LINES_READ("LINES_READ"),
        LINES_WRITTEN("LINES_WRITTEN"),
        LINES_UPDATED("LINES_UPDATED"),
        LINES_INPUT("LINES_INPUT"),
        LINES_OUTPUT("LINES_OUTPUT"),
        LINES_REJECTED("LINES_REJECTED"),
        ERRORS("ERRORS"),
        STARTDATE("STARTDATE"),
        ENDDATE("ENDDATE"),
        LOGDATE("LOGDATE"),
        DEPDATE("DEPDATE"),
        REPLAYDATE("REPLAYDATE"),
        LOG_FIELD("LOG_FIELD"),
        EXECUTING_SERVER("EXECUTING_SERVER"),
        EXECUTING_USER("EXECUTING_USER"),
        START_JOB_ENTRY("START_JOB_ENTRY"),
        CLIENT("CLIENT");

        private String id;

        private ID(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

