/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.attributes.metastore;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.di.core.AttributesInterface;
import org.pentaho.di.core.attributes.metastore.AttributesInterfaceEntry;
import org.pentaho.di.core.attributes.metastore.JsonElement;
import org.pentaho.di.core.attributes.metastore.JsonElementType;
import org.pentaho.metastore.api.BaseMetaStore;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreDependenciesExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementExistException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementTypeExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.api.security.IMetaStoreElementOwner;
import org.pentaho.metastore.api.security.MetaStoreElementOwnerType;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreAttribute;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreElement;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreElementOwner;
import org.pentaho.metastore.util.MetaStoreUtil;

public class EmbeddedMetaStore
extends BaseMetaStore
implements ReadWriteLock {
    static final String METASTORE_PREFIX = "METASTORE.";
    static final String TYPE_PREFIX = "TYPE.";
    private final AttributesInterface attributesInterface;
    private final ReadWriteLock lock;

    public EmbeddedMetaStore(AttributesInterface attributesInterface) {
        this.attributesInterface = attributesInterface;
        this.lock = new ReentrantReadWriteLock();
        this.name = UUID.randomUUID().toString();
    }

    public void createNamespace(final String namespace) throws MetaStoreException {
        MetaStoreUtil.executeLockedOperation((Lock)this.writeLock(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String groupName = JsonElementType.groupName(namespace);
                if (!EmbeddedMetaStore.this.attributesInterface.getAttributesMap().containsKey(groupName)) {
                    EmbeddedMetaStore.this.attributesInterface.setAttributes(groupName, (Map)Maps.newHashMap());
                }
                return null;
            }
        });
    }

    public List<String> getNamespaces() throws MetaStoreException {
        return (List)MetaStoreUtil.executeLockedOperation((Lock)this.readLock(), (Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return FluentIterable.from(EmbeddedMetaStore.this.attributesInterface.getAttributesMap().keySet()).filter((Predicate)new Predicate<String>(){

                    public boolean apply(String groupName) {
                        return groupName.startsWith(EmbeddedMetaStore.METASTORE_PREFIX);
                    }
                }).transform((Function)new Function<String, String>(){

                    public String apply(String input) {
                        return input.substring(EmbeddedMetaStore.METASTORE_PREFIX.length());
                    }
                }).toList();
            }
        });
    }

    public boolean namespaceExists(final String namespace) throws MetaStoreException {
        return (Boolean)MetaStoreUtil.executeLockedOperation((Lock)this.readLock(), (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return EmbeddedMetaStore.this.attributesInterface.getAttributesMap().containsKey(JsonElementType.groupName(namespace));
            }
        });
    }

    public synchronized void deleteNamespace(final String namespace) throws MetaStoreException {
        MetaStoreUtil.executeLockedOperation((Lock)this.writeLock(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                List<String> dependencies = EmbeddedMetaStore.this.getElementTypeIds(namespace);
                if (!dependencies.isEmpty()) {
                    throw new MetaStoreDependenciesExistsException(dependencies, "Unable to delete the meta store namespace '" + namespace + "' as it still contains element types");
                }
                EmbeddedMetaStore.this.attributesInterface.getAttributesMap().remove(JsonElementType.groupName(namespace));
                return null;
            }
        });
    }

    public JsonElementType newElementType(String namespace) {
        return new EmbeddedElementType(namespace);
    }

    public void createElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        elementType.setNamespace(namespace);
        if (!this.create(JsonElementType.from(elementType))) {
            throw new MetaStoreElementTypeExistsException(this.getElementTypes(namespace));
        }
    }

    public JsonElementType getElementType(final String namespace, final String elementTypeId) throws MetaStoreException {
        return (JsonElementType)MetaStoreUtil.executeLockedOperation((Lock)this.readLock(), (Callable)new Callable<JsonElementType>(){

            @Override
            public JsonElementType call() throws Exception {
                JsonElementType type = EmbeddedMetaStore.this.newElementType(namespace);
                type.setId(elementTypeId);
                String jsonData = EmbeddedMetaStore.this.attributesInterface.getAttribute(type.groupName(), type.key());
                return jsonData == null ? null : type.load(jsonData);
            }
        });
    }

    public List<String> getElementTypeIds(final String namespace) throws MetaStoreException {
        return (List)MetaStoreUtil.executeLockedOperation((Lock)this.readLock(), (Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                Map attributes = EmbeddedMetaStore.this.attributesInterface.getAttributes(JsonElementType.groupName(namespace));
                return attributes == null ? ImmutableList.of() : ImmutableList.copyOf(attributes.keySet());
            }
        });
    }

    public List<IMetaStoreElementType> getElementTypes(final String namespace) throws MetaStoreException {
        return (List)MetaStoreUtil.executeLockedOperation((Lock)this.readLock(), (Callable)new Callable<List<IMetaStoreElementType>>(){

            @Override
            public List<IMetaStoreElementType> call() throws Exception {
                List<String> ids = EmbeddedMetaStore.this.getElementTypeIds(namespace);
                ArrayList types = Lists.newArrayListWithExpectedSize((int)ids.size());
                for (String id : ids) {
                    types.add(EmbeddedMetaStore.this.getElementType(namespace, id));
                }
                return types;
            }
        });
    }

    public IMetaStoreElementType getElementTypeByName(final String namespace, final String elementTypeName) throws MetaStoreException {
        return (IMetaStoreElementType)MetaStoreUtil.executeLockedOperation((Lock)this.readLock(), (Callable)new Callable<IMetaStoreElementType>(){

            @Override
            public IMetaStoreElementType call() throws Exception {
                List<IMetaStoreElementType> elementTypes = EmbeddedMetaStore.this.getElementTypes(namespace);
                for (IMetaStoreElementType elementType : elementTypes) {
                    if (!elementType.getName().equals(elementTypeName)) continue;
                    return elementType;
                }
                return null;
            }
        });
    }

    public void updateElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        elementType.setNamespace(namespace);
        this.update(JsonElementType.from(elementType));
    }

    public void deleteElementType(final String namespace, final IMetaStoreElementType elementType) throws MetaStoreException {
        MetaStoreUtil.executeLockedOperation((Lock)this.writeLock(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                List<String> dependencies = EmbeddedMetaStore.this.getElementIds(namespace, elementType);
                if (dependencies.isEmpty()) {
                    EmbeddedMetaStore.this.attributesInterface.getAttributesMap().remove(JsonElement.groupName(elementType));
                    Map typeMap = EmbeddedMetaStore.this.attributesInterface.getAttributes(JsonElementType.groupName(namespace));
                    if (typeMap != null) {
                        typeMap.remove(elementType.getId());
                    }
                } else {
                    throw new MetaStoreDependenciesExistsException(dependencies);
                }
                return null;
            }
        });
    }

    public JsonElement newElement() {
        return new JsonElement();
    }

    public JsonElement newElement(IMetaStoreElementType elementType, String id, Object value) {
        return new JsonElement((IMetaStoreElement)new MemoryMetaStoreElement(elementType, id, value));
    }

    public IMetaStoreAttribute newAttribute(String id, Object value) {
        return new MemoryMetaStoreAttribute(id, value);
    }

    public IMetaStoreElementOwner newElementOwner(String name, MetaStoreElementOwnerType ownerType) {
        return new MemoryMetaStoreElementOwner(name, ownerType);
    }

    public void createElement(String namespace, IMetaStoreElementType elementType, IMetaStoreElement element) throws MetaStoreException {
        elementType.setNamespace(namespace);
        element.setElementType(elementType);
        this.update(JsonElementType.from(elementType));
        if (!this.create(JsonElement.from(element))) {
            throw new MetaStoreElementExistException(this.getElements(namespace, elementType));
        }
    }

    public List<IMetaStoreElement> getElements(final String namespace, final IMetaStoreElementType elementType) throws MetaStoreException {
        return (List)MetaStoreUtil.executeLockedOperation((Lock)this.readLock(), (Callable)new Callable<List<IMetaStoreElement>>(){

            @Override
            public List<IMetaStoreElement> call() throws Exception {
                List<String> ids = EmbeddedMetaStore.this.getElementIds(namespace, elementType);
                ArrayList types = Lists.newArrayListWithExpectedSize((int)ids.size());
                for (String id : ids) {
                    types.add(EmbeddedMetaStore.this.getElement(namespace, elementType, id));
                }
                return types;
            }
        });
    }

    public List<String> getElementIds(final String namespace, final IMetaStoreElementType elementType) throws MetaStoreException {
        return (List)MetaStoreUtil.executeLockedOperation((Lock)this.readLock(), (Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                elementType.setNamespace(namespace);
                Map attributes = EmbeddedMetaStore.this.attributesInterface.getAttributes(JsonElement.groupName(elementType));
                return attributes == null ? ImmutableList.of() : ImmutableList.copyOf(attributes.keySet());
            }
        });
    }

    public JsonElement getElement(final String namespace, final IMetaStoreElementType elementType, final String elementId) throws MetaStoreException {
        return (JsonElement)MetaStoreUtil.executeLockedOperation((Lock)this.readLock(), (Callable)new Callable<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                JsonElement element = EmbeddedMetaStore.this.newElement();
                elementType.setNamespace(namespace);
                element.setId(elementId);
                element.setElementType(elementType);
                String jsonData = EmbeddedMetaStore.this.attributesInterface.getAttribute(element.groupName(), element.key());
                return jsonData == null ? null : element.load(jsonData);
            }
        });
    }

    public IMetaStoreElement getElementByName(String namespace, IMetaStoreElementType elementType, String name) throws MetaStoreException {
        for (IMetaStoreElement element : this.getElements(namespace, elementType)) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public void updateElement(String namespace, IMetaStoreElementType elementType, String elementId, IMetaStoreElement element) throws MetaStoreException {
        elementType.setNamespace(namespace);
        element.setId(elementId);
        element.setElementType(elementType);
        this.update(JsonElementType.from(elementType));
        this.update(JsonElement.from(element));
    }

    public void deleteElement(final String namespace, final IMetaStoreElementType elementType, final String elementId) throws MetaStoreException {
        MetaStoreUtil.executeLockedOperation((Lock)this.writeLock(), (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                elementType.setNamespace(namespace);
                Map attributes = EmbeddedMetaStore.this.attributesInterface.getAttributes(JsonElement.groupName(elementType));
                return attributes != null && attributes.remove(elementId) != null;
            }
        });
    }

    private boolean create(final AttributesInterfaceEntry entry) throws MetaStoreException {
        return (Boolean)MetaStoreUtil.executeLockedOperation((Lock)this.writeLock(), (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String groupName = entry.groupName();
                String key = entry.key();
                String existing = EmbeddedMetaStore.this.attributesInterface.getAttribute(groupName, key);
                if (existing == null) {
                    EmbeddedMetaStore.this.attributesInterface.setAttribute(groupName, key, entry.jsonValue());
                    return true;
                }
                return false;
            }
        });
    }

    private void update(final AttributesInterfaceEntry entry) throws MetaStoreException {
        MetaStoreUtil.executeLockedOperation((Lock)this.writeLock(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                EmbeddedMetaStore.this.attributesInterface.setAttribute(entry.groupName(), entry.key(), entry.jsonValue());
                return null;
            }
        });
    }

    @Override
    public Lock readLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.lock.writeLock();
    }

    private class EmbeddedElementType
    extends JsonElementType {
        public EmbeddedElementType(String namespace) {
            super(namespace);
        }

        public void save() throws MetaStoreException {
            EmbeddedMetaStore.this.update(this);
        }
    }
}

