/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.attributes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Node;

public class AttributesUtil {
    public static final String XML_TAG = "attributes";
    public static final String XML_TAG_GROUP = "group";
    public static final String XML_TAG_ATTRIBUTE = "attribute";

    public static String getAttributesXml(Map<String, Map<String, String>> attributesMap) {
        return AttributesUtil.getAttributesXml(attributesMap, XML_TAG);
    }

    public static String getAttributesXml(Map<String, Map<String, String>> attributesMap, String xmlTag) {
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.openTag((String)xmlTag));
        if (attributesMap != null && !attributesMap.isEmpty()) {
            ArrayList<String> groupNames = new ArrayList<String>(attributesMap.keySet());
            Collections.sort(groupNames);
            for (String groupName : groupNames) {
                xml.append(XMLHandler.openTag((String)XML_TAG_GROUP));
                xml.append(XMLHandler.addTagValue((String)"name", (String)groupName));
                Map<String, String> attributes = attributesMap.get(groupName);
                ArrayList<String> keys = new ArrayList<String>(attributes.keySet());
                for (String key : keys) {
                    xml.append(XMLHandler.openTag((String)XML_TAG_ATTRIBUTE));
                    xml.append(XMLHandler.addTagValue((String)"key", (String)key));
                    xml.append(XMLHandler.addTagValue((String)"value", (String)attributes.get(key)));
                    xml.append(XMLHandler.closeTag((String)XML_TAG_ATTRIBUTE));
                }
                xml.append(XMLHandler.closeTag((String)XML_TAG_GROUP));
            }
        }
        xml.append(XMLHandler.closeTag((String)xmlTag)).append(Const.CR);
        return xml.toString();
    }

    public static Map<String, Map<String, String>> loadAttributes(Node attributesNode) {
        HashMap<String, Map<String, String>> attributesMap = new HashMap<String, Map<String, String>>();
        if (attributesNode != null) {
            List groupNodes = XMLHandler.getNodes((Node)attributesNode, (String)XML_TAG_GROUP);
            for (Node groupNode : groupNodes) {
                String groupName = XMLHandler.getTagValue((Node)groupNode, (String)"name");
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributesMap.put(groupName, attributes);
                List attributeNodes = XMLHandler.getNodes((Node)groupNode, (String)XML_TAG_ATTRIBUTE);
                for (Node attributeNode : attributeNodes) {
                    String key = XMLHandler.getTagValue((Node)attributeNode, (String)"key");
                    String value = XMLHandler.getTagValue((Node)attributeNode, (String)"value");
                    if (key == null || value == null) continue;
                    attributes.put(key, value);
                }
            }
        }
        return attributesMap;
    }
}

