/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.util.StyleUtil;

public abstract class JRFillGraphicElement
extends JRFillElement
implements JRGraphicElement {
    protected final JRPen initPen;
    protected JRPen pen;

    protected JRFillGraphicElement(JRBaseFiller filler, JRGraphicElement graphicElement, JRFillObjectFactory factory) {
        super(filler, graphicElement, factory);
        this.initPen = graphicElement.getLinePen().clone(this);
    }

    protected JRFillGraphicElement(JRFillGraphicElement graphicElement, JRFillCloneFactory factory) {
        super(graphicElement, factory);
        this.initPen = graphicElement.getLinePen().clone(this);
    }

    @Override
    protected void evaluateStyle(byte evaluation) throws JRException {
        super.evaluateStyle(evaluation);
        this.pen = null;
        if (this.providerStyle != null) {
            this.pen = this.initPen.clone(this);
            StyleUtil.appendPen(this.pen, this.providerStyle.getLinePen());
        }
    }

    @Override
    public JRPen getLinePen() {
        return this.pen == null ? this.initPen : this.pen;
    }

    @Override
    public FillEnum getFillValue() {
        return this.getStyleResolver().getFillValue(this);
    }

    @Override
    public FillEnum getOwnFillValue() {
        return this.providerStyle == null || this.providerStyle.getOwnFillValue() == null ? ((JRGraphicElement)this.parent).getOwnFillValue() : this.providerStyle.getOwnFillValue();
    }

    @Override
    public void setFill(FillEnum fill) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float getDefaultLineWidth() {
        return ((JRGraphicElement)this.parent).getDefaultLineWidth();
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public void rewind() {
    }

    @Override
    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        super.prepare(availableHeight, isOverflow);
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
            isToPrint = false;
        }
        if (!(!isToPrint || !this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
            isToPrint = false;
        }
        if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
            isToPrint = false;
            willOverflow = true;
        }
        if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
            isReprinted = true;
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }
}

