/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxBorderHelper;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class PptxCellHelper
extends BaseHelper {
    private static final String VERTICAL_ALIGN_TOP = "top";
    private static final String VERTICAL_ALIGN_MIDDLE = "center";
    private static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    private PptxBorderHelper borderHelper;

    public PptxCellHelper(JasperReportsContext jasperReportsContext, Writer writer) {
        super(jasperReportsContext, writer);
        this.borderHelper = new PptxBorderHelper(jasperReportsContext, writer);
    }

    public PptxBorderHelper getBorderHelper() {
        return this.borderHelper;
    }

    public void exportHeader(JRExporterGridCell gridCell) {
        this.write("    <a:tc");
        if (gridCell.getColSpan() > 1) {
            this.write(" gridSpan=\"" + gridCell.getColSpan() + "\"");
        }
        if (gridCell.getRowSpan() > 1) {
            this.write(" rowSpan=\"" + gridCell.getRowSpan() + "\"");
        }
        this.write(">\n");
    }

    public void exportFooter() {
        this.write("    </a:tc>\n");
    }

    public void exportBackcolor(JRExporterGridCell gridCell) {
        if (gridCell.getCellBackcolor() != null) {
            this.write("  <a:solidFill>\n");
            this.write("    <a:srgbClr val=\"" + JRColorUtil.getColorHexa(gridCell.getCellBackcolor()) + "\"/>\n");
            this.write("  </a:solidFill>\n");
        }
    }

    public void exportAlignmentAndRotation(JRPrintText text) {
        RotationEnum rotation = text == null ? null : text.getRotationValue();
        String verticalAlignment = PptxCellHelper.getVerticalAlignment(text.getVerticalTextAlign());
        String textRotation = PptxCellHelper.getTextDirection(rotation);
        this.exportAlignmentAndRotation(verticalAlignment, textRotation);
    }

    public void exportAlignmentAndRotation(JRPrintImage image) {
        String verticalAlignment = PptxCellHelper.getVerticalImageAlign(image.getVerticalImageAlign());
        this.exportAlignmentAndRotation(verticalAlignment, null);
    }

    private void exportAlignmentAndRotation(String verticalAlignment, String textRotation) {
        if (verticalAlignment != null) {
            this.write("      <a:vAlign a:val=\"" + verticalAlignment + "\" />\n");
        }
        if (textRotation != null) {
            this.write("   <a:textDirection a:val=\"" + textRotation + "\" />\n");
        }
    }

    private static String getTextDirection(RotationEnum rotation) {
        String textDirection = null;
        if (rotation != null) {
            switch (rotation) {
                case LEFT: {
                    textDirection = "btLr";
                    break;
                }
                case RIGHT: {
                    textDirection = "tbRl";
                    break;
                }
            }
        }
        return textDirection;
    }

    public static String getVerticalAlignment(VerticalTextAlignEnum verticalAlignment) {
        if (verticalAlignment != null) {
            switch (verticalAlignment) {
                case BOTTOM: {
                    return VERTICAL_ALIGN_BOTTOM;
                }
                case MIDDLE: {
                    return VERTICAL_ALIGN_MIDDLE;
                }
            }
            return VERTICAL_ALIGN_TOP;
        }
        return null;
    }

    public static String getVerticalImageAlign(VerticalImageAlignEnum verticalAlignment) {
        if (verticalAlignment != null) {
            switch (verticalAlignment) {
                case BOTTOM: {
                    return VERTICAL_ALIGN_BOTTOM;
                }
                case MIDDLE: {
                    return VERTICAL_ALIGN_MIDDLE;
                }
            }
            return VERTICAL_ALIGN_TOP;
        }
        return null;
    }
}

