/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chrome;

public class ChromeInstanceState {
    private final long useCount;
    private final long useTimestamp;
    private final boolean closed;

    public static ChromeInstanceState create() {
        return new ChromeInstanceState(0L, System.currentTimeMillis(), false);
    }

    public ChromeInstanceState(long useCount, long useTimestamp, boolean closed) {
        this.useCount = useCount;
        this.useTimestamp = useTimestamp;
        this.closed = closed;
    }

    public long getUseCount() {
        return this.useCount;
    }

    public long getUseTimestamp() {
        return this.useTimestamp;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public ChromeInstanceState incrementUse() {
        return new ChromeInstanceState(this.useCount + 1L, System.currentTimeMillis(), this.closed);
    }

    public ChromeInstanceState decrementUse() {
        return new ChromeInstanceState(this.useCount - 1L, System.currentTimeMillis(), this.closed);
    }

    public ChromeInstanceState close() {
        return new ChromeInstanceState(this.useCount, this.useTimestamp, true);
    }

    public boolean shouldClose() {
        return this.useCount == 0L && this.closed;
    }
}

