/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.csvinspector;

import com.mindprod.csv.CSVReader;
import de.destatis.core.connect.util.Contract;
import de.destatis.core.csvinspector.CsvInspectionController;
import de.destatis.core.csvinspector.CsvInspectionProblem;
import de.destatis.core.csvinspector.CsvInspectionReport;
import de.destatis.core.csvinspector.CsvInspectionReporter;
import de.destatis.core.csvinspector.FatalException;
import de.destatis.core.inspector.UnitIDVerifierResult;
import de.destatis.core.map.Binding;
import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.Mapping;
import de.destatis.core.map.MappingBuilder;
import de.destatis.core.map.model.BindingHelper;
import de.destatis.core.map.model.HelpFeatureBinding;
import de.destatis.core.map.model.SelectorBinding;
import de.statspez.sdf.generator.inspector.DataInspectionProblem;
import de.statspez.sdf.generator.inspector.DataInspector;
import de.statspez.sdf.generator.inspector.Field;
import de.statspez.sdf.generator.inspector.FieldGroup;
import de.statspez.sdf.generator.inspector.FieldGroupImpl;
import de.statspez.sdf.generator.inspector.FieldImpl;
import de.statspez.sdf.generator.inspector.Report;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.util.SDFUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

public class CsvInspector {
    private static final String UNIT_ID_FEATURE_NAME = SDFUtil.UNITID_VARIABLE_NAME;
    private static final String INVALID_UNIT_ID_ERROR_TEXT = "Die Identifizierung der BerichtseinheitsID ist nicht m\u00f6glich (falsche oder fehlende BerichtseinheitsID). Bitte \u00fcbermitteln Sie die Meldung erneut unter Angabe der ID, die Ihnen das zust\u00e4ndige Statistische Amt mitgeteilt hat.";
    private final MetaErhebungsbeschreibung surveyDefinition;
    private final Mapping mapping;
    private final char separator;
    private final String csvQuote;
    private final char decimalMark;
    private final char thousandsSeparator;
    private final boolean unitIdBasedMultipleReportFormat;
    private final HelpFeatureBinding unitIdFieldBinding;
    private CsvInspectionController inspectionController = null;

    public CsvInspector(char separator, char quote, char decimalMark, char thousandsSeparator, MetaErhebungsbeschreibung surveyDefinition) {
        this(separator, quote, decimalMark, thousandsSeparator, surveyDefinition, null, false);
    }

    public CsvInspector(char separator, char quote, char decimalMark, char thousandsSeparator, MetaErhebungsbeschreibung surveyDefinition, boolean unitIdBasedMultipleReportFormat) {
        this(separator, quote, decimalMark, thousandsSeparator, surveyDefinition, null, unitIdBasedMultipleReportFormat);
    }

    public CsvInspector(char separator, char quote, char decimalMark, char thousandsSeparator, MetaErhebungsbeschreibung surveyDefinition, Mapping mapping) {
        this(separator, quote, decimalMark, thousandsSeparator, surveyDefinition, mapping, false);
    }

    public CsvInspector(char separator, char quote, char decimalMark, char thousandsSeparator, MetaErhebungsbeschreibung surveyDefinition, Mapping mapping, boolean unitIdBasedMultipleReportFormat) {
        Contract.verify((surveyDefinition != null ? 1 : 0) != 0, (String)"Die Erhebungsbeschreibung muss angegeben werden.");
        this.separator = separator;
        this.csvQuote = String.valueOf(quote);
        this.decimalMark = decimalMark;
        this.thousandsSeparator = thousandsSeparator;
        this.surveyDefinition = surveyDefinition;
        this.mapping = mapping != null ? mapping : new MappingBuilder().build(surveyDefinition);
        if (unitIdBasedMultipleReportFormat) {
            Contract.verify((boolean)this.mapping.getHelpFeatureConfig().isEachRecord(), (String)"Mehrfachmeldung ist f\u00fcr die gegebene Hilfsmerkmalkonfiguration nicht m\u00f6glich.");
            Binding binding = BindingHelper.getBindingById((BindingGroup)this.mapping, (String)UNIT_ID_FEATURE_NAME);
            Contract.verify((binding != null ? 1 : 0) != 0, (String)("Kein " + UNIT_ID_FEATURE_NAME + " Binding vorhanden."));
            Contract.verify((boolean)(binding instanceof HelpFeatureBinding), (String)("Kein " + UNIT_ID_FEATURE_NAME + " HelpFeatureBinding vorhanden."));
            this.unitIdFieldBinding = (HelpFeatureBinding)binding;
            Contract.verify((this.unitIdFieldBinding.getPosition() != null ? 1 : 0) != 0, (String)("Keine Position im " + UNIT_ID_FEATURE_NAME + " Binding vorhanden."));
        } else {
            this.unitIdFieldBinding = null;
        }
        this.unitIdBasedMultipleReportFormat = unitIdBasedMultipleReportFormat;
    }

    public void setInspectionController(CsvInspectionController inspectionController) {
        this.inspectionController = inspectionController;
    }

    public CsvInspectionReport inspect(Reader reader) throws IOException {
        boolean unitIdVerificationActive;
        boolean dataInspectionWithoutReportRejection;
        boolean dataInspectionActive;
        CSVReader csvReader = new CSVReader(reader, this.separator, this.csvQuote.charAt(0), true, false, true);
        CsvInspectionReporter inspectionReporter = new CsvInspectionReporter();
        DataInspector dataInspector = new DataInspector(this.surveyDefinition);
        if (this.inspectionController != null) {
            dataInspectionActive = this.inspectionController.dataInspectionIsActive();
            dataInspectionWithoutReportRejection = this.inspectionController.dataInspectionWithoutReportRejection();
            unitIdVerificationActive = this.inspectionController.unitIdVerificationIsActive();
        } else {
            dataInspectionActive = true;
            dataInspectionWithoutReportRejection = true;
            unitIdVerificationActive = false;
        }
        inspectionReporter.setDataInspectionActive(dataInspectionActive);
        inspectionReporter.setDataInspectionWithoutReportRejection(dataInspectionWithoutReportRejection);
        inspectionReporter.setUnitIdVerificationActive(unitIdVerificationActive);
        try {
            try {
                String[] currentFields = this.getAllFieldsInLineOrNull(csvReader);
                int currentLine = 1;
                if (currentFields == null || currentFields.length == 0) {
                    throw new CsvInspectorException("Die CSV-Datei enth\u00e4lt keine Daten.", -1, -1, null, -1, -1);
                }
                Report report = new Report(this.decimalMark, this.thousandsSeparator);
                String previousUnitId = null;
                FieldGroupImpl helpFeatures = null;
                boolean checkHelpFeatures = true;
                inspectionReporter.nextDeclaration();
                while (currentFields != null && currentFields.length > 0) {
                    int column;
                    if (currentLine == 1 || this.unitIdBasedMultipleReportFormat) {
                        if (this.unitIdBasedMultipleReportFormat) {
                            String unitId = this.readFieldValue((FieldBinding)this.unitIdFieldBinding, new FieldGroupImpl(null, null), currentFields, currentLine, inspectionReporter.getDeclarationNo(), 0);
                            if (unitId != null) {
                                unitId = unitId.trim();
                            }
                            if (unitId == null || unitId.length() == 0) {
                                throw new CsvInspectorException("Die BerichtseinheitsID darf nicht leer sein.", inspectionReporter.getDeclarationNo(), -1, UNIT_ID_FEATURE_NAME, currentLine, this.unitIdFieldBinding.getPosition());
                            }
                            if (currentLine > 1) {
                                boolean unitIdChanged;
                                boolean bl = unitIdChanged = !previousUnitId.equals(unitId);
                                if (unitIdChanged) {
                                    DataInspectionProblem[] reportProblems;
                                    previousUnitId = unitId;
                                    checkHelpFeatures = true;
                                    if (dataInspectionActive && (reportProblems = dataInspector.checkReport(report)) != null) {
                                        for (DataInspectionProblem problem : reportProblems) {
                                            int column2;
                                            int line;
                                            if (problem.getContext() != null) {
                                                CsvContext csvContext = (CsvContext)problem.getContext();
                                                line = csvContext.line;
                                                column2 = csvContext.column;
                                            } else {
                                                line = -1;
                                                column2 = -1;
                                            }
                                            inspectionReporter.addProblem(new CsvInspectionProblem(this.getProblemClass(problem.getType()), this.getProblemType(problem.getType()), problem.getMessage(), problem.getCondition(), inspectionReporter.getDeclarationNo(), -1, problem.getVariable(), line, column2));
                                        }
                                    }
                                    inspectionReporter.nextDeclaration();
                                    report = new Report(this.decimalMark, this.thousandsSeparator);
                                }
                            } else {
                                previousUnitId = unitId;
                            }
                        }
                        if (checkHelpFeatures) {
                            DataInspectionProblem[] helpFeatureProblems;
                            helpFeatures = new FieldGroupImpl(null, null);
                            Iterator subBindingsIt = this.mapping.getBindings();
                            while (subBindingsIt.hasNext()) {
                                Binding binding = (Binding)subBindingsIt.next();
                                if (!(binding instanceof HelpFeatureBinding)) continue;
                                HelpFeatureBinding helpFeatureBinding = (HelpFeatureBinding)binding;
                                if (this.mapping.getHelpFeatureConfig().isDefaultValue()) {
                                    helpFeatures.addField((Field)new FieldImpl(helpFeatureBinding.getId(), helpFeatureBinding.getDefaultValue(), (Object)new CsvContext(-1, -1)));
                                    continue;
                                }
                                this.readFieldValue((FieldBinding)helpFeatureBinding, helpFeatures, currentFields, currentLine, inspectionReporter.getDeclarationNo(), 0);
                            }
                            if (unitIdVerificationActive) {
                                Field unitIdField = helpFeatures.getField(UNIT_ID_FEATURE_NAME);
                                if (unitIdField == null || unitIdField.getValue() == null) {
                                    int column3;
                                    int line;
                                    if (unitIdField != null && unitIdField.getContext() != null) {
                                        CsvContext csvContext = (CsvContext)unitIdField.getContext();
                                        line = csvContext.line;
                                        column3 = csvContext.column;
                                    } else {
                                        line = -1;
                                        column3 = -1;
                                    }
                                    inspectionReporter.addProblem(new CsvInspectionProblem(CsvInspectionProblem.ProblemClass.ERROR, CsvInspectionProblem.ProblemType.INVALID_UNIT_ID, INVALID_UNIT_ID_ERROR_TEXT, null, inspectionReporter.getDeclarationNo(), -1, UNIT_ID_FEATURE_NAME, line, column3));
                                } else {
                                    UnitIDVerifierResult unitIdVerifierResult = this.inspectionController.verifyUnitId(unitIdField.getValue());
                                    if (unitIdVerifierResult == null) {
                                        throw new IllegalStateException("UnitIDVerifierResult ist null.");
                                    }
                                    if (!unitIdVerifierResult.isUnitIdAvailableAndCollectorOk()) {
                                        if (unitIdVerifierResult.isBadUnitId()) {
                                            int line;
                                            if (unitIdField.getContext() != null) {
                                                CsvContext csvContext = (CsvContext)unitIdField.getContext();
                                                line = csvContext.line;
                                                column = csvContext.column;
                                            } else {
                                                line = -1;
                                                column = -1;
                                            }
                                            inspectionReporter.addProblem(new CsvInspectionProblem(CsvInspectionProblem.ProblemClass.ERROR, CsvInspectionProblem.ProblemType.INVALID_UNIT_ID, INVALID_UNIT_ID_ERROR_TEXT, null, inspectionReporter.getDeclarationNo(), -1, UNIT_ID_FEATURE_NAME, line, column));
                                        } else if (unitIdVerifierResult.isUnitIdAvailableAndBadCollector()) {
                                            int column4;
                                            int line;
                                            String collectorCorrection = unitIdVerifierResult.getCollectorCorrection();
                                            inspectionReporter.setCollectorCorrection(inspectionReporter.getDeclarationNo(), collectorCorrection);
                                            if (unitIdField.getContext() != null) {
                                                CsvContext csvContext = (CsvContext)unitIdField.getContext();
                                                line = csvContext.line;
                                                column4 = csvContext.column;
                                            } else {
                                                line = -1;
                                                column4 = -1;
                                            }
                                            inspectionReporter.addProblem(new CsvInspectionProblem(CsvInspectionProblem.ProblemClass.WARN, CsvInspectionProblem.ProblemType.COLLECTOR_CORRECTION, "Der Berichtsempf\u00e4nger wird maschinell korrigiert.", null, inspectionReporter.getDeclarationNo(), -1, UNIT_ID_FEATURE_NAME, line, column4));
                                        } else if (!unitIdVerifierResult.isUnitIdUnchecked()) {
                                            throw new IllegalStateException("Ungueltiger UnitIDVerifierResult-Status: " + unitIdVerifierResult.getResultStatus() + ".");
                                        }
                                    }
                                }
                            }
                            if (dataInspectionActive && (helpFeatureProblems = dataInspector.checkHelpFeatures(report, (FieldGroup)helpFeatures)) != null) {
                                for (DataInspectionProblem problem : helpFeatureProblems) {
                                    int column5;
                                    int line;
                                    if (problem.getContext() != null) {
                                        CsvContext csvContext = (CsvContext)problem.getContext();
                                        line = csvContext.line;
                                        column5 = csvContext.column;
                                    } else {
                                        line = -1;
                                        column5 = -1;
                                    }
                                    inspectionReporter.addProblem(new CsvInspectionProblem(this.getProblemClass(problem.getType()), this.getProblemType(problem.getType()), problem.getMessage(), problem.getCondition(), inspectionReporter.getDeclarationNo(), -1, problem.getVariable(), line, column5));
                                }
                            }
                            checkHelpFeatures = false;
                        }
                    }
                    if (currentLine > 1 || !this.mapping.getHelpFeatureConfig().isSeparateRow()) {
                        inspectionReporter.nextRecord();
                        FieldGroupImpl record = new FieldGroupImpl(null, (Object)new CsvContext(currentLine, -1));
                        Iterator subBindingsIt = this.mapping.getBindings();
                        while (subBindingsIt.hasNext()) {
                            Binding binding = (Binding)subBindingsIt.next();
                            if (!(binding instanceof SelectorBinding)) continue;
                            SelectorBinding selectorBinding = (SelectorBinding)binding;
                            this.readFieldValue((FieldBinding)selectorBinding, record, currentFields, currentLine, inspectionReporter.getDeclarationNo(), inspectionReporter.getRecordNo());
                        }
                        MetaSDFAusgabegruppe dataGroup = dataInspector.findDataGroup(report, (FieldGroup)record);
                        if (dataGroup != null) {
                            FieldSetBinding fieldSetBinding = this.mapping.getFieldSetBindingWithName(dataGroup.getName());
                            subBindingsIt = fieldSetBinding.getBindings();
                            while (subBindingsIt.hasNext()) {
                                Binding binding = (Binding)subBindingsIt.next();
                                if (binding instanceof FieldBinding) {
                                    FieldBinding fieldBinding = (FieldBinding)binding;
                                    this.readFieldValue(fieldBinding, record, currentFields, currentLine, inspectionReporter.getDeclarationNo(), inspectionReporter.getRecordNo());
                                    continue;
                                }
                                if (!(binding instanceof FieldGroupBinding)) continue;
                                FieldGroupBinding fieldGroupBinding = (FieldGroupBinding)binding;
                                this.readFieldGroup(fieldGroupBinding, record, currentFields, currentLine, inspectionReporter.getDeclarationNo(), inspectionReporter.getRecordNo());
                            }
                        }
                        if (dataInspectionActive) {
                            DataInspectionProblem[] recordProblems = dataInspector.checkRecord(report, (FieldGroup)record, (FieldGroup)helpFeatures);
                            if (recordProblems != null) {
                                for (DataInspectionProblem problem : recordProblems) {
                                    int column6;
                                    int line;
                                    if (problem.getContext() != null) {
                                        CsvContext csvContext = (CsvContext)problem.getContext();
                                        line = csvContext.line;
                                        column6 = csvContext.column;
                                    } else {
                                        line = -1;
                                        column6 = -1;
                                    }
                                    inspectionReporter.addProblem(new CsvInspectionProblem(this.getProblemClass(problem.getType()), this.getProblemType(problem.getType()), problem.getMessage(), problem.getCondition(), inspectionReporter.getDeclarationNo(), inspectionReporter.getRecordNo(), problem.getVariable(), line, column6));
                                }
                            }
                        } else if (dataGroup == null) {
                            int line;
                            if (record.getContext() != null) {
                                CsvContext csvContext = (CsvContext)record.getContext();
                                line = csvContext.line;
                                column = csvContext.column;
                            } else {
                                line = -1;
                                column = -1;
                            }
                            inspectionReporter.addProblem(new CsvInspectionProblem(CsvInspectionProblem.ProblemClass.FATAL, CsvInspectionProblem.ProblemType.INVALID_RECORD, "Der Satz muss einer der definierten Satzarten entsprechen.", null, inspectionReporter.getDeclarationNo(), inspectionReporter.getRecordNo(), null, line, column));
                        }
                    }
                    currentFields = this.getAllFieldsInLineOrNull(csvReader);
                    ++currentLine;
                }
                if (dataInspectionActive) {
                    DataInspectionProblem[] reportProblems = dataInspector.checkReport(report);
                    if (reportProblems != null) {
                        for (DataInspectionProblem problem : reportProblems) {
                            int column;
                            int line;
                            if (problem.getContext() != null) {
                                CsvContext csvContext = (CsvContext)problem.getContext();
                                line = csvContext.line;
                                column = csvContext.column;
                            } else {
                                line = -1;
                                column = -1;
                            }
                            inspectionReporter.addProblem(new CsvInspectionProblem(this.getProblemClass(problem.getType()), this.getProblemType(problem.getType()), problem.getMessage(), problem.getCondition(), inspectionReporter.getDeclarationNo(), -1, problem.getVariable(), line, column));
                        }
                    }
                } else if (inspectionReporter.getRecordNo() == 0) {
                    inspectionReporter.addProblem(new CsvInspectionProblem(CsvInspectionProblem.ProblemClass.FATAL, CsvInspectionProblem.ProblemType.NO_RECORDS, "Es muss mindestens 1 Datensatz geliefert werden.", null, inspectionReporter.getDeclarationNo(), -1, null, -1, -1));
                }
            }
            catch (CsvInspectorException e) {
                inspectionReporter.addProblem(new CsvInspectionProblem(CsvInspectionProblem.ProblemClass.FATAL, null, e.getMessage(), null, e.declno, e.recno, e.varname, e.line, e.column));
            }
        }
        catch (FatalException e) {
            // empty catch block
        }
        return inspectionReporter.getReport();
    }

    private String readFieldValue(FieldBinding binding, FieldGroupImpl fieldGroup, String[] currentFields, int currentLine, int currentDeclaration, int currentRecord) {
        return this.readFieldValue(binding, 0, fieldGroup, currentFields, currentLine, currentDeclaration, currentRecord);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String readFieldValue(FieldBinding binding, int offset, FieldGroupImpl fieldGroup, String[] currentFields, int currentLine, int currentDeclaration, int currentRecord) {
        String value;
        int position;
        if (binding.getPosition() != null) {
            position = offset + binding.getPosition();
            if (currentFields.length <= position - 1) throw new CsvInspectorException("Fehler beim Zugriff auf das Feld.", currentDeclaration, currentRecord, binding.getId(), currentLine, position);
            value = currentFields[position - 1];
            if (value != null) {
                if (value.startsWith(this.csvQuote)) {
                    value = this.removeEnclosingQuotes(value);
                } else if (value.length() == 0) {
                    value = binding.getDefaultValue();
                }
            }
        } else {
            position = -1;
            value = binding.getDefaultValue();
        }
        fieldGroup.addField((Field)new FieldImpl(binding.getId(), value, (Object)new CsvContext(position < 0 ? -1 : currentLine, position)));
        return value;
    }

    private void readFieldGroup(FieldGroupBinding fieldGroupBinding, FieldGroupImpl fieldGroup, String[] currentFields, int currentLine, int currentDeclaration, int currentRecord) {
        this.readFieldGroup(fieldGroupBinding, 0, fieldGroup, currentFields, currentLine, currentDeclaration, currentRecord);
    }

    private MinAndMax readFieldGroup(FieldGroupBinding fieldGroupBinding, int offset, FieldGroupImpl parentFieldGroup, String[] currentFields, int currentLine, int currentDeclaration, int currentRecord) {
        int size;
        MinAndMax minAndMaxCsvPos = new MinAndMax();
        int firstCsvPos = BindingHelper.getFirstAndLastCalculatedCsvPosition((FieldGroupBinding)fieldGroupBinding).getMin();
        Integer sizeObj = fieldGroupBinding.getSize();
        int n = size = sizeObj != null ? sizeObj : 0;
        if (size < 0) {
            size = 0;
        }
        if (size > 0) {
            int currentOffset = offset;
            for (int i = 0; i < size && currentOffset + firstCsvPos <= currentFields.length; ++i) {
                FieldGroupImpl fieldGroup = new FieldGroupImpl(fieldGroupBinding.getId(), (Object)new CsvContext(currentLine, currentOffset + 1));
                parentFieldGroup.addFieldGroup(fieldGroup);
                Iterator it = fieldGroupBinding.getBindings();
                while (it.hasNext()) {
                    Binding binding = (Binding)it.next();
                    if (binding instanceof FieldBinding) {
                        FieldBinding fieldBinding = (FieldBinding)binding;
                        this.readFieldValue(fieldBinding, currentOffset, fieldGroup, currentFields, currentLine, currentDeclaration, currentRecord);
                        if (fieldBinding.getPosition() == null) continue;
                        int csvPos = currentOffset + fieldBinding.getPosition();
                        minAndMaxCsvPos.update(csvPos);
                        continue;
                    }
                    if (!(binding instanceof FieldGroupBinding)) continue;
                    FieldGroupBinding subFieldGroupBinding = (FieldGroupBinding)binding;
                    MinAndMax subMinAndMaxCsvPos = this.readFieldGroup(subFieldGroupBinding, currentOffset, fieldGroup, currentFields, currentLine, currentDeclaration, currentRecord);
                    minAndMaxCsvPos.update(subMinAndMaxCsvPos);
                }
                currentOffset = minAndMaxCsvPos.max - minAndMaxCsvPos.min + 1;
            }
        }
        return minAndMaxCsvPos;
    }

    private String removeEnclosingQuotes(String value) {
        if (value.startsWith(this.csvQuote) && value.endsWith(this.csvQuote) && value.length() >= 2) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    private String[] getAllFieldsInLineOrNull(CSVReader csvReader) throws IOException {
        try {
            return csvReader.getAllFieldsInLine();
        }
        catch (EOFException e) {
            return null;
        }
    }

    private CsvInspectionProblem.ProblemClass getProblemClass(DataInspectionProblem.Type problemType) {
        switch (problemType) {
            case SDF_FORMAT_ERROR: 
            case UNSUPPORTED_CONDITION_FORMAT: 
            case NO_RECORDS: 
            case INVALID_RECORD: {
                return CsvInspectionProblem.ProblemClass.FATAL;
            }
            case INVALID_OPTIONAL_HELP_FEATURE_VALUE: 
            case INVALID_OPTIONAL_FEATURE_VALUE: {
                return CsvInspectionProblem.ProblemClass.WARN;
            }
        }
        return CsvInspectionProblem.ProblemClass.ERROR;
    }

    private CsvInspectionProblem.ProblemType getProblemType(DataInspectionProblem.Type problemType) {
        return CsvInspectionProblem.ProblemType.valueOf(problemType.name());
    }

    private static final class CsvContext {
        private final int line;
        private final int column;

        private CsvContext(int line, int column) {
            this.line = line;
            this.column = column;
        }
    }

    private static final class MinAndMax {
        private int min = Integer.MAX_VALUE;
        private int max = Integer.MIN_VALUE;

        private MinAndMax() {
        }

        private void update(int value) {
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
        }

        private void update(MinAndMax subMinAndMax) {
            if (subMinAndMax.min < this.min) {
                this.min = subMinAndMax.min;
            }
            if (subMinAndMax.max > this.max) {
                this.max = subMinAndMax.max;
            }
        }
    }

    private static final class CsvInspectorException
    extends RuntimeException {
        private final int declno;
        private final int recno;
        private final String varname;
        private final int line;
        private final int column;

        public CsvInspectorException(String message, int declno, int recno, String varname, int line, int column) {
            super(message);
            this.declno = declno;
            this.recno = recno;
            this.varname = varname;
            this.line = line;
            this.column = column;
        }
    }
}

