/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.htmlcleaner.CleanTimeValues;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagPos;

class OpenTags {
    private final HtmlCleaner htmlCleaner;
    List<TagPos> list = new ArrayList<TagPos>();
    private TagPos last;
    private Set<String> set = new HashSet<String>();

    OpenTags(HtmlCleaner htmlCleaner) {
        this.htmlCleaner = htmlCleaner;
    }

    boolean isEmpty() {
        return this.list.isEmpty();
    }

    void addTag(String tagName, TagInfo tagInfo, int position, CleanTimeValues cleanTimeValues) {
        this.last = new TagPos(position, tagName, tagInfo, cleanTimeValues);
        this.list.add(this.last);
        this.set.add(tagName);
    }

    void removeTag(String tagName) {
        ListIterator<TagPos> it = this.list.listIterator(this.list.size());
        while (it.hasPrevious()) {
            if (Thread.currentThread().isInterrupted()) {
                this.htmlCleaner.handleInterruption();
                break;
            }
            TagPos currTagPos = it.previous();
            if (!tagName.equals(currTagPos.name)) continue;
            it.remove();
            break;
        }
        this.last = this.list.isEmpty() ? null : this.list.get(this.list.size() - 1);
    }

    TagPos findFirstTagPos() {
        return this.list.isEmpty() ? null : this.list.get(0);
    }

    TagPos getLastTagPos() {
        return this.last;
    }

    TagPos findTag(String tagName, CleanTimeValues cleanTimeValues) {
        if (tagName != null) {
            ListIterator<TagPos> it = this.list.listIterator(this.list.size());
            Object fatalTag = null;
            TagInfo fatalInfo = this.htmlCleaner.getTagInfo(tagName, cleanTimeValues);
            while (it.hasPrevious()) {
                if (Thread.currentThread().isInterrupted()) {
                    this.htmlCleaner.handleInterruption();
                    return null;
                }
                TagPos currTagPos = it.previous();
                if (tagName.equals(currTagPos.name)) {
                    return currTagPos;
                }
                if (fatalInfo == null || !fatalInfo.isFatalTag(currTagPos.name)) continue;
                return null;
            }
        }
        return null;
    }

    boolean tagExists(String tagName, CleanTimeValues cleanTimeValues) {
        TagPos tagPos = this.findTag(tagName, cleanTimeValues);
        return tagPos != null;
    }

    TagPos findTagToPlaceRubbish() {
        TagPos result = null;
        TagPos prev = null;
        if (!this.isEmpty()) {
            ListIterator<TagPos> it = this.list.listIterator(this.list.size());
            while (it.hasPrevious()) {
                if (Thread.currentThread().isInterrupted()) {
                    this.htmlCleaner.handleInterruption();
                    return null;
                }
                result = it.previous();
                if ((result.info == null || result.info.allowsAnything()) && prev != null) {
                    return prev;
                }
                prev = result;
            }
        }
        return result;
    }

    boolean tagEncountered(String tagName) {
        return this.set.contains(tagName);
    }

    boolean someAlreadyOpen(Set<String> tags) {
        for (TagPos curr : this.list) {
            if (!tags.contains(curr.name)) continue;
            return true;
        }
        return false;
    }
}

