/*
 * Decompiled with CFR 0.152.
 */
package com.his.jackson.databind.ser.std;

import com.his.jackson.core.JsonGenerator;
import com.his.jackson.databind.JavaType;
import com.his.jackson.databind.JsonMappingException;
import com.his.jackson.databind.JsonNode;
import com.his.jackson.databind.SerializerProvider;
import com.his.jackson.databind.annotation.JacksonStdImpl;
import com.his.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.his.jackson.databind.jsontype.TypeSerializer;
import com.his.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public final class StringSerializer
extends StdScalarSerializer<Object> {
    private static final long serialVersionUID = 1L;

    public StringSerializer() {
        super(String.class, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        String str = (String)value;
        return str.isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString((String)value);
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        gen.writeString((String)value);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

