/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.awt.Color;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumNumber;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.util.CompareUtil;

public final class NumberProperty
extends Property
implements Numeric {
    private static final PropertyCache<NumberProperty> CACHE = new PropertyCache();
    private final Number number;

    private NumberProperty(double num) {
        this.number = num == Math.floor(num) ? (Number)(num < 2.147483647E9 ? (Number)((int)num) : (Number)((long)num)) : (Number)num;
    }

    private NumberProperty(int num) {
        this.number = num;
    }

    public static NumberProperty getInstance(Double num) {
        return CACHE.fetch(new NumberProperty(num));
    }

    public static NumberProperty getInstance(Integer num) {
        return CACHE.fetch(new NumberProperty(num));
    }

    public static NumberProperty getInstance(double num) {
        return CACHE.fetch(new NumberProperty(num));
    }

    public static NumberProperty getInstance(int num) {
        return CACHE.fetch(new NumberProperty(num));
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public double getNumericValue() {
        return this.number.doubleValue();
    }

    @Override
    public double getNumericValue(PercentBaseContext context) {
        return this.getNumericValue();
    }

    @Override
    public int getValue() {
        return this.number.intValue();
    }

    @Override
    public int getValue(PercentBaseContext context) {
        return this.getValue();
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public Number getNumber() {
        return this.number;
    }

    @Override
    public Object getObject() {
        return this.number;
    }

    @Override
    public Numeric getNumeric() {
        return this;
    }

    @Override
    public Length getLength() {
        return FixedLength.getInstance(this.getNumericValue(), "px");
    }

    @Override
    public Color getColor(FOUserAgent foUserAgent) {
        return Color.black;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NumberProperty)) {
            return false;
        }
        NumberProperty other = (NumberProperty)obj;
        return CompareUtil.equal(this.number, other.number);
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    public static class PositiveIntegerMaker
    extends PropertyMaker {
        public PositiveIntegerMaker(int propId) {
            super(propId);
        }

        @Override
        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof EnumProperty) {
                return EnumNumber.getInstance(p);
            }
            Number val = p.getNumber();
            if (val != null) {
                int i = Math.round(val.floatValue());
                if (i <= 0) {
                    i = 1;
                }
                return NumberProperty.getInstance(i);
            }
            return this.convertPropertyDatatype(p, propertyList, fo);
        }
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        @Override
        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof NumberProperty) {
                return p;
            }
            if (p instanceof EnumProperty) {
                return EnumNumber.getInstance(p);
            }
            Number val = p.getNumber();
            if (val != null) {
                return NumberProperty.getInstance(val.doubleValue());
            }
            return this.convertPropertyDatatype(p, propertyList, fo);
        }
    }
}

