/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.jersey;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.enunciate.modules.jersey.EnunciateJAXBContextResolver;
import org.codehaus.enunciate.modules.jersey.JerseyAdaptedHttpServletRequest;
import org.codehaus.enunciate.modules.jersey.JerseyAdaptedHttpServletResponse;

public class EnunciateJerseyServletContainer
extends ServletContainer {
    private static final Logger LOG = Logger.getLogger(EnunciateJerseyServletContainer.class.getName());
    private ResourceConfig resourceConfig;
    private String resourceProviderFactory = "org.codehaus.enunciate.modules.jersey.EnunciateSpringComponentProviderFactory";
    private WebApplication wa;
    private String servletPath;
    private boolean pathBasedConneg = true;

    protected void configure(ServletConfig sc, ResourceConfig rc, WebApplication wa) {
        String servletPath;
        String line;
        BufferedReader reader;
        rc.getClasses().add(EnunciateJAXBContextResolver.class);
        InputStream stream = this.loadResource("/jaxrs-providers.list");
        if (stream != null) {
            try {
                reader = new BufferedReader(new InputStreamReader(stream, "utf-8"));
                line = reader.readLine();
                while (line != null) {
                    rc.getClasses().add(this.loadClass(line));
                    line = reader.readLine();
                }
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error loading enunciate-provided provider class. Skipping...", e);
            }
        }
        if ((stream = this.loadResource("/jaxrs-root-resources.list")) != null) {
            try {
                reader = new BufferedReader(new InputStreamReader(stream, "utf-8"));
                line = reader.readLine();
                while (line != null) {
                    rc.getClasses().add(this.loadClass(line));
                    line = reader.readLine();
                }
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error loading enunciate-provided root resource class. Skipping...", e);
            }
        }
        try {
            rc.getClasses().add(this.loadClass("org.codehaus.enunciate.modules.amf.JAXRSProvider"));
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, "org.codehaus.enunciate.modules.amf.JAXRSProvider not found.");
        }
        try {
            rc.getClasses().add(this.loadClass("org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider"));
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, "org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider not loaded. Perhaps Jackson isn't on the classpath?");
        }
        String pathBasedConneg = sc.getInitParameter("org.codehaus.enunciate.modules.jersey.config.PathBasedConneg");
        if (pathBasedConneg == null) {
            pathBasedConneg = Boolean.TRUE.toString();
        }
        this.pathBasedConneg = Boolean.valueOf(pathBasedConneg);
        rc.getFeatures().put("org.codehaus.enunciate.modules.jersey.config.PathBasedConneg", this.pathBasedConneg);
        String resourceProvider = sc.getInitParameter("org.codehaus.enunciate.modules.jersey.config.ResourceProviderFactory");
        if (resourceProvider != null) {
            this.resourceProviderFactory = resourceProvider;
        }
        if ((stream = this.loadResource("/media-type-mappings.properties")) != null) {
            try {
                Properties mappings = new Properties();
                mappings.load(stream);
                for (Map.Entry<Object, Object> entry : mappings.entrySet()) {
                    rc.getMediaTypeMappings().put(String.valueOf(entry.getKey()), MediaType.valueOf((String)String.valueOf(entry.getValue())));
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.servletPath = (servletPath = sc.getInitParameter("org.codehaus.enunciate.modules.jersey.config.ServletPath")) == null ? "" : servletPath;
        super.configure(sc, rc, wa);
    }

    protected void initiate(ResourceConfig rc, WebApplication wa) {
        wa.initiate(rc, this.loadResourceProviderFacotry(rc));
        this.resourceConfig = rc;
    }

    protected WebApplication create() {
        WebApplication wa;
        this.wa = wa = super.create();
        return wa;
    }

    protected IoCComponentProviderFactory loadResourceProviderFacotry(ResourceConfig rc) {
        try {
            return (IoCComponentProviderFactory)this.loadClass(this.resourceProviderFactory).getConstructor(ResourceConfig.class, ServletContext.class).newInstance(rc, this.getServletContext());
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, "Unable to load the spring component provider factory. Using the jersey default...");
            return null;
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UriBuilder requestUrl;
        try {
            requestUrl = UriBuilder.fromUri((String)String.valueOf(request.getRequestURL()));
        }
        catch (IllegalArgumentException e) {
            String message;
            String string = message = e.getCause() == null ? e.getMessage() : e.getCause().getMessage();
            if (message == null) {
                message = request.getRequestURL().insert(0, "Illegal URI: ").toString();
            }
            response.sendError(400, message);
            return;
        }
        StringBuilder baseUriPathBuilder = new StringBuilder();
        String requestPath = request.getRequestURI();
        String contextPath = request.getContextPath();
        MediaType mediaType = null;
        if (!"".equals(contextPath) && requestPath.startsWith(contextPath)) {
            baseUriPathBuilder.append(contextPath);
            requestPath = requestPath.substring(contextPath.length());
        }
        if (!"".equals(this.servletPath) && requestPath.startsWith(this.servletPath)) {
            baseUriPathBuilder.append(this.servletPath);
            requestPath = requestPath.substring(this.servletPath.length());
        } else if (this.pathBasedConneg) {
            if (requestPath.startsWith("/")) {
                requestPath = requestPath.substring(1);
            }
            for (Map.Entry mediaMapping : this.resourceConfig.getMediaTypeMappings().entrySet()) {
                if (!requestPath.startsWith((String)mediaMapping.getKey())) continue;
                String mediaKey = (String)mediaMapping.getKey();
                baseUriPathBuilder.append('/').append(mediaKey);
                requestPath = requestPath.substring(mediaKey.length());
                mediaType = (MediaType)mediaMapping.getValue();
                break;
            }
        }
        String baseUriPath = baseUriPathBuilder.append('/').toString();
        if (!baseUriPath.equals(UriComponent.encode((String)baseUriPath, (UriComponent.Type)UriComponent.Type.PATH))) {
            throw new ContainerException("The servlet context path and/or the servlet path contain characters that are percent enocded");
        }
        URI baseUri = requestUrl.replacePath(baseUriPath).build(new Object[0]);
        String queryParameters = request.getQueryString();
        if (queryParameters == null) {
            queryParameters = "";
        }
        URI requestUri = requestUrl.path(requestPath).replaceQuery(queryParameters).build(new Object[0]);
        request = new JerseyAdaptedHttpServletRequest((HttpServletRequest)request, mediaType);
        response = new JerseyAdaptedHttpServletResponse((HttpServletResponse)response, this.wa);
        this.service(baseUri, requestUri, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = EnunciateJAXBContextResolver.class.getClassLoader();
        }
        return cl;
    }

    protected InputStream loadResource(String resource) {
        return EnunciateJerseyServletContainer.getDefaultClassLoader().getResourceAsStream(resource);
    }

    protected Class loadClass(String classname) throws ClassNotFoundException {
        return EnunciateJerseyServletContainer.getDefaultClassLoader().loadClass(classname);
    }
}

