/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class MessageResource {
    private HashMap hashResources = new HashMap();
    private String subClass = null;

    public MessageResource(String subClass) {
        this.subClass = subClass;
    }

    public String getMessage(String msg, Locale loc) {
        if (this.subClass == null) {
            return null;
        }
        if (loc == null) {
            return null;
        }
        ResourceBundle rb = null;
        String key = new StringBuffer().append(loc.getLanguage()).append("_").append(loc.getCountry()).append("_").append(loc.getVariant()).toString();
        if (this.hashResources.containsKey(key)) {
            rb = (ResourceBundle)this.hashResources.get(key);
        } else {
            try {
                rb = ResourceBundle.getBundle(this.subClass, loc);
            }
            catch (Exception e) {
                rb = null;
            }
            this.hashResources.put(key, rb);
        }
        String s = null;
        if (rb != null) {
            try {
                s = rb.getString(msg);
            }
            catch (Exception e) {
                s = null;
            }
        }
        return s;
    }

    public String getMessage(String msg, Locale loc, String[] parms) {
        String result = this.getMessage(msg, loc);
        if (result == null) {
            return null;
        }
        String search = null;
        for (int i = 0; i < parms.length; ++i) {
            search = "{" + i + "}";
            result = this.replaceAll(result, search, parms[i]);
        }
        return result;
    }

    public String getSubClass() {
        return this.subClass;
    }

    private String replaceAll(String str, String search, String replace) {
        int pos;
        StringBuffer result = null;
        int oldpos = 0;
        while ((pos = str.indexOf(search, oldpos)) >= 0) {
            if (result == null) {
                result = new StringBuffer();
            }
            result.append(str.substring(oldpos, pos));
            result.append(replace);
            oldpos = pos += search.length();
        }
        if (oldpos == 0) {
            return str;
        }
        result.append(str.substring(oldpos));
        return new String(result);
    }
}

