/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.event.WebEvent;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.util.Util;

public class IsWebEvent
extends DbBaseHandlerTag
implements TryCatchFinally {
    private static Log logCat = LogFactory.getLog((String)IsWebEvent.class.getName());
    private String event = null;
    private String value = "true";

    public final void setEvent(String str) {
        this.event = str;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    @Override
    public void doFinally() {
        this.value = "true";
        this.event = null;
        super.doFinally();
    }

    public int doStartTag() throws JspException {
        boolean eventNameMatch;
        WebEvent we = this.getParentForm().getWebEvent();
        if (we == null || this.event == null || this.value == null) {
            logCat.debug((Object)("Can't do IsWebEvent with  webEvent: " + we + "  event: " + this.event + "   value: " + this.value));
            return 0;
        }
        String className = we.getType();
        boolean bl = eventNameMatch = className.toUpperCase().indexOf(this.event.toUpperCase()) != -1;
        if (logCat.isDebugEnabled()) {
            logCat.debug((Object)(" IsLocalWebEvent webEvent className: " + className + "    event: " + this.event + "  value: " + this.value));
        }
        return Util.getTrue(this.value) == eventNameMatch ? 1 : 0;
    }
}

