/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.IOException;
import org.dbforms.config.ResultSetVector;
import org.dbforms.taglib.DbBaseButtonTag;
import org.dbforms.util.Util;

public class DbNavNewButtonTag
extends DbBaseButtonTag
implements TryCatchFinally {
    private String destTable;
    private String showAlwaysInFooter = "true";

    public void setDestTable(String destTable) {
        this.destTable = destTable;
    }

    public String getDestTable() {
        return this.destTable;
    }

    public void setShowAlwaysInFooter(String showAlwaysInFooter) {
        this.showAlwaysInFooter = showAlwaysInFooter;
    }

    public String getShowAlwaysInFooter() {
        return this.showAlwaysInFooter;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    @Override
    public void doFinally() {
        this.destTable = null;
        this.showAlwaysInFooter = "true";
        super.doFinally();
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        if (this.getParentForm().isFooterReached() && ResultSetVector.isNull(this.getParentForm().getResultSetVector()) && !Util.getTrue(this.showAlwaysInFooter)) {
            return 0;
        }
        try {
            StringBuffer tagBuf = new StringBuffer();
            int tableId = this.destTable != null && this.destTable.length() != 0 ? this.getConfig().getTableByName(this.destTable).getId() : this.getTable().getId();
            String tagName = "ac_new_" + tableId + "_" + Integer.toString(DbNavNewButtonTag.getUniqueID());
            if (this.getFollowUp() != null) {
                tagBuf.append(this.getDataTag(tagName, "fu", this.getFollowUp()));
            }
            if (this.getFollowUpOnError() != null) {
                tagBuf.append(this.getDataTag(tagName, "fue", this.getFollowUpOnError()));
            }
            tagBuf.append(this.getButtonBegin());
            tagBuf.append(" name=\"");
            tagBuf.append(tagName);
            tagBuf.append(this.getButtonEnd());
            this.pageContext.getOut().write(tagBuf.toString());
        }
        catch (IOException ioe) {
            throw new JspException("IO Error: " + ioe.getMessage());
        }
        if (this.getChoosenFlavor() == 2) {
            return 2;
        }
        return 0;
    }
}

