/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.ResultSetVector;
import org.dbforms.taglib.DataContainer;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.util.KeyValuePair;
import org.dbforms.util.Util;

public class DbDataContainerLabelTag
extends DbBaseHandlerTag
implements DataContainer,
TryCatchFinally {
    private List embeddedData = null;
    private static Log logCat = LogFactory.getLog(DbDataContainerLabelTag.class);
    private String strict = "false";

    @Override
    public void setEmbeddedData(List embeddedData) {
        this.embeddedData = embeddedData;
    }

    public void setStrict(String string) {
        this.strict = string;
    }

    public String getStrict() {
        return this.strict;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public int doEndTag() throws JspException {
        try {
            String s;
            int count;
            String fieldValue = "";
            if (!Util.getTrue(this.strict)) {
                fieldValue = this.getFormattedFieldValue();
            }
            String compareValue = this.getFieldValue();
            if (!ResultSetVector.isNull(this.getParentForm().getResultSetVector()) && this.embeddedData != null) {
                int embeddedDataSize = this.embeddedData.size();
                String embeddedDataValue = null;
                for (int i = 0; i < embeddedDataSize; ++i) {
                    KeyValuePair aKeyValuePair = (KeyValuePair)this.embeddedData.get(i);
                    if (!aKeyValuePair.getKey().equals(compareValue)) continue;
                    embeddedDataValue = aKeyValuePair.getValue();
                    break;
                }
                if (embeddedDataValue != null) {
                    fieldValue = embeddedDataValue;
                }
            }
            String size = null;
            size = this.getMaxlength();
            if (size != null && size.trim().length() > 0 && (count = Integer.parseInt(size)) < fieldValue.length()) {
                fieldValue = fieldValue.substring(0, count);
                fieldValue = fieldValue + "...";
            }
            if (Util.isNull(s = this.prepareStyles())) {
                this.pageContext.getOut().write(fieldValue);
            } else {
                this.pageContext.getOut().write("<span " + s + ">" + fieldValue + "</span>");
            }
        }
        catch (IOException ioe) {
            logCat.error((Object)ioe);
            throw new JspException("IO Error: " + ioe.getMessage());
        }
        catch (Exception e) {
            logCat.error((Object)e);
            throw new JspException("Error: " + e.getMessage());
        }
        return 6;
    }

    @Override
    public void doFinally() {
        this.embeddedData = null;
        super.doFinally();
    }
}

