/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.servlets.reports;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.ResultSetVector;
import org.dbforms.config.Table;
import org.dbforms.event.WebEvent;
import org.dbforms.servlets.reports.JRDataSourceAbstract;
import org.dbforms.servlets.reports.JRDataSourceIter;
import org.dbforms.servlets.reports.JRDataSourceRSV;
import org.dbforms.servlets.reports.ReportWriter;
import org.dbforms.taglib.DbFormTag;
import org.dbforms.util.MessageResourcesInternal;
import org.dbforms.util.PageContextBuffer;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.Util;
import org.dbforms.util.external.FileUtil;

public abstract class ReportServletAbstract
extends HttpServlet {
    private static Log logCat = LogFactory.getLog((String)ReportServletAbstract.class.getName());
    private static final String REPORTCONFIGDIR = "reportdirs";
    private String[] reportdirs;

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    public void init() throws ServletException {
        String value = this.getServletConfig().getInitParameter(REPORTCONFIGDIR);
        if (value == null) {
            value = "WEB-INF/reports/";
        }
        this.reportdirs = StringUtils.split((String)value, (char)',');
    }

    protected abstract ReportWriter processReport(String var1, JRDataSourceAbstract var2, ServletContext var3, HttpServletRequest var4, HttpServletResponse var5);

    protected abstract String getReportFileExtension();

    protected final void handleException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        this.sendErrorMessage(request, response, MessageResourcesInternal.getMessage("dbforms.reports.exception", request.getLocale(), new String[]{e.getMessage()}));
    }

    private final void handleNoData(HttpServletRequest request, HttpServletResponse response) {
        this.sendErrorMessage(request, response, MessageResourcesInternal.getMessage("dbforms.reports.nodata", request.getLocale()));
    }

    private final void sendErrorMessage(HttpServletRequest request, HttpServletResponse response, String message) {
        try {
            Vector errors = (Vector)request.getAttribute("errors");
            errors.add(new Exception(message));
            String fue = ParseUtil.getParameter(request, "source");
            String contextPath = request.getContextPath();
            if (!Util.isNull(fue)) {
                fue = fue.substring(contextPath.length());
            }
            if (Util.isNull(fue)) {
                this.sendErrorMessageText(response, message);
            } else {
                request.getRequestDispatcher(fue).forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception ex) {
            logCat.error((Object)"sendErrorMessage", (Throwable)ex);
            this.sendErrorMessageText(response, message);
        }
    }

    protected void compileReport(ServletContext context, String reportFile) throws Exception {
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) {
        try {
            String reportFile = this.getReportFileFullName(request.getPathInfo(), this.getServletContext(), request, response);
            if (!Util.isNull(reportFile)) {
                this.compileReport(this.getServletContext(), reportFile);
                JRDataSourceAbstract dataSource = this.getDataForReport(request, response);
                if (!response.isCommitted()) {
                    if (dataSource == null) {
                        this.handleNoData(request, response);
                    } else {
                        ReportWriter res = this.processReport(reportFile, dataSource, this.getServletContext(), request, response);
                        if (!response.isCommitted()) {
                            if (res == null) {
                                this.handleNoOutput(request, response);
                            } else {
                                this.processOutput(res, request, response);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logCat.error((Object)"process", (Throwable)e);
            this.handleException(request, response, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOutput(ReportWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (out.data == null && out.data.size() == 0) {
            this.handleNoOutput(request, response);
            return;
        }
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        if (!Util.isNull(out.fileName)) {
            response.setHeader("Content-disposition", "inline; filename=" + out.fileName);
        }
        if (!Util.isNull(out.mimeType)) {
            response.setContentType(out.mimeType);
        }
        response.setContentLength(out.data.size());
        try (ServletOutputStream outputStream = response.getOutputStream();){
            out.data.writeTo((OutputStream)outputStream);
            outputStream.flush();
        }
    }

    private String getReportFileFullName(String reportFileName, ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        String reportFile = null;
        try {
            boolean found = false;
            for (int i = 0; i < this.reportdirs.length; ++i) {
                reportFile = context.getRealPath(this.reportdirs[i] + reportFileName);
                String testName = reportFile + this.getReportFileExtension();
                if (!FileUtil.fileExists(testName)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.handleNoReport(request, response);
                reportFile = null;
            }
        }
        catch (Exception e) {
            this.handleException(request, response, e);
        }
        return reportFile;
    }

    private void handleNoReport(HttpServletRequest request, HttpServletResponse response) {
        this.sendErrorMessage(request, response, MessageResourcesInternal.getMessage("dbforms.reports.noreport", request.getLocale(), new String[]{request.getPathInfo()}));
    }

    private JRDataSourceAbstract getDataForReport(HttpServletRequest request, HttpServletResponse response) {
        JRDataSourceAbstract dataSource;
        block14: {
            dataSource = null;
            Table table = null;
            ResultSetVector rsv = null;
            try {
                Object input = request.getAttribute("jasper.input");
                if (input == null) {
                    input = request.getSession().getAttribute("jasper.input");
                }
                if (input != null && input instanceof Collection) {
                    Iterator iter = ((Collection)input).iterator();
                    dataSource = new JRDataSourceIter(null, iter);
                    return dataSource;
                }
                rsv = (ResultSetVector)request.getAttribute("jasper.rsv");
                if (rsv == null) {
                    rsv = (ResultSetVector)request.getSession().getAttribute("jasper.rsv");
                }
                if (rsv != null) {
                    logCat.info((Object)("get resultsetvector rsv= " + rsv.size()));
                    if (rsv.size() == 0) {
                        this.handleNoData(request, response);
                    } else {
                        dataSource = new JRDataSourceRSV(rsv.getAttributes(), rsv);
                    }
                    return dataSource;
                }
                PageContextBuffer pageContext = new PageContextBuffer();
                pageContext.initialize((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 0, true);
                WebEvent webEvent = (WebEvent)request.getAttribute("webEvent");
                table = webEvent.getTable();
                if (table == null) {
                    logCat.error((Object)"table==null");
                }
                if (webEvent == null || table == null || table.getId() == -1) break block14;
                DbFormsConfig config = null;
                try {
                    config = DbFormsConfigRegistry.instance().lookup();
                }
                catch (Exception e) {
                    logCat.error((Object)e);
                    throw new ServletException((Throwable)e);
                }
                String tableName = config.getTable(webEvent.getTable().getId()).getName();
                DbFormTag form = new DbFormTag();
                form.setPageContext(pageContext);
                form.setTableName(tableName);
                String maxRows = ParseUtil.getParameter(request, "MaxRows", "*");
                form.setMaxRows(maxRows);
                form.setFollowUp("");
                form.setAutoUpdate("false");
                String saveSource = (String)request.getAttribute("source");
                String refSource = request.getRequestURI();
                if (request.getQueryString() != null) {
                    refSource = refSource + "?" + request.getQueryString();
                }
                request.setAttribute("source", (Object)refSource);
                form.doStartTag();
                request.setAttribute("source", (Object)saveSource);
                rsv = form.getResultSetVector();
                logCat.info((Object)("get resultsetvector rsv= " + rsv.size()));
                if (rsv.size() == 0) {
                    this.handleNoData(request, response);
                } else {
                    dataSource = new JRDataSourceRSV(rsv.getAttributes(), rsv);
                }
                form.doFinally();
            }
            catch (Exception e) {
                logCat.error((Object)e);
            }
        }
        return dataSource;
    }

    private void sendErrorMessageText(HttpServletResponse response, String message) {
        try {
            PrintWriter out = response.getWriter();
            response.setContentType("text/html");
            out.println("<html><body><h1>ERROR</h1><p>");
            out.println(message);
            out.println("</p></body></html>");
            out.flush();
            out.close();
        }
        catch (IOException ioe2) {
            logCat.error((Object)"sendErrorMessageText", (Throwable)ioe2);
        }
    }

    private void handleNoOutput(HttpServletRequest request, HttpServletResponse response) {
        this.sendErrorMessage(request, response, MessageResourcesInternal.getMessage("dbforms.reports.nooutput", request.getLocale()));
    }
}

