/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.config;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbEventInterceptor;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.Field;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.config.ForeignKey;
import org.dbforms.config.GrantedPrivileges;
import org.dbforms.config.Interceptor;
import org.dbforms.config.JDBCDataHelper;
import org.dbforms.config.MultipleValidationException;
import org.dbforms.config.ResultSetVector;
import org.dbforms.config.TableEvents;
import org.dbforms.config.ValidationException;
import org.dbforms.util.IEscaper;
import org.dbforms.util.MessageResourcesInternal;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.ReflectionUtil;
import org.dbforms.util.SqlUtil;
import org.dbforms.util.StringUtil;
import org.dbforms.util.Util;

public class Table
implements Serializable {
    public static final int BLOB_INTERCEPTOR = 0;
    public static final int BLOB_CLASSIC = 1;
    private static final int MAXFIELDS = 1000;
    protected static final int DB_FIELD = 0;
    protected static final int SEARCH_FIELD = 1;
    protected static final int CALC_FIELD = 2;
    private GrantedPrivileges grantedPrivileges = null;
    private Hashtable calcFieldsNameHash = new Hashtable();
    private Hashtable fieldNameHash = new Hashtable();
    private Hashtable foreignKeyNameHash = new Hashtable();
    private IEscaper escaper = null;
    private static Log logCat = LogFactory.getLog((String)Table.class.getName());
    private String alias = null;
    private String blobHandling = null;
    private String dataAccessClass = null;
    private String defaultVisibleFields;
    private String defaultVisibleFieldsFormat;
    private String escaperClass = null;
    private String name;
    private String orderBy;
    private TableEvents tableEvents = null;
    private Vector calcFields = new Vector();
    private Vector diskblobs = new Vector();
    private Vector fields = new Vector();
    private Vector foreignKeys = new Vector();
    private Vector interceptors = new Vector();
    private Vector key = new Vector();
    private FieldValue[] defaultOrder;
    private int blobHandlingStrategy = 0;
    private int id;

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setBlobHandling(String blobHandling) {
        this.blobHandling = blobHandling;
        this.blobHandlingStrategy = "classic".equals(blobHandling) ? 1 : 0;
    }

    public String getBlobHandling() {
        return this.blobHandling;
    }

    public int getBlobHandlingStrategy() {
        return this.blobHandlingStrategy;
    }

    public Vector getCalcFields() {
        return this.calcFields;
    }

    public void setDataAccessClass(String dataAccessClass) {
        this.dataAccessClass = dataAccessClass;
    }

    public String getDataAccessClass() {
        return this.dataAccessClass;
    }

    public FieldValue[] getDefaultOrder() {
        return this.defaultOrder;
    }

    public void setDefaultVisibleFields(String defaultVisibleFields) {
        this.defaultVisibleFields = defaultVisibleFields;
    }

    public String getDefaultVisibleFields() {
        return this.defaultVisibleFields;
    }

    public void setDefaultVisibleFieldsFormat(String defaultVisibleFieldsFormat) {
        this.defaultVisibleFieldsFormat = defaultVisibleFieldsFormat;
    }

    public String getDefaultVisibleFieldsFormat() {
        return this.defaultVisibleFieldsFormat;
    }

    public String getDeleteStatement() {
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("DELETE FROM ");
        queryBuf.append(this.getQueryToChange());
        queryBuf.append(" WHERE ");
        queryBuf.append(this.getWhereClauseForKeyFields());
        logCat.info((Object)queryBuf.toString());
        return queryBuf.toString();
    }

    public String getDisblobSelectStatement() {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ");
        int cnt = this.diskblobs.size();
        for (int i = 0; i < cnt; ++i) {
            Field diskblobField = (Field)this.diskblobs.elementAt(i);
            buf.append(diskblobField.getName());
            if (i >= cnt - 1) continue;
            buf.append(", ");
        }
        buf.append(" FROM ");
        buf.append(this.getQueryFrom());
        return buf.toString();
    }

    public Vector getDiskblobs() {
        return this.diskblobs;
    }

    public ResultSet getDoSelectResultSet(FieldValue[] fvEqual, FieldValue[] fvOrder, FieldValue[] sqlFilterParams, int compareMode, PreparedStatement ps) throws SQLException {
        int curCol = 1;
        logCat.debug((Object)"###getDoSelectResultSet pos1");
        if (!FieldValue.isNull(sqlFilterParams)) {
            curCol = this.populateWhereEqualsClause(sqlFilterParams, ps, curCol);
        }
        logCat.debug((Object)"###getDoSelectResultSet pos2");
        if (!FieldValue.isNull(fvEqual)) {
            curCol = this.populateWhereEqualsClause(fvEqual, ps, curCol);
        }
        logCat.debug((Object)"###getDoSelectResultSet pos3");
        if (compareMode != 0 && fvOrder != null && fvOrder.length > 0) {
            this.populateWhereAfterClause(fvOrder, ps, curCol);
        }
        logCat.debug((Object)"###getDoSelectResultSet pos3");
        ResultSet result = null;
        try {
            result = ps.executeQuery();
        }
        catch (SQLException sqle) {
            SqlUtil.logSqlException(sqle);
            throw sqle;
        }
        return result;
    }

    public IEscaper getEscaper() {
        if (this.escaper == null) {
            String s = this.getEscaperClass();
            if (!Util.isNull(s)) {
                try {
                    this.escaper = (IEscaper)ReflectionUtil.newInstance(s);
                }
                catch (Exception e) {
                    logCat.error((Object)("cannot create the new escaper [" + s + "]"), (Throwable)e);
                }
            }
            if (this.escaper == null) {
                try {
                    this.escaper = DbFormsConfigRegistry.instance().lookup().getEscaper();
                }
                catch (Exception e) {
                    logCat.error((Object)"cannot create the new default escaper", (Throwable)e);
                }
            }
        }
        return this.escaper;
    }

    public void setEscaperClass(String string) {
        this.escaperClass = string;
    }

    public String getEscaperClass() {
        return this.escaperClass;
    }

    public Field getField(int fieldId) {
        Field f = null;
        f = this.checkFieldId(2, fieldId) ? (Field)this.calcFields.elementAt(this.decodeFieldId(2, fieldId)) : (Field)this.fields.elementAt(fieldId);
        return f;
    }

    public Field getFieldByName(String aname) {
        Field f = (Field)this.fieldNameHash.get(aname);
        if (f == null) {
            f = (Field)this.calcFieldsNameHash.get(aname);
        }
        return f;
    }

    public String getFieldName(int fieldID) {
        Field f = (Field)this.getFields().elementAt(fieldID);
        return f.getName();
    }

    public FieldValues getFieldValues(String position) {
        if (Util.isNull(position)) {
            return null;
        }
        FieldValues result = new FieldValues();
        try {
            int startIndex = 0;
            boolean endOfString = false;
            while (!endOfString) {
                int firstColon = position.indexOf(58, startIndex);
                int secondColon = position.indexOf(58, firstColon + 1);
                if (firstColon == -1 && secondColon == -1) {
                    return null;
                }
                String fieldIdStr = position.substring(startIndex, firstColon);
                int fieldId = Integer.parseInt(fieldIdStr);
                String valueLengthStr = position.substring(firstColon + 1, secondColon);
                int valueLength = Integer.parseInt(valueLengthStr);
                int controlIndex = secondColon + 1 + valueLength;
                String valueStr = controlIndex < position.length() ? position.substring(secondColon + 1, controlIndex) : position.substring(secondColon + 1);
                Field f = this.getField(fieldId);
                FieldValue fv = new FieldValue(f, valueStr);
                result.put(fv);
                if (controlIndex == position.length()) {
                    endOfString = true;
                    continue;
                }
                if (controlIndex > position.length()) {
                    logCat.warn((Object)"Controlbyte wrong but continuing execution");
                    endOfString = true;
                    continue;
                }
                char controlByte = position.charAt(controlIndex);
                if (controlByte != '-') {
                    logCat.error((Object)"Controlbyte wrong, abandon execution");
                    throw new IllegalArgumentException();
                }
                startIndex = controlIndex + 1;
                if (position.length() != startIndex) continue;
                endOfString = true;
            }
        }
        catch (Exception e) {
            logCat.error((Object)"::getFieldValuesFromPositionAsHt - exception:", (Throwable)e);
            result = null;
        }
        return result;
    }

    public Vector getFields() {
        return this.fields;
    }

    public FieldValue[] getFilterFieldArray(String filter, Locale locale) {
        Vector keyValPairs = StringUtil.splitString(filter, ",;");
        int len = keyValPairs.size();
        FieldValue[] result = new FieldValue[len];
        for (int i = 0; i < len; ++i) {
            int operator = 0;
            boolean isLogicalOR = false;
            int jump = 1;
            String aKeyValPair = (String)keyValPairs.elementAt(i);
            logCat.debug((Object)("initFilterFieldValues: aKeyValPair = " + aKeyValPair));
            int n = aKeyValPair.indexOf("<>");
            if (n != -1) {
                operator = 6;
                jump = 2;
            } else {
                n = aKeyValPair.indexOf(">=");
                if (n != -1) {
                    operator = 3;
                    jump = 2;
                } else {
                    n = aKeyValPair.indexOf(62);
                    if (n != -1) {
                        operator = 1;
                    } else {
                        n = aKeyValPair.indexOf("<=");
                        if (n != -1) {
                            operator = 4;
                            jump = 2;
                        } else {
                            n = aKeyValPair.indexOf(60);
                            if (n != -1) {
                                operator = 2;
                            } else {
                                n = aKeyValPair.indexOf(61);
                                if (n != -1) {
                                    operator = 0;
                                } else {
                                    n = aKeyValPair.indexOf(126);
                                    if (n != -1) {
                                        operator = 5;
                                    } else {
                                        n = aKeyValPair.toUpperCase().indexOf("NOTISNULL");
                                        if (n != -1) {
                                            jump = 9;
                                            operator = 8;
                                        } else {
                                            n = aKeyValPair.toUpperCase().indexOf("ISNULL");
                                            if (n != -1) {
                                                jump = 6;
                                                operator = 7;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            String fieldName = aKeyValPair.substring(0, n).trim();
            logCat.debug((Object)("Filter field=" + fieldName));
            if (fieldName.charAt(0) == '|') {
                fieldName = fieldName.substring(1);
                isLogicalOR = true;
            }
            Field filterField = this.getFieldByName(fieldName);
            String value = aKeyValPair.substring(n + jump).trim();
            logCat.debug((Object)("Filter value=" + value));
            result[i] = FieldValue.createFieldValueForSearching(filterField, value, locale, operator, 0, 0, isLogicalOR);
            logCat.debug((Object)("and fv is =" + result[i].toString()));
        }
        return result;
    }

    public Collection getForeignKeys() {
        return this.foreignKeys;
    }

    public String getFreeFormSelectQuery(Vector fieldsToSelect, String whereClause, String tableList) {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ");
        buf.append(this.getQuerySelect(fieldsToSelect));
        buf.append(" FROM ");
        if (Util.isNull(tableList)) {
            buf.append(this.getQueryFrom());
        } else {
            buf.append(tableList);
        }
        buf.append(" ");
        buf.append(whereClause);
        logCat.info((Object)("::getFreeFormSelectQuery -- [" + buf.toString() + "]"));
        return buf.toString();
    }

    public void setGrantedPrivileges(GrantedPrivileges grantedPrivileges) {
        this.grantedPrivileges = grantedPrivileges;
    }

    public GrantedPrivileges getGrantedPrivileges() {
        return this.grantedPrivileges;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String getInsertStatement(FieldValues fieldValues) {
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("INSERT INTO ");
        queryBuf.append(this.getQueryToChange());
        queryBuf.append(" (");
        Iterator e = fieldValues.keys();
        while (e.hasNext()) {
            String fieldName = (String)e.next();
            queryBuf.append(fieldName);
            if (!e.hasNext()) continue;
            queryBuf.append(",");
        }
        queryBuf.append(") VALUES (");
        for (int i = 0; i < fieldValues.size(); ++i) {
            if (i != 0) {
                queryBuf.append(",");
            }
            queryBuf.append("?");
        }
        queryBuf.append(")");
        logCat.info((Object)queryBuf.toString());
        return queryBuf.toString();
    }

    public Vector getInterceptors() {
        Vector res = this.interceptors;
        if (Table.getConfig() != null && Table.getConfig().hasInterceptors()) {
            res = new Vector(this.interceptors);
            res.addAll(Table.getConfig().getInterceptors());
            res.addAll(this.interceptors);
        }
        return res;
    }

    public Vector getKey() {
        return this.key;
    }

    public String getKeyPositionString(ResultSetVector rsv) {
        if (ResultSetVector.isNull(rsv)) {
            return null;
        }
        String[] currentRow = rsv.getCurrentRow();
        if (currentRow == null) {
            return null;
        }
        return this.getKeyPositionString(currentRow);
    }

    public String getKeyPositionString(String[] currentRow) {
        StringBuffer buf = new StringBuffer();
        if (currentRow != null) {
            for (int i = 0; i < this.getKey().size(); ++i) {
                Field f = (Field)this.getKey().elementAt(i);
                if (i > 0) {
                    buf.append("-");
                }
                buf.append(this.createToken(f, currentRow[f.getId()]));
            }
        }
        return buf.toString();
    }

    public String getKeyPositionString(FieldValues fvHT) {
        if (fvHT == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int cnt = 0;
        for (int i = 0; i < this.getKey().size(); ++i) {
            Field f = (Field)this.getKey().elementAt(i);
            FieldValue fv = fvHT.get(f.getName());
            if (fv == null) continue;
            String value = fv.getFieldValue();
            if (value == null) {
                throw new IllegalArgumentException("wrong fields provided");
            }
            if (cnt > 0) {
                buf.append("-");
            }
            buf.append(this.createToken(f, value));
            ++cnt;
        }
        return buf.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Hashtable getNamesHashtable(String core) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        for (Field f : this.getFields()) {
            result.put(f.getName(), f.getFieldName(core));
        }
        return result;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getPositionString(ResultSetVector rsv) {
        if (ResultSetVector.isNull(rsv)) {
            return null;
        }
        String[] currentRow = rsv.getCurrentRow();
        if (currentRow == null) {
            return null;
        }
        return this.getPositionString(currentRow);
    }

    public String getPositionString(String[] currentRow) {
        StringBuffer buf = new StringBuffer();
        int cnt = 0;
        for (int i = 0; i < this.getFields().size(); ++i) {
            Field f = (Field)this.getFields().elementAt(i);
            if (!f.hasIsKeySet() && !f.hasSortableSet()) continue;
            if (cnt > 0) {
                buf.append("-");
            }
            buf.append(this.createToken(f, currentRow[f.getId()]));
            ++cnt;
        }
        return buf.toString();
    }

    public String getPositionString(Hashtable ht) {
        StringBuffer buf = new StringBuffer();
        int cnt = 0;
        for (String fieldName : ht.keySet()) {
            Field aField = this.getFieldByName(fieldName);
            if (aField != null) {
                if (aField.hasIsKeySet() || aField.hasSortableSet()) {
                    String fieldValue = (String)ht.get(fieldName);
                    if (cnt > 0) {
                        buf.append('-');
                    }
                    buf.append(this.createToken(aField, fieldValue));
                    ++cnt;
                    continue;
                }
                logCat.debug((Object)("provided goto field " + fieldName + " is not key/search field!"));
                continue;
            }
            logCat.error((Object)("provided goto field " + fieldName + " not found!"));
        }
        return buf.toString();
    }

    public String getPositionString(FieldValues fvHT) {
        String res = null;
        if (fvHT != null) {
            StringBuffer buf = new StringBuffer();
            int cnt = 0;
            Iterator e = fvHT.keys();
            while (e.hasNext()) {
                String fieldName = (String)e.next();
                FieldValue fv = fvHT.get(fieldName);
                Field f = fv.getField();
                if (!f.hasIsKeySet() && !f.hasSortableSet()) continue;
                String value = fv.getFieldValue();
                if (value == null) {
                    throw new IllegalArgumentException("wrong fields provided");
                }
                if (cnt > 0) {
                    buf.append("-");
                }
                buf.append(this.createToken(f, value));
                ++cnt;
            }
            res = buf.toString();
        }
        return res;
    }

    public String getQueryFrom() {
        return this.name;
    }

    public String getQuerySelect(Vector fieldsToSelect) {
        if (fieldsToSelect != null) {
            StringBuffer buf = new StringBuffer();
            int fieldsToSelectSize = fieldsToSelect.size();
            for (int i = 0; i < fieldsToSelectSize; ++i) {
                Field f = (Field)fieldsToSelect.elementAt(i);
                buf.append(f.getName());
                buf.append(", ");
            }
            buf.deleteCharAt(buf.length() - 2);
            return buf.toString();
        }
        return "*";
    }

    public String getSelectQuery(Vector fieldsToSelect, FieldValue[] fvEqual, FieldValue[] fvOrder, String sqlFilter, int compareMode) {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ");
        buf.append(this.getQuerySelect(fieldsToSelect));
        buf.append(" FROM ");
        buf.append(this.getQueryFrom());
        String s = this.getQueryWhere(fvEqual, fvOrder, compareMode);
        if (!Util.isNull(s) || !Util.isNull(sqlFilter)) {
            buf.append(" WHERE ");
        }
        if (!Util.isNull(sqlFilter)) {
            buf.append(" ( ");
            buf.append(sqlFilter);
            buf.append(" ) ");
        }
        if (!Util.isNull(s)) {
            if (!Util.isNull(sqlFilter)) {
                buf.append(" AND ");
            }
            buf.append(" ( ");
            buf.append(s);
            buf.append(" ) ");
        }
        if ((s = this.getQueryOrderBy(fvOrder)).length() > 0) {
            buf.append(" ORDER BY ");
            buf.append(s);
        }
        logCat.info((Object)("::getSelectQuery - [" + buf.toString() + "]"));
        return buf.toString();
    }

    public String getSelectStatement() {
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("SELECT ");
        queryBuf.append(this.getQuerySelect(this.fields));
        queryBuf.append(" FROM ");
        queryBuf.append(this.getQueryFrom());
        logCat.info((Object)queryBuf.toString());
        return queryBuf.toString();
    }

    public void setTableEvents(TableEvents tableEvents) {
        this.tableEvents = tableEvents;
        tableEvents.setTable(this);
    }

    public TableEvents getTableEvents() {
        if (this.tableEvents == null) {
            this.tableEvents = new TableEvents();
        }
        return this.tableEvents;
    }

    public String getUpdateStatement(FieldValues fieldValues) {
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("UPDATE ");
        queryBuf.append(this.getQueryToChange());
        queryBuf.append(" SET ");
        boolean kommaNeeded = false;
        Iterator e = fieldValues.keys();
        while (e.hasNext()) {
            String fieldName = (String)e.next();
            if (kommaNeeded) {
                queryBuf.append(", ");
            } else {
                kommaNeeded = true;
            }
            queryBuf.append(fieldName);
            queryBuf.append("= ?");
        }
        queryBuf.append(" WHERE ");
        queryBuf.append(this.getWhereClauseForKeyFields());
        logCat.info((Object)queryBuf.toString());
        return queryBuf.toString();
    }

    public String getWhereClause(FieldValue[] fv) {
        StringBuffer buf = new StringBuffer();
        if (fv != null && fv.length > 0) {
            buf.append(" ( ");
            for (int i = 0; i < fv.length; ++i) {
                if (i != 0) {
                    if (fv[i].getLogicalOR()) {
                        buf.append(" OR ");
                    } else {
                        buf.append(" ) AND ( ");
                    }
                }
                buf.append(this.getSQLExpression(fv[i]));
            }
            buf.append(" ) ");
        }
        return buf.toString();
    }

    public String getWhereClauseForKeyFields() {
        StringBuffer buf = new StringBuffer();
        int cnt = this.getKey().size();
        for (int i = 0; i < cnt; ++i) {
            Field keyField = (Field)this.getKey().elementAt(i);
            buf.append(keyField.getName());
            buf.append(" = ?");
            if (i >= cnt - 1) continue;
            buf.append(" AND ");
        }
        return buf.toString();
    }

    public void addCalcField(Field field) throws Exception {
        if (field.getType() == 0) {
            throw new Exception("no type!");
        }
        field.setId(this.encodeFieldId(2, this.calcFields.size()));
        field.setTable(this);
        this.calcFields.addElement(field);
        this.calcFieldsNameHash.put(field.getName(), field);
    }

    public void addField(Field field) throws Exception {
        if (field.getType() == 0) {
            throw new Exception("no type!");
        }
        field.setId(this.encodeFieldId(0, this.fields.size()));
        field.setTable(this);
        this.fields.addElement(field);
        if (field.hasIsKeySet()) {
            logCat.info((Object)("wow - field " + this.getName() + "." + field.getName() + " is a key"));
            this.key.addElement(field);
        } else {
            logCat.info((Object)("field " + this.getName() + "." + field.getName() + " is NO key"));
        }
        this.fieldNameHash.put(field.getName(), field);
        if (field.getType() == 4200) {
            this.diskblobs.addElement(field);
        }
    }

    public void addForeignKey(ForeignKey fk) {
        fk.setId(this.foreignKeys.size());
        this.foreignKeys.addElement(fk);
        this.foreignKeyNameHash.put(fk.getName(), fk);
    }

    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.addElement(interceptor);
    }

    public boolean containsDiskblob() {
        return this.diskblobs.size() > 0;
    }

    public FieldValue[] createOrderFieldValues(String order, HttpServletRequest request, boolean includeKeys) {
        String paramStub;
        Vector sortFields;
        Vector result = null;
        if (request != null && (sortFields = ParseUtil.getParametersStartingWith(request, paramStub = "sort_" + this.getId())).size() > 0) {
            result = this.createOrderFVFromRequest(request, paramStub, sortFields);
        }
        if (result == null || result.isEmpty()) {
            if (order == null) {
                order = this.getOrderBy();
            }
            result = this.createOrderFVFromAttribute(order);
            logCat.debug((Object)"@@@ 1");
            for (int i = 0; i < result.size(); ++i) {
                FieldValue fieldVal = (FieldValue)result.elementAt(i);
                logCat.debug((Object)("fieldValue " + fieldVal.toString()));
            }
        }
        if (includeKeys) {
            for (int i = 0; i < this.getKey().size(); ++i) {
                Field keyField = (Field)this.getKey().elementAt(i);
                boolean found = false;
                for (int j = 0; !found && j < result.size(); ++j) {
                    FieldValue fv = (FieldValue)result.elementAt(j);
                    if (fv.getField() != keyField) continue;
                    found = true;
                }
                if (found) continue;
                result.addElement(FieldValue.createFieldValueForSorting(keyField, 0));
            }
        }
        Object[] resultArray = new FieldValue[result.size()];
        result.copyInto(resultArray);
        logCat.debug((Object)"@@@ 2");
        for (int i = 0; i < resultArray.length; ++i) {
            logCat.debug((Object)("fieldValue " + ((FieldValue)resultArray[i]).toString()));
        }
        return resultArray;
    }

    public ResultSetVector doConstrainedSelect(FieldValue[] fvEqual, FieldValue[] fvOrder, String sqlFilter, FieldValue[] sqlFilterParams, int compareMode, int maxRows, DbEventInterceptorData interceptorData) throws SQLException {
        String query = this.getSelectQuery(this.getFields(), fvEqual, fvOrder, sqlFilter, compareMode);
        PreparedStatement ps = interceptorData.getConnection().prepareStatement(query);
        ps.setMaxRows(maxRows);
        ResultSet rs = this.getDoSelectResultSet(fvEqual, fvOrder, sqlFilterParams, compareMode, ps);
        ResultSetVector result = new ResultSetVector(this);
        result.addResultSet(interceptorData, rs);
        ps.close();
        logCat.info((Object)("::doConstrainedSelect - rsv size = " + result.size()));
        return result;
    }

    public ResultSetVector doFreeFormSelect(String whereClause, String tableList, int maxRows, DbEventInterceptorData interceptorData) throws SQLException {
        ResultSet rs;
        Statement stmt = interceptorData.getConnection().createStatement();
        String query = this.getFreeFormSelectQuery(this.getFields(), whereClause, tableList);
        stmt.setMaxRows(maxRows);
        try {
            rs = stmt.executeQuery(query);
        }
        catch (SQLException sqle) {
            SqlUtil.logSqlException(sqle);
            throw new SQLException(sqle.getMessage());
        }
        ResultSetVector result = new ResultSetVector(this);
        result.addResultSet(interceptorData, rs);
        stmt.close();
        logCat.info((Object)("rsv size=" + result.size()));
        return result;
    }

    public void fillWithValues(FieldValue[] orderConstraint, String aPosition) {
        FieldValues ht = this.getFieldValues(aPosition);
        if (ht != null) {
            logCat.info((Object)("*** parsing through: " + aPosition));
            for (int i = 0; i < orderConstraint.length; ++i) {
                Field f = orderConstraint[i].getField();
                if (f == null) continue;
                FieldValue aFieldValue = ht.get(f.getName());
                if (aFieldValue != null) {
                    orderConstraint[i].setFieldValue(aFieldValue.getFieldValue());
                    continue;
                }
                logCat.warn((Object)("position entry has null value:" + f.getName()));
            }
        }
    }

    public boolean hasInterceptors() {
        return Table.getConfig() != null && Table.getConfig().hasInterceptors() || this.interceptors != null && this.interceptors.size() > 0;
    }

    public boolean hasUserPrivileg(HttpServletRequest request, int privileg) {
        return this.grantedPrivileges == null ? true : this.grantedPrivileges.hasUserPrivileg(request, privileg);
    }

    public void initDefaultOrder() {
        if (this.orderBy == null) {
            this.initDefaultOrderFromKeys();
        } else {
            this.defaultOrder = this.createOrderFieldValues(this.orderBy, null, true);
        }
        logCat.info((Object)"Table.initDefaultOrder done.");
    }

    public FieldValues mapChildFieldValues(Table parentTable, String parentFieldString, String childFieldString, String aPosition) {
        Vector childFieldNames = StringUtil.splitString(childFieldString, ",;~");
        Vector parentFieldNames = StringUtil.splitString(parentFieldString, ",;~");
        int len = childFieldNames.size();
        if (len == 0 || len != parentFieldNames.size()) {
            return null;
        }
        FieldValues ht = parentTable.getFieldValues(aPosition);
        if (ht == null) {
            return null;
        }
        FieldValues childFieldValues = new FieldValues();
        for (int i = 0; i < len; ++i) {
            String parentFieldName = (String)parentFieldNames.elementAt(i);
            Field parentField = parentTable.getFieldByName(parentFieldName);
            String childFieldName = (String)childFieldNames.elementAt(i);
            Field childField = this.getFieldByName(childFieldName);
            FieldValue aFieldValue = ht.get(parentField.getName());
            if (aFieldValue == null) {
                throw new IllegalArgumentException("ERROR: Make sure that field " + parentField.getName() + " is a KEY of the table " + parentTable.getName() + "! Otherwise you can not use it as PARENT/CHILD LINK argument!");
            }
            String currentParentFieldValue = aFieldValue.getFieldValue();
            childFieldValues.put(new FieldValue(childField, currentParentFieldValue));
        }
        return childFieldValues;
    }

    public void populateWhereClauseWithKeyFields(String keyValuesStr, PreparedStatement ps, int startColumn) throws SQLException {
        int col = startColumn;
        FieldValues keyValuesHt = this.getFieldValues(keyValuesStr);
        int keyLength = this.getKey().size();
        for (int i = 0; i < keyLength; ++i) {
            Field curField = (Field)this.getKey().elementAt(i);
            FieldValue aFieldValue = keyValuesHt.get(curField.getName());
            Object value = aFieldValue.getFieldValueAsObject();
            JDBCDataHelper.fillWithData(ps, curField.getEscaper(), col, value, curField.getType(), this.getBlobHandlingStrategy());
            ++col;
        }
    }

    public int populateWhereEqualsClause(FieldValue[] fv, PreparedStatement ps, int curCol) throws SQLException {
        if (fv != null && fv.length > 0) {
            for (int i = 0; i < fv.length; ++i) {
                curCol = this.fillPreparedStatement(fv[i], ps, curCol);
            }
        }
        return curCol;
    }

    public int processInterceptors(int action, DbEventInterceptorData data) throws SQLException {
        try {
            Vector allInterceptors = this.getInterceptors();
            int interceptorsCnt = allInterceptors.size();
            for (int i = 0; i < interceptorsCnt; ++i) {
                Interceptor interceptor = (Interceptor)allInterceptors.elementAt(i);
                Class<?> interceptorClass = Class.forName(interceptor.getClassName());
                DbEventInterceptor dbi = (DbEventInterceptor)interceptorClass.newInstance();
                dbi.setParameterMap(interceptor.getParameterMap());
                int operation = 0;
                String denyMessage = null;
                if (action == 0) {
                    operation = dbi.preInsert(data);
                    denyMessage = "dbforms.events.insert.nogrant";
                } else if (action == 1) {
                    dbi.postInsert(data);
                } else if (action == 2) {
                    operation = dbi.preUpdate(data);
                    denyMessage = "dbforms.events.update.nogrant";
                } else if (action == 3) {
                    dbi.postUpdate(data);
                } else if (action == 4) {
                    operation = dbi.preDelete(data);
                    denyMessage = "dbforms.events.delete.nogrant";
                } else if (action == 5) {
                    dbi.postDelete(data);
                } else if (action == 6) {
                    operation = dbi.preSelect(data);
                    denyMessage = "dbforms.events.view.nogrant";
                } else if (action == 7) {
                    dbi.postSelect(data);
                } else if (action == 8) {
                    operation = dbi.preAddRow(data);
                    denyMessage = "dbforms.events.addrow.nogrant";
                } else if (action == 9) {
                    dbi.postAddRow(data);
                }
                switch (operation) {
                    case 1: {
                        String s = MessageResourcesInternal.getMessage(denyMessage, data.getRequest().getLocale(), new String[]{this.getName()});
                        throw new SQLException(s);
                    }
                    case 2: {
                        return operation;
                    }
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            logCat.warn((Object)(" ClassNotFoundException : " + cnfe.getMessage()));
            throw new SQLException(cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            logCat.warn((Object)(" InstantiationException : " + ie.getMessage()));
            throw new SQLException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            logCat.warn((Object)(" IllegalAccessException : " + iae.getMessage()));
            throw new SQLException(iae.getMessage());
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (MultipleValidationException ve) {
            throw new SQLException(ve.getMessage());
        }
        catch (ValidationException ve) {
            throw new SQLException(ve.getMessage());
        }
        return 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\nname=");
        buf.append(this.name);
        buf.append(" ");
        buf.append("\nid=");
        buf.append(String.valueOf(this.getId()));
        buf.append(" ");
        if (this.getFields() != null) {
            for (int i = 0; i < this.getFields().size(); ++i) {
                Field f = (Field)this.getFields().elementAt(i);
                buf.append("\nfield: ");
                buf.append(f.toString());
            }
        }
        return buf.toString();
    }

    protected String getQueryOrderBy(FieldValue[] fvOrder) {
        StringBuffer buf = new StringBuffer();
        if (fvOrder != null) {
            for (int i = 0; i < fvOrder.length; ++i) {
                buf.append(fvOrder[i].getField().getName());
                if (fvOrder[i].getSortDirection() == 1) {
                    buf.append(" DESC");
                }
                if (i >= fvOrder.length - 1) continue;
                buf.append(",");
            }
        }
        return buf.toString();
    }

    protected String getQueryToChange() {
        return this.getQueryFrom();
    }

    protected String getQueryWhere(FieldValue[] fvEqual, FieldValue[] fvOrder, int compareMode) {
        boolean firstTermExists = false;
        StringBuffer buf = new StringBuffer();
        if (!FieldValue.isNull(fvEqual)) {
            buf.append(" ( ");
            if (fvEqual[0].getSearchMode() == 0) {
                buf.append(this.getWhereClause(fvEqual));
            } else {
                buf.append(this.getWhereEqualsSearchClause(fvEqual));
            }
            buf.append(" ) ");
            firstTermExists = true;
        }
        if (!FieldValue.isNull(fvOrder) && compareMode != 0) {
            buf.append(firstTermExists ? " AND ( " : "");
            buf.append(this.getWhereAfterClause(fvOrder, compareMode));
            buf.append(firstTermExists ? " ) " : "");
        }
        return buf.toString();
    }

    protected boolean checkFieldId(int type, int aid) {
        int i = aid / 1000;
        return i == type;
    }

    protected int decodeFieldId(int type, int aid) {
        return aid - type * 1000;
    }

    protected int encodeFieldId(int type, int aid) {
        return type * 1000 + aid;
    }

    private String getSQLExpression(FieldValue fv) {
        StringBuffer buf = new StringBuffer();
        Field f = fv.getField();
        String fieldName = Util.isNull(f.getExpression()) ? f.getName() : f.getExpression();
        buf.append(fieldName);
        switch (fv.getOperator()) {
            case 0: {
                buf.append(" = ");
                buf.append(" ? ");
                break;
            }
            case 6: {
                buf.append(" <> ");
                buf.append(" ? ");
                break;
            }
            case 1: {
                buf.append(" > ");
                buf.append(" ? ");
                break;
            }
            case 2: {
                buf.append(" < ");
                buf.append(" ? ");
                break;
            }
            case 3: {
                buf.append(" >= ");
                buf.append(" ? ");
                break;
            }
            case 4: {
                buf.append(" <= ");
                buf.append(" ? ");
                break;
            }
            case 5: {
                if (f.getType() == 1) {
                    buf.append(" LIKE ");
                } else {
                    buf.append(" = ");
                }
                buf.append(" ? ");
                break;
            }
            case 7: {
                buf.append(" IS NULL ");
                break;
            }
            case 8: {
                buf.append(" IS NOT NULL ");
                break;
            }
            case 9: {
                if (f.getType() == 1) {
                    buf.append(" = '' ");
                    buf.append(" OR ");
                }
                buf.append(fieldName);
                buf.append(" IS NULL ");
                break;
            }
            case 10: {
                if (f.getType() == 1) {
                    buf.append(" <> '' ");
                    buf.append(" OR ");
                }
                buf.append(fieldName);
                buf.append(" IS NOT NULL ");
            }
        }
        return buf.toString();
    }

    private String getWhereAfterClause(FieldValue[] fv, int compareMode) {
        String disj;
        String conj;
        String opB2;
        String opB1;
        String opA2;
        String opA1;
        if (compareMode == 1) {
            opA1 = ">=";
            opA2 = "<=";
            opB1 = ">";
            opB2 = "<";
            conj = " AND ";
            disj = " OR ";
        } else {
            opA1 = ">";
            opA2 = "<";
            opB1 = ">=";
            opB2 = "<=";
            conj = " OR ";
            disj = " AND ";
        }
        StringBuffer buf = new StringBuffer();
        if (fv != null && fv.length > 0) {
            for (int i = 0; i < fv.length; ++i) {
                buf.append("(");
                buf.append(fv[i].getField().getName());
                buf.append(fv[i].getSortDirection() == 0 ? opA1 : opA2);
                buf.append(" ? ");
                if (i > 0) {
                    for (int j = i - 1; j >= 0; --j) {
                        buf.append(disj);
                        buf.append(fv[j].getField().getName());
                        buf.append(fv[j].getSortDirection() == 0 ? opB1 : opB2);
                        buf.append(" ? ");
                    }
                }
                buf.append(" ) ");
                if (i >= fv.length - 1) continue;
                buf.append(conj);
            }
        }
        return buf.toString();
    }

    private String getWhereEqualsSearchClause(FieldValue[] fv) {
        StringBuffer buf = new StringBuffer();
        if (fv != null && fv.length > 0) {
            int oldMode = -1;
            for (int i = 0; i < fv.length; ++i) {
                int mode = fv[i].getSearchMode();
                if (oldMode != mode) {
                    oldMode = mode;
                    buf.append("(");
                }
                buf.append(this.getSQLExpression(fv[i]));
                if (i < fv.length - 1 && fv[i + 1].getSearchMode() == mode) {
                    buf.append(mode == 1 ? "AND " : "OR ");
                    continue;
                }
                buf.append(")");
                if (i == fv.length - 1) continue;
                buf.append(" OR ");
            }
        }
        return buf.toString();
    }

    private Vector createOrderFVFromAttribute(String order) {
        Vector<FieldValue> result = new Vector<FieldValue>();
        if (order != null) {
            StringTokenizer st = new StringTokenizer(order, ",");
            while (st.hasMoreTokens()) {
                String fieldName;
                Field f;
                String command;
                int pos;
                String token = st.nextToken().trim();
                logCat.info((Object)("token = " + token));
                int sortDirection = 0;
                int index = token.indexOf(" ");
                if (index != -1 && (pos = (command = token.substring(index).toUpperCase()).indexOf("ASC")) == -1) {
                    pos = command.indexOf("DESC");
                    if (index != -1) {
                        sortDirection = 1;
                    }
                }
                if ((f = this.getFieldByName(fieldName = index == -1 ? token.trim() : token.substring(0, index).trim())) == null) continue;
                FieldValue fv = FieldValue.createFieldValueForSorting(f, sortDirection);
                logCat.info((Object)("Field '" + fieldName + "' is ordered in mode:" + sortDirection));
                result.addElement(fv);
            }
        }
        return result;
    }

    private Vector createOrderFVFromRequest(HttpServletRequest request, String paramStub, Vector sortFields) {
        Vector<FieldValue> result = new Vector<FieldValue>();
        int fieldIndex = paramStub.length() + 1;
        for (int i = 0; i < sortFields.size(); ++i) {
            String dataParam = (String)sortFields.elementAt(i);
            int fieldId = Integer.parseInt(dataParam.substring(fieldIndex));
            String sortState = ParseUtil.getParameter(request, dataParam);
            logCat.info((Object)("### dataparam=" + dataParam));
            logCat.info((Object)("### fieldId=" + fieldId));
            logCat.info((Object)("### sortState=" + sortState));
            if (!sortState.equalsIgnoreCase("asc") && !sortState.equalsIgnoreCase("desc")) continue;
            int sortDirection = sortState.equalsIgnoreCase("asc") ? 0 : 1;
            FieldValue fv = FieldValue.createFieldValueForSorting(this.getField(fieldId), sortDirection);
            result.addElement(fv);
        }
        return result;
    }

    private String createToken(Field field, String fieldValue) {
        StringBuffer buf = new StringBuffer();
        buf.append(field.getId());
        buf.append(":");
        if (!Util.isNull(fieldValue)) {
            buf.append(fieldValue.length());
            buf.append(":");
            buf.append(fieldValue);
        } else {
            buf.append(0);
            buf.append(":");
        }
        return buf.toString();
    }

    private int fillPreparedStatement(FieldValue cur, PreparedStatement ps, int curCol) throws SQLException {
        logCat.info((Object)("setting col " + curCol + " with name " + cur.getField().getName() + " to value " + cur.getFieldValue() + " of type " + cur.getField().getType() + " operator " + cur.getOperator()));
        Field curField = cur.getField();
        Object curValue = cur.getFieldValueAsObject();
        if (curField.getType() == 1) {
            String valueStr = cur.getFieldValue();
            switch (cur.getSearchAlgorithm()) {
                case 2: {
                    valueStr = '%' + valueStr;
                    break;
                }
                case 3: {
                    valueStr = valueStr + '%';
                    break;
                }
                case 4: {
                    valueStr = '%' + valueStr + '%';
                }
            }
            curValue = valueStr;
        }
        switch (cur.getOperator()) {
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            default: {
                JDBCDataHelper.fillWithData(ps, curField.getEscaper(), curCol, curValue, curField.getType(), this.getBlobHandlingStrategy());
                ++curCol;
            }
        }
        return curCol;
    }

    private void initDefaultOrderFromKeys() {
        this.defaultOrder = new FieldValue[this.getKey().size()];
        for (int i = 0; i < this.getKey().size(); ++i) {
            Field keyField = (Field)this.getKey().elementAt(i);
            this.defaultOrder[i] = FieldValue.createFieldValueForSorting(keyField, 0);
        }
        logCat.info((Object)"Table.initDefaultOrderfromKey done.");
    }

    private int populateWhereAfterClause(FieldValue[] fv, PreparedStatement ps, int curCol) throws SQLException {
        if (fv != null && fv.length > 0) {
            for (int i = 0; i < fv.length; ++i) {
                curCol = this.fillPreparedStatement(fv[i], ps, curCol);
                if (i <= 0) continue;
                for (int j = i - 1; j >= 0; --j) {
                    curCol = this.fillPreparedStatement(fv[j], ps, curCol);
                }
            }
        }
        return curCol;
    }

    protected static DbFormsConfig getConfig() {
        DbFormsConfig config = null;
        try {
            config = DbFormsConfigRegistry.instance().lookup();
        }
        catch (Exception e) {
            logCat.error((Object)"no config object", (Throwable)e);
        }
        return config;
    }
}

