/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.resource.util;

import de.destatis.core.connect.util.ClientLogger;
import de.destatis.core.connect.util.Contract;
import de.destatis.core.resource.ResourceStorage;
import de.destatis.core.resource.ResourceStorageException;
import de.destatis.core.resource.util.ExtResourceDirNotExistsException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileSystemResourceStorage
implements ResourceStorage {
    private static final String LAST_UPDATE_CHECK_FILE_SUFFIX = ".lastupdate";
    private static final String LAST_UPDATE_ENCODING = "ISO-8859-1";
    private static final String DATE_FORMAT_STR = "yyyyMMddHHmmssSSS";
    private static ClientLogger LOG = ClientLogger.getLogger(FileSystemResourceStorage.class);
    protected File directory;
    private String fileSuffix;
    private Pattern resourceIdPattern;

    public FileSystemResourceStorage(File directory) throws ResourceStorageException {
        this.directory = directory;
        Contract.verify(directory != null, "Ressourcenverzeichnis ist erforderlich!");
        if (!this.directory.isDirectory() && !this.directory.mkdirs()) {
            throw new ExtResourceDirNotExistsException("Ressourcenverzeichnis '" + directory.getAbsolutePath() + "' muss existieren oder angelegt werden k\u00f6nnen!");
        }
    }

    public void setFileSuffix(String suffix) {
        this.fileSuffix = suffix;
    }

    public void setResourceIdPattern(String pattern) {
        this.resourceIdPattern = pattern == null ? null : Pattern.compile(pattern);
    }

    public void setResourceIdPattern(Pattern pattern) {
        this.resourceIdPattern = pattern;
    }

    @Override
    public void saveResource(String resourceId, byte[] resourceData) throws ResourceStorageException {
        this.checkResourceId(resourceId);
        if (resourceData == null || resourceData.length == 0) {
            throw new ResourceStorageException("Keine Daten zur Ressource \u00fcbergeben!");
        }
        RandomAccessFile fileAccess = null;
        try {
            File resourceFile = this.getResourceFile(resourceId);
            fileAccess = new RandomAccessFile(resourceFile, "rw");
            this.lockFile(resourceFile, fileAccess.getChannel(), false);
            FileOutputStream fOut = new FileOutputStream(fileAccess.getFD());
            BufferedOutputStream out = new BufferedOutputStream(fOut);
            ((OutputStream)out).write(resourceData);
            ((OutputStream)out).close();
            fileAccess = null;
        }
        catch (IOException e) {
            throw new ResourceStorageException(e);
        }
        finally {
            if (fileAccess != null) {
                try {
                    fileAccess.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public byte[] getResource(String resourceId) throws ResourceStorageException {
        byte[] resourceData = null;
        File resourceFile = this.getStoredResourceFile(resourceId);
        if (resourceFile != null) {
            FileInputStream fIn = null;
            try {
                int len;
                fIn = new FileInputStream(resourceFile);
                FileChannel fileChannel = fIn.getChannel();
                this.lockFile(resourceFile, fileChannel, true);
                long fileSize = resourceFile.length();
                if (fileSize == 0L) {
                    fIn.close();
                    fIn = null;
                    Thread.sleep(2000L);
                    fIn = new FileInputStream(resourceFile);
                    fileChannel = fIn.getChannel();
                    this.lockFile(resourceFile, fileChannel, true);
                    fileSize = resourceFile.length();
                    if (fileSize == 0L) {
                        throw new ResourceStorageException("Die Ressource '" + resourceId + "' ist leer!");
                    }
                }
                BufferedInputStream in = new BufferedInputStream(fIn);
                MyByteArrayOutputStream out = new MyByteArrayOutputStream((int)fileSize);
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                in.close();
                fIn = null;
                out.flush();
                resourceData = out.toByteArray();
            }
            catch (IOException e) {
                throw new ResourceStorageException(e);
            }
            catch (InterruptedException e) {
                throw new ResourceStorageException(e);
            }
            finally {
                if (fIn != null) {
                    try {
                        fIn.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return resourceData;
    }

    @Override
    public List getResourceIds() throws ResourceStorageException {
        GetResourceIdsFileFilter getResourceIdsFileFilter = this.createFileFilter();
        File[] filesInDir = this.directory.listFiles(getResourceIdsFileFilter);
        if (filesInDir == null) {
            throw new ResourceStorageException("Fehler beim Lesen der Dateien des Verzeichnisses '" + this.directory.getAbsolutePath() + "'.");
        }
        List result = getResourceIdsFileFilter.getResourceIdList();
        return result;
    }

    @Override
    public Date getLastUpdateCheck(String resourceId) throws ResourceStorageException {
        this.checkResourceId(resourceId);
        File lastUpdateCheckFile = this.getLastUpdateCheckFile(resourceId);
        Date lastUpdateDate = null;
        if (lastUpdateCheckFile.isFile()) {
            lastUpdateDate = this.getLastUpdateDate(lastUpdateCheckFile);
        }
        if (lastUpdateDate == null) {
            File resourceFile = this.getStoredResourceFile(resourceId);
            if (resourceFile == null) {
                throw new ResourceStorageException("Es existiert keine Ressourcedatei f\u00fcr RessourceId " + resourceId + ".");
            }
            long lastModified = resourceFile.lastModified();
            lastUpdateDate = new Date(lastModified);
        }
        return lastUpdateDate;
    }

    @Override
    public void setLastUpdateCheck(String resourceId, Date date) throws ResourceStorageException {
        Contract.verify(date != null, "Datum ist erforderlich");
        this.checkResourceId(resourceId);
        File resourceFile = this.getStoredResourceFile(resourceId);
        if (resourceFile == null) {
            throw new ResourceStorageException("Es existiert keine Ressourcedatei f\u00fcr RessourceId " + resourceId + ".");
        }
        RandomAccessFile fileAccess = null;
        try {
            File lastUpdateFile = this.getLastUpdateCheckFile(resourceId);
            fileAccess = new RandomAccessFile(lastUpdateFile, "rw");
            this.lockFile(lastUpdateFile, fileAccess.getChannel(), false);
            FileOutputStream fOut = new FileOutputStream(fileAccess.getFD());
            BufferedOutputStream out = new BufferedOutputStream(fOut);
            String dateStr = new SimpleDateFormat(DATE_FORMAT_STR).format(date);
            byte[] data = dateStr.getBytes(LAST_UPDATE_ENCODING);
            ((OutputStream)out).write(data);
            ((OutputStream)out).close();
            fileAccess = null;
        }
        catch (IOException e) {
            throw new ResourceStorageException(e);
        }
        finally {
            if (fileAccess != null) {
                try {
                    fileAccess.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected GetResourceIdsFileFilter createFileFilter() {
        return new GetResourceIdsFileFilter();
    }

    protected String getResourceIdFromFileName(String fileName) {
        if (this.fileSuffix != null) {
            return fileName.substring(0, fileName.length() - this.fileSuffix.length());
        }
        return fileName;
    }

    protected File getLastUpdateCheckFile(String resourceId) {
        String fileName = resourceId + this.fileSuffix + LAST_UPDATE_CHECK_FILE_SUFFIX;
        File file = new File(this.directory, fileName);
        return file;
    }

    protected File getResourceFile(String resourceId) {
        String resourceFileName = this.fileSuffix == null ? resourceId : resourceId + this.fileSuffix;
        File resourceFile = new File(this.directory, resourceFileName);
        return resourceFile;
    }

    protected File getStoredResourceFile(String resourceId) {
        String resourceFileName = this.fileSuffix == null ? resourceId : resourceId + this.fileSuffix;
        File resourceFile = new File(this.directory, resourceFileName);
        File result = !resourceFile.isFile() ? null : resourceFile;
        return result;
    }

    private void checkResourceId(String resourceId) throws ResourceStorageException {
        Matcher m;
        if (this.resourceIdPattern != null && !(m = this.resourceIdPattern.matcher(resourceId)).matches()) {
            throw new ResourceStorageException("Ung\u00fcltige RessourceId: " + resourceId + ".");
        }
    }

    private void lockFile(File file, FileChannel fileChannel, boolean shared) throws ResourceStorageException, IOException {
        FileLock lock;
        if (!this.setFileLocks()) {
            return;
        }
        int retry = 10;
        do {
            OverlappingFileLockException overlappingFileLockException = null;
            try {
                lock = shared ? fileChannel.tryLock(0L, Long.MAX_VALUE, true) : fileChannel.tryLock(0L, Long.MAX_VALUE, false);
            }
            catch (OverlappingFileLockException e) {
                overlappingFileLockException = e;
                lock = null;
            }
            if (lock != null) continue;
            if (--retry >= 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (overlappingFileLockException != null) {
                throw new ResourceStorageException("Die Datei '" + file.getAbsolutePath() + "' konnte nicht " + (shared ? "zum Lesen" : "zum Schreiben") + " gesperrt werden.", overlappingFileLockException);
            }
            throw new ResourceStorageException("Die Datei '" + file.getAbsolutePath() + "' konnte nicht " + (shared ? "zum Lesen" : "zum Schreiben") + " gesperrt werden.");
        } while (lock == null);
    }

    protected boolean setFileLocks() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getLastUpdateDate(File lastUpdateFile) {
        Date date;
        block11: {
            date = null;
            try {
                FileInputStream fIn = null;
                try {
                    int len;
                    fIn = new FileInputStream(lastUpdateFile);
                    FileChannel fileChannel = fIn.getChannel();
                    this.lockFile(lastUpdateFile, fileChannel, true);
                    BufferedInputStream in = new BufferedInputStream(fIn);
                    MyByteArrayOutputStream out = new MyByteArrayOutputStream(DATE_FORMAT_STR.length());
                    byte[] buffer = new byte[DATE_FORMAT_STR.length()];
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    in.close();
                    fIn = null;
                    out.flush();
                    byte[] data = ((ByteArrayOutputStream)out).toByteArray();
                    String dateStr = new String(data, LAST_UPDATE_ENCODING);
                    date = new SimpleDateFormat(DATE_FORMAT_STR).parse(dateStr);
                }
                finally {
                    if (fIn != null) {
                        try {
                            fIn.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            catch (Exception e) {
                LOG.error("LastUpdate konnte aus der Datei '" + lastUpdateFile.getAbsolutePath() + "' nicht extrahiert werden.", e);
                if (date != null) break block11;
                date = new Date(lastUpdateFile.lastModified());
            }
        }
        return date;
    }

    protected class GetResourceIdsFileFilter
    implements FileFilter {
        protected List resourceIdList = new ArrayList();

        protected GetResourceIdsFileFilter() {
        }

        protected List getResourceIdList() {
            return this.resourceIdList;
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isFile()) {
                String fileName = pathname.getName();
                boolean accept = true;
                if (FileSystemResourceStorage.this.fileSuffix != null && !fileName.endsWith(FileSystemResourceStorage.this.fileSuffix)) {
                    accept = false;
                }
                if (accept && FileSystemResourceStorage.this.resourceIdPattern != null) {
                    String resourceId = FileSystemResourceStorage.this.getResourceIdFromFileName(fileName);
                    Matcher m = FileSystemResourceStorage.this.resourceIdPattern.matcher(resourceId);
                    if (m.matches()) {
                        this.resourceIdList.add(resourceId);
                    }
                }
            }
            return false;
        }
    }

    private static final class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        private MyByteArrayOutputStream(int size) {
            super(size);
        }

        @Override
        public synchronized byte[] toByteArray() {
            if (this.count == this.buf.length) {
                return this.buf;
            }
            return super.toByteArray();
        }
    }
}

