/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.wizard.csvtemplate;

import de.destatis.core.map.editor.EditorProperties;
import de.destatis.core.map.editor.Icons;
import de.destatis.core.map.editor.wizard.AbstractStep;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class CsvFileChoiceStep
extends AbstractStep {
    private static final String PROP_LAST_FILE = new String("editor.csvTemplateWizard.lastCsvFile");
    private static final String TAB = "TAB";
    private JTextField filepath = new JTextField();
    private JComboBox encoding = new JComboBox<Object>(Charset.availableCharsets().keySet().toArray());
    private JComboBox csvSeparator;
    private JFileChooser fileChooser;
    private JLabel fileDescription;
    private JButton openFileChooser;
    private boolean isChooseDirectory = false;
    private boolean fireChanges = true;

    public CsvFileChoiceStep() {
        super(new GridBagLayout());
        String defaultEncoding = System.getProperty("file.encoding");
        Charset defaultCharset = null;
        if (defaultEncoding != null) {
            defaultCharset = Charset.forName(defaultEncoding);
        }
        if (defaultCharset != null) {
            this.encoding.setSelectedItem(defaultCharset.name());
        }
        this.csvSeparator = new JComboBox<String>(new String[]{";", ",", ".", TAB});
        this.csvSeparator.setSelectedIndex(0);
        this.filepath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (CsvFileChoiceStep.this.fireChanges) {
                    CsvFileChoiceStep.this.fireStateChanged();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (CsvFileChoiceStep.this.fireChanges) {
                    CsvFileChoiceStep.this.fireStateChanged();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.openFileChooser = new JButton(Icons.ICON_OPEN);
        this.openFileChooser.setToolTipText("Datei ausw\u00e4hlen ...");
        this.openFileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CsvFileChoiceStep.this.chooseFile();
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        this.fileDescription = new JLabel("CSV-Datei:");
        this.add((Component)this.fileDescription, gbc);
        gbc.weightx = 1.0;
        gbc.insets.left = 5;
        gbc.gridx = 1;
        gbc.anchor = 10;
        gbc.fill = 2;
        this.add((Component)this.filepath, gbc);
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        gbc.fill = 0;
        this.add((Component)this.openFileChooser, gbc);
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.insets.top = 5;
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        this.add((Component)new JLabel("Encoding:"), gbc);
        gbc.insets.left = 5;
        gbc.gridx = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridwidth = 2;
        this.add((Component)this.encoding, gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        this.add((Component)new JLabel("Feldtrenner:"), gbc);
        gbc.insets.left = 5;
        gbc.gridx = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridwidth = 2;
        this.add((Component)this.csvSeparator, gbc);
    }

    @Override
    public String getInfo() {
        if (this.isChooseDirectory) {
            return "Legen Sie das Verzeichnis f\u00fcr den Export fest, und konfigurieren Sie ggf. die Optionen f\u00fcr die erzeugten CSV-Dateien.";
        }
        return "Legen Sie Pfad und Name der Exportdatei fest, und konfigurieren Sie ggf. die Optionen f\u00fcr die erzeugte CSV-Datei.";
    }

    @Override
    public String getTitle() {
        if (this.isChooseDirectory) {
            return "Verzeichnis ausw\u00e4hlen";
        }
        return "CSV-Datei ausw\u00e4hlen";
    }

    @Override
    public boolean isComplete() {
        return this.isSelected();
    }

    public void setIsChooseDirectory(boolean isChooseDirectory) {
        if (isChooseDirectory != this.isChooseDirectory) {
            this.fireChanges = false;
            this.filepath.setText("");
            this.fireChanges = true;
        }
        this.isChooseDirectory = isChooseDirectory;
        this.fileDescription.setText(this.isChooseDirectory ? "Verzeichnis:" : "CSV-Datei:");
        this.openFileChooser.setToolTipText(this.isChooseDirectory ? "Verzeichnis ausw\u00e4hlen ..." : "Datei ausw\u00e4hlen ...");
    }

    public String getFilepath() {
        String result = this.filepath.getText().trim();
        return result;
    }

    public String getEncoding() {
        String result = (String)this.encoding.getSelectedItem();
        return result;
    }

    public char getCsvSeparator() {
        String selectedItem = (String)this.csvSeparator.getSelectedItem();
        char result = TAB.equals(selectedItem) ? (char)'\t' : (char)selectedItem.charAt(0);
        return result;
    }

    public boolean isSelected() {
        String filePath = this.getFilepath();
        boolean result = filePath.length() > 0;
        return result;
    }

    private void chooseFile() {
        int choice;
        if (this.fileChooser == null) {
            File file;
            File directory;
            this.fileChooser = new JFileChooser();
            EditorProperties editorProperties = EditorProperties.getInstance();
            String lastCsvFilePath = editorProperties.getProperty(PROP_LAST_FILE);
            if (lastCsvFilePath != null && lastCsvFilePath.trim().length() > 0 && (directory = (file = new File(lastCsvFilePath)).isDirectory() ? file : file.getParentFile()) != null && directory.isDirectory()) {
                this.fileChooser.setCurrentDirectory(directory);
                this.fileChooser.revalidate();
            }
        }
        this.configureFileChooser();
        if (this.isSelected()) {
            this.fileChooser.setSelectedFile(new File(this.getFilepath()));
        }
        if ((choice = this.fileChooser.showOpenDialog(null)) == 0 && this.fileChooser.getSelectedFile() != null) {
            File file = this.fileChooser.getSelectedFile();
            String filePath = file.getAbsolutePath().replace('\\', '/');
            EditorProperties.getInstance().setProperty(PROP_LAST_FILE, filePath);
            String filename = file.getAbsolutePath();
            if (!this.isChooseDirectory && filename.indexOf(46) < 0) {
                filename = filename + ".csv";
            }
            this.filepath.setText(filename);
        }
    }

    private void configureFileChooser() {
        if (this.fileChooser != null) {
            if (this.isChooseDirectory) {
                this.fileChooser.setFileSelectionMode(1);
                this.fileChooser.setFileFilter(null);
            } else {
                this.fileChooser.setFileSelectionMode(0);
                this.fileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file != null && (file.isDirectory() || file.isFile() && file.getName().toLowerCase().endsWith(".csv"));
                    }

                    @Override
                    public String getDescription() {
                        return "CSV-Dateien (*.csv)";
                    }
                });
            }
        }
    }
}

