/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.util;

import de.destatis.core.map.editor.treetable.TreeTable;
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;

public class SelectionFocusListener
implements FocusListener {
    private Color defaultSelectionForeground = null;
    private Color defaultSelectionBackground = null;

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getComponent() instanceof JTable) {
            TreeTable treeTable;
            JTable table = (JTable)e.getComponent();
            if (this.defaultSelectionForeground == null) {
                this.defaultSelectionForeground = table.getSelectionForeground();
            } else {
                table.setSelectionForeground(this.defaultSelectionForeground);
            }
            if (this.defaultSelectionBackground == null) {
                this.defaultSelectionBackground = table.getSelectionBackground();
            } else {
                table.setSelectionBackground(this.defaultSelectionBackground);
            }
            if (table instanceof TreeTable && (treeTable = (TreeTable)table).getTree().getCellRenderer() instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer treeCellRenderer = (DefaultTreeCellRenderer)treeTable.getTree().getCellRenderer();
                treeCellRenderer.setTextSelectionColor(this.defaultSelectionForeground);
                treeCellRenderer.setBackgroundSelectionColor(this.defaultSelectionBackground);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!(e.isTemporary() || e.getOppositeComponent() != null && SwingUtilities.isDescendingFrom(e.getOppositeComponent(), e.getComponent()) || !(e.getComponent() instanceof JTable))) {
            TreeTable treeTable;
            JTable table = (JTable)e.getComponent();
            if (this.defaultSelectionForeground == null) {
                this.defaultSelectionForeground = table.getSelectionForeground();
            }
            if (this.defaultSelectionBackground == null) {
                this.defaultSelectionBackground = table.getSelectionBackground();
            }
            table.setSelectionForeground(SystemColor.textText);
            table.setSelectionBackground(SystemColor.control);
            if (table instanceof TreeTable && (treeTable = (TreeTable)table).getTree().getCellRenderer() instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer treeCellRenderer = (DefaultTreeCellRenderer)treeTable.getTree().getCellRenderer();
                treeCellRenderer.setTextSelectionColor(SystemColor.textText);
                treeCellRenderer.setBackgroundSelectionColor(SystemColor.control);
            }
        }
    }
}

