/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor;

import de.destatis.core.map.Binding;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.editor.MappingTableSetValueUndoableEdit;
import de.destatis.core.map.editor.MappingTreeTableModel;
import de.destatis.core.map.editor.MetaMappingEditorTool;
import de.destatis.core.map.model.MetaMapping;
import javax.swing.undo.UndoableEditSupport;

public class MetaMappingTreeTableModel
extends MappingTreeTableModel {
    public MetaMappingTreeTableModel(MetaMappingEditorTool editor, MetaMapping mapping, UndoableEditSupport undoableEditSupport) {
        super(editor, mapping, undoableEditSupport);
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        Binding binding = (Binding)node;
        switch (column) {
            case 0: 
            case 1: {
                return false;
            }
            case 2: {
                return binding instanceof FieldGroupBinding || binding instanceof FieldBinding;
            }
            case 3: {
                return binding instanceof FieldBinding;
            }
            case 4: {
                return binding instanceof FieldGroupBinding;
            }
            case 5: {
                return binding instanceof FieldBinding;
            }
        }
        throw new IllegalArgumentException("column=" + column);
    }

    @Override
    public Object getValueAt(Object node, int column) {
        Binding binding = (Binding)node;
        switch (column) {
            case 0: {
                return binding;
            }
            case 1: {
                return binding;
            }
            case 2: {
                String customName = binding instanceof FieldBinding ? ((FieldBinding)binding).getCustomName() : (binding instanceof FieldGroupBinding ? ((FieldGroupBinding)binding).getCustomName() : null);
                return customName;
            }
            case 3: {
                Integer position = binding instanceof FieldBinding ? ((FieldBinding)binding).getPosition() : null;
                return position;
            }
            case 4: {
                Integer size = null;
                if (binding instanceof FieldGroupBinding) {
                    size = ((FieldGroupBinding)binding).getSize();
                }
                return size;
            }
            case 5: {
                String defaultValue = binding instanceof FieldBinding ? ((FieldBinding)binding).getDefaultValue() : null;
                return defaultValue;
            }
        }
        throw new IllegalArgumentException("column=" + column);
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
        if (aValue != null && aValue instanceof String && ((String)aValue).length() == 0) {
            aValue = null;
        }
        Binding binding = (Binding)node;
        switch (column) {
            case 2: {
                String customNameNew;
                FieldGroupBinding fieldGroupBinding;
                String customNameOld;
                if (binding instanceof FieldBinding) {
                    String customNameNew2;
                    FieldBinding fieldBinding = (FieldBinding)binding;
                    String customNameOld2 = fieldBinding.getCustomName();
                    if (this.isEqual(customNameOld2, customNameNew2 = (String)aValue)) break;
                    fieldBinding.setCustomName(customNameNew2);
                    this.editor.setDirtyFlag(true);
                    if (this.undoableEditSupport == null) break;
                    this.undoableEditSupport.postEdit(new MappingTableSetValueUndoableEdit(fieldBinding, "setCustomName", String.class, customNameOld2, customNameNew2, this.editor));
                    break;
                }
                if (!(binding instanceof FieldGroupBinding) || this.isEqual(customNameOld = (fieldGroupBinding = (FieldGroupBinding)binding).getCustomName(), customNameNew = (String)aValue)) break;
                fieldGroupBinding.setCustomName(customNameNew);
                this.editor.setDirtyFlag(true);
                if (this.undoableEditSupport == null) break;
                this.undoableEditSupport.postEdit(new MappingTableSetValueUndoableEdit(fieldGroupBinding, "setCustomName", String.class, customNameOld, customNameNew, this.editor));
                break;
            }
            case 3: {
                Integer positionNew;
                FieldBinding fieldBinding;
                Integer positionOld;
                if (!(binding instanceof FieldBinding) || this.isEqual(positionOld = (fieldBinding = (FieldBinding)binding).getPosition(), positionNew = (Integer)aValue)) break;
                fieldBinding.setPosition(positionNew);
                this.editor.setDirtyFlag(true);
                if (this.undoableEditSupport != null) {
                    this.undoableEditSupport.postEdit(new MappingTableSetValueUndoableEdit(fieldBinding, "setPosition", Integer.class, positionOld, positionNew, this.editor, true));
                }
                this.editor.positionOrQuantityHasChanged(binding);
                break;
            }
            case 4: {
                Integer sizeNew;
                FieldGroupBinding fieldGroupBinding;
                Integer sizeOld;
                if (!(binding instanceof FieldGroupBinding) || this.isEqual(sizeOld = (fieldGroupBinding = (FieldGroupBinding)binding).getSize(), sizeNew = (Integer)aValue)) break;
                fieldGroupBinding.setSize(sizeNew);
                this.editor.setDirtyFlag(true);
                if (this.undoableEditSupport != null) {
                    this.undoableEditSupport.postEdit(new MappingTableSetValueUndoableEdit(fieldGroupBinding, "setSize", Integer.class, sizeOld, sizeNew, this.editor, true));
                }
                this.editor.positionOrQuantityHasChanged(binding);
                break;
            }
            case 5: {
                String defaultValueNew;
                FieldBinding fieldBinding;
                String defaultValueOld;
                if (!(binding instanceof FieldBinding) || this.isEqual(defaultValueOld = (fieldBinding = (FieldBinding)binding).getDefaultValue(), defaultValueNew = (String)aValue)) break;
                fieldBinding.setDefaultValue(defaultValueNew);
                this.editor.setDirtyFlag(true);
                if (this.undoableEditSupport == null) break;
                this.undoableEditSupport.postEdit(new MappingTableSetValueUndoableEdit(fieldBinding, "setDefaultValue", String.class, defaultValueOld, defaultValueNew, this.editor));
                break;
            }
            default: {
                throw new IllegalArgumentException("column=" + column);
            }
        }
    }
}

