/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map;

import de.destatis.core.map.Binding;
import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.MappingProblem;
import de.destatis.core.map.model.BindingHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MappingCheckResult {
    private List<MappingProblem> problems = new ArrayList<MappingProblem>();
    private int fatal = 0;
    private int error = 0;
    private int warning = 0;
    private int info = 0;
    private Map<String, List<MappingProblem>> bindingProblemMap = new HashMap<String, List<MappingProblem>>();

    public boolean isOk() {
        return this.fatal == 0 && this.error == 0;
    }

    public int getNumOfFatal() {
        return this.fatal;
    }

    public int getNumOfError() {
        return this.error;
    }

    public int getNumOfWarning() {
        return this.warning;
    }

    public int getNumOfInfo() {
        return this.info;
    }

    public int getProblemsCount() {
        return this.problems.size();
    }

    public MappingProblem[] getProblems() {
        if (this.problems != null) {
            return this.problems.toArray(new MappingProblem[this.problems.size()]);
        }
        return null;
    }

    public List<MappingProblem> getProblems(Binding binding) {
        List<MappingProblem> problems = this.bindingProblemMap.get(this.getBindingPath(binding));
        if (problems == null) {
            problems = Collections.emptyList();
        }
        return problems;
    }

    public MappingProblem getWorstProblemWithinBindingGroup(BindingGroup bindingGroup) {
        MappingProblem result = null;
        String bindingPathPrefix = this.getBindingPath(bindingGroup) + ".";
        for (String bindingPath : this.bindingProblemMap.keySet()) {
            if (!bindingPath.startsWith(bindingPathPrefix)) continue;
            List<MappingProblem> problems = this.bindingProblemMap.get(bindingPath);
            for (MappingProblem problem : problems) {
                if (result != null && result.getType() <= problem.getType()) continue;
                result = problem;
            }
        }
        return result;
    }

    public String getErrorDescriptionString() {
        StringBuffer result = new StringBuffer();
        if (this.problems != null) {
            Iterator<MappingProblem> it = this.problems.iterator();
            boolean first = true;
            while (it.hasNext()) {
                MappingProblem problem = it.next();
                int type = problem.getType();
                if (type != 1 && type != 2) continue;
                if (first) {
                    first = false;
                } else {
                    result.append("\n");
                }
                result.append(problem.getDescription());
            }
        }
        return result.toString();
    }

    protected void addProblem(MappingProblem problem) {
        this.problems.add(problem);
        switch (problem.getType()) {
            case 1: {
                ++this.fatal;
                break;
            }
            case 2: {
                ++this.error;
                break;
            }
            case 3: {
                ++this.warning;
                break;
            }
            case 4: {
                ++this.info;
            }
        }
        if (problem.getBinding() != null) {
            String bindingPath = this.getBindingPath(problem.getBinding());
            List<MappingProblem> problems = this.bindingProblemMap.get(bindingPath);
            if (problems == null) {
                problems = new ArrayList<MappingProblem>();
                this.bindingProblemMap.put(bindingPath, problems);
            }
            problems.add(problem);
        }
    }

    private String getBindingPath(Binding binding) {
        return BindingHelper.getSubPathString(binding, 1, false);
    }
}

