/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.generator.generation;

import de.destatis.core.generator.DataProvider;
import de.destatis.core.generator.Descriptor;
import de.destatis.core.generator.DescriptorFactory;
import de.destatis.core.generator.FieldDescriptor;
import de.destatis.core.generator.StructureDescriptor;
import de.destatis.core.generator.generation.AbstractSdfGeneratorTraverser;
import de.destatis.core.generator.generation.DocumentBuilderInterpreter;
import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.model.BindingHelper;
import de.destatis.core.map.model.MetaMapping;
import de.statspez.sdf.generator.meta.SDFMetaStructureTraverser;
import de.statspez.sdf.generator.meta.generated.MetaSDFDokumenterzeuger;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaMerkmalsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetabeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplate;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateArgument;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateAufruf;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateAusfuehrung;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateAusgabe;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateParameter;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateProgramm;
import java.util.Map;
import java.util.Stack;

public class SDFMetaDataCollector
extends SDFMetaStructureTraverser {
    private static final Integer ZERO = new Integer(0);
    private Stack structureStack = new Stack();
    private Map values;
    private MetaMapping metaMapping;
    private BindingGroup currentBindingGroup;
    private boolean sdfMetaStrictMode;

    public SDFMetaDataCollector(StructureDescriptor parentDescriptor, DataProvider dataProvider, Map values, MetaMapping metaMapping, boolean sdfMetaStrictMode) {
        AbstractSdfGeneratorTraverser.StructureStackInfo stackInfo = new AbstractSdfGeneratorTraverser.StructureStackInfo(parentDescriptor, dataProvider);
        this.structureStack.push(stackInfo);
        this.values = values;
        this.metaMapping = metaMapping;
        if (this.metaMapping != null) {
            if (parentDescriptor == null) {
                this.currentBindingGroup = this.metaMapping.getDocumentBinding();
            } else if (1 == parentDescriptor.getType()) {
                this.currentBindingGroup = this.metaMapping.getMessageBinding();
            } else {
                throw new IllegalArgumentException("Ung\u00fcltiger ParentDeskriptor.");
            }
        }
        this.sdfMetaStrictMode = sdfMetaStrictMode;
    }

    public void visitSDFDokumenterzeuger(MetaSDFDokumenterzeuger dokumenterzeuger) {
    }

    public void visitSDFMetaAusgabegruppe(MetaSDFMetaAusgabegruppe ausgabegruppe) {
        super.visitSDFMetaAusgabegruppe(ausgabegruppe);
    }

    public void visitSDFMetaFeldReferenz(MetaSDFMetaFeldReferenz feldReferenz) {
        boolean required;
        short art = feldReferenz.getArt();
        boolean bl = required = feldReferenz.getAttributRequired() == 2;
        if (2 == art) {
            StructureDescriptor mmgrDescriptor;
            DataProvider mmgrDataProvider;
            MetaSDFMetaMerkmalsgruppe merkmalsgruppe = (MetaSDFMetaMerkmalsgruppe)feldReferenz.getKlasse();
            AbstractSdfGeneratorTraverser.StructureStackInfo stackInfo = (AbstractSdfGeneratorTraverser.StructureStackInfo)this.structureStack.peek();
            StructureDescriptor parent = stackInfo.getStructureDescriptor();
            DataProvider dataProvider = stackInfo.getDataProvider();
            FieldGroupBinding fieldGroupBinding = null;
            Integer quantity = null;
            String customName = null;
            Integer firstCsvPosition = null;
            Integer lastCsvPosition = null;
            BindingHelper.MinAndMax firstAndLastCsvPos = null;
            if (this.metaMapping != null) {
                fieldGroupBinding = (FieldGroupBinding)BindingHelper.getBindingByIdStrict(this.currentBindingGroup, merkmalsgruppe.getName());
                firstAndLastCsvPos = BindingHelper.getFirstAndLastCalculatedCsvPositionForFirstIndex(fieldGroupBinding);
                customName = fieldGroupBinding.getCustomName();
                quantity = fieldGroupBinding.getSize();
                firstCsvPosition = firstAndLastCsvPos != null ? new Integer(firstAndLastCsvPos.getMin()) : null;
                Integer n = lastCsvPosition = firstAndLastCsvPos != null ? new Integer(firstAndLastCsvPos.getMax()) : null;
            }
            if ((mmgrDataProvider = dataProvider.getDataProvider(mmgrDescriptor = DescriptorFactory.createMetaMmgrDescriptor(parent, merkmalsgruppe, customName, quantity, firstCsvPosition, lastCsvPosition))) != null) {
                String path = this.getSdfMetaPathString(mmgrDescriptor);
                this.values.put(path, ZERO);
                AbstractSdfGeneratorTraverser.StructureStackInfo mmgrStackInfo = new AbstractSdfGeneratorTraverser.StructureStackInfo(mmgrDescriptor, mmgrDataProvider);
                this.structureStack.push(mmgrStackInfo);
                if (this.metaMapping != null) {
                    this.currentBindingGroup = fieldGroupBinding;
                }
                super.visitSDFMetaMerkmalsgruppe(merkmalsgruppe);
                if (this.metaMapping != null) {
                    this.currentBindingGroup = this.currentBindingGroup.getParent();
                }
                this.structureStack.pop();
            } else if (required && this.sdfMetaStrictMode) {
                throw new DocumentBuilderInterpreter.DocumentbuilderInterpreterException("Keine Daten f\u00fcr die erforderliche MetaMerkmalsgruppe '" + mmgrDescriptor.getPathString() + "' vorhanden.");
            }
        } else {
            MetaSDFMetaMerkmal merkmal = (MetaSDFMetaMerkmal)feldReferenz.getKlasse();
            AbstractSdfGeneratorTraverser.StructureStackInfo stackInfo = (AbstractSdfGeneratorTraverser.StructureStackInfo)this.structureStack.peek();
            StructureDescriptor parent = stackInfo.getStructureDescriptor();
            FieldBinding fieldBinding = null;
            String customName = null;
            Integer csvPos = null;
            if (this.metaMapping != null) {
                fieldBinding = (FieldBinding)BindingHelper.getBindingByIdStrict(this.currentBindingGroup, merkmal.getName());
                customName = fieldBinding.getCustomName();
                csvPos = fieldBinding.getPosition();
            }
            FieldDescriptor mmDescriptor = DescriptorFactory.createMetaFieldDescriptor(parent, merkmal, customName, csvPos);
            DataProvider dataProvider = stackInfo.getDataProvider();
            String value = dataProvider.getFieldValue(mmDescriptor);
            if (value == null && fieldBinding != null) {
                value = fieldBinding.getDefaultValue();
            }
            String path = this.getSdfMetaPathString(mmDescriptor);
            this.values.put(path, value);
            if (value == null && required && this.sdfMetaStrictMode) {
                throw new DocumentBuilderInterpreter.DocumentbuilderInterpreterException("Kein Wert f\u00fcr das erforderliche MetaMerkmal '" + mmDescriptor.getPathString() + "' vorhanden.");
            }
        }
    }

    public void visitSDFMetaMerkmal(MetaSDFMetaMerkmal merkmal) {
    }

    public void visitSDFMetaMerkmalsgruppe(MetaSDFMetaMerkmalsgruppe merkmalsgruppe) {
    }

    public void visitSDFMetabeschreibung(MetaSDFMetabeschreibung metabeschreibung) {
    }

    public void visitSDFTemplate(MetaSDFTemplate template) {
    }

    public void visitSDFTemplateArgument(MetaSDFTemplateArgument argument) {
    }

    public void visitSDFTemplateAufruf(MetaSDFTemplateAufruf aufruf) {
    }

    public void visitSDFTemplateAusfuehrung(MetaSDFTemplateAusfuehrung ausfuehrung) {
    }

    public void visitSDFTemplateAusgabe(MetaSDFTemplateAusgabe ausgabe) {
    }

    public void visitSDFTemplateParameter(MetaSDFTemplateParameter parameter) {
    }

    public void visitSDFTemplateProgramm(MetaSDFTemplateProgramm programm) {
    }

    public String getSdfMetaPathString(Descriptor descriptor) {
        StructureDescriptor parent = ((AbstractSdfGeneratorTraverser.StructureStackInfo)this.structureStack.get(0)).getStructureDescriptor();
        String sdfMetaPath = parent == null ? descriptor.getPathString() : AbstractSdfGeneratorTraverser.getSubPathString(parent, descriptor);
        return sdfMetaPath;
    }
}

