/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.generator;

import de.destatis.core.connect.util.Contract;
import de.destatis.core.generator.FieldDescriptor;
import de.destatis.core.generator.FieldDescriptorImpl;
import de.destatis.core.generator.StructureDescriptor;
import de.destatis.core.generator.StructureDescriptorImpl;
import de.statspez.pleditor.generator.masken.GanzZahlMaske;
import de.statspez.pleditor.generator.masken.GanzZahlMaskenParser;
import de.statspez.pleditor.generator.masken.KommaZahlMaske;
import de.statspez.pleditor.generator.masken.KommaZahlMaskenParser;
import de.statspez.pleditor.generator.masken.MaskeException;
import de.statspez.pleditor.generator.masken.NichtNegGanzZahlMaske;
import de.statspez.pleditor.generator.masken.NichtNegGanzZahlParser;
import de.statspez.pleditor.generator.masken.PosGanzZahlMaske;
import de.statspez.pleditor.generator.masken.PosGanzZahlMaskenParser;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmalsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaMerkmalsgruppe;

public class DescriptorFactory {
    public static FieldDescriptor createFieldDescriptor(StructureDescriptor parent, MetaSDFMerkmal sdfMerkmal, String customName, Integer csvPosition) {
        FieldDescriptorImpl result = new FieldDescriptorImpl(parent);
        result.setType(1);
        result.setName(sdfMerkmal.getName());
        result.setCustomName(customName);
        result.setCsvPosition(csvPosition);
        DescriptorFactory.setDataType(sdfMerkmal, result);
        return result;
    }

    public static FieldDescriptor createMetaFieldDescriptor(StructureDescriptor parent, MetaSDFMetaMerkmal sdfMetaMerkmal, String customName, Integer csvPosition) {
        FieldDescriptorImpl result = new FieldDescriptorImpl(parent);
        result.setType(2);
        result.setName(sdfMetaMerkmal.getName());
        result.setCustomName(customName);
        result.setCsvPosition(csvPosition);
        DescriptorFactory.setDataType((MetaSDFMerkmal)sdfMetaMerkmal, result);
        return result;
    }

    public static StructureDescriptor createMessageDescriptor(int index) {
        StructureDescriptorImpl result = new StructureDescriptorImpl(1);
        result.setIndex(new Integer(index));
        result.setName("Nachricht");
        return result;
    }

    public static StructureDescriptor createRecordDescriptor(StructureDescriptor parent, int index) {
        Contract.verify(parent != null && parent.getType() == 1, "Ung&uuml;ltiger Parent");
        StructureDescriptorImpl result = new StructureDescriptorImpl(2, parent);
        result.setIndex(new Integer(index));
        result.setName("Satz");
        return result;
    }

    public static StructureDescriptor createMmgrDescriptor(StructureDescriptor parent, MetaSDFMerkmalsgruppe sdfMmmgr, Integer index, String customName, Integer quantity, Integer firstCsvPosition, Integer lastCsvPosition) {
        Contract.verify(parent != null && (parent.getType() == 2 || parent.getType() == 3), "Ung&uuml;ltiger Parent");
        StructureDescriptorImpl result = new StructureDescriptorImpl(3, parent);
        result.setName(sdfMmmgr.getName());
        result.setIndex(index);
        result.setCustomName(customName);
        result.setQuantity(quantity);
        result.setFirstCsvPosition(firstCsvPosition);
        result.setLastCsvPosition(lastCsvPosition);
        return result;
    }

    public static StructureDescriptor createMetaMmgrDescriptor(StructureDescriptor parent, MetaSDFMetaMerkmalsgruppe sdfMetaMmgr, String customName, Integer quantity, Integer firstCsvPosition, Integer lastCsvPosition) {
        Contract.verify(parent == null || parent.getType() == 1 || parent.getType() == 4, "Ung&uuml;ltiger Parent");
        Contract.verify(quantity == null || quantity == 0 || quantity == 1, "Ung&uuml;ltige Quantity");
        StructureDescriptorImpl result = new StructureDescriptorImpl(4, parent);
        result.setName(sdfMetaMmgr.getName());
        result.setIndex(null);
        result.setCustomName(customName);
        result.setQuantity(quantity);
        result.setFirstCsvPosition(firstCsvPosition);
        result.setLastCsvPosition(lastCsvPosition);
        return result;
    }

    private static final void setDataType(MetaSDFMerkmal sdfMerkmal, FieldDescriptorImpl fieldDescriptor) {
        try {
            short sdfType = sdfMerkmal.getTyp();
            switch (sdfType) {
                case 1: 
                case 2: 
                case 3: {
                    long length;
                    fieldDescriptor.setDataType(5);
                    long minLength = sdfMerkmal.getMinimaleLaenge();
                    if (minLength > 0L) {
                        fieldDescriptor.setMinimumLength(minLength);
                    }
                    if ((length = sdfMerkmal.getLaenge()) > 0L) {
                        fieldDescriptor.setMaximumLength(length);
                    }
                    break;
                }
                case 8: {
                    fieldDescriptor.setDataType(6);
                    fieldDescriptor.setMaximumLength(sdfMerkmal.getLaenge());
                    fieldDescriptor.setPattern(sdfMerkmal.getMaske());
                    break;
                }
                case 4: {
                    fieldDescriptor.setDataType(4);
                    fieldDescriptor.setMaximumLength(sdfMerkmal.getLaenge());
                    String maskeStr = sdfMerkmal.getMaske();
                    if (maskeStr != null && maskeStr.length() > 0) {
                        KommaZahlMaskenParser parser = new KommaZahlMaskenParser();
                        KommaZahlMaske maske = (KommaZahlMaske)parser.parse(maskeStr);
                        int vorkomma = maske.getVorkommastellen();
                        int nachkomma = maske.getNachkommastellen();
                        fieldDescriptor.setTotalDigits(vorkomma + nachkomma);
                        fieldDescriptor.setFractionDigits(nachkomma);
                        fieldDescriptor.setMaximumLength(maske.gibMaxLaenge());
                        fieldDescriptor.setPattern(maskeStr);
                    }
                    break;
                }
                case 5: {
                    fieldDescriptor.setDataType(1);
                    fieldDescriptor.setMaximumLength(sdfMerkmal.getLaenge());
                    String maskeStr = sdfMerkmal.getMaske();
                    if (maskeStr != null) {
                        GanzZahlMaskenParser parser = new GanzZahlMaskenParser();
                        GanzZahlMaske maske = (GanzZahlMaske)parser.parse(maskeStr);
                        fieldDescriptor.setTotalDigits(maske.getStellen());
                        fieldDescriptor.setMaximumLength(maske.gibMaxLaenge());
                        fieldDescriptor.setPattern(maskeStr);
                    }
                    break;
                }
                case 6: {
                    fieldDescriptor.setDataType(3);
                    fieldDescriptor.setMaximumLength(sdfMerkmal.getLaenge());
                    String maskeStr = sdfMerkmal.getMaske();
                    if (maskeStr != null && maskeStr.length() > 0) {
                        NichtNegGanzZahlParser parser = new NichtNegGanzZahlParser();
                        NichtNegGanzZahlMaske maske = (NichtNegGanzZahlMaske)parser.parse(maskeStr);
                        fieldDescriptor.setTotalDigits(maske.getStellen());
                        fieldDescriptor.setMaximumLength(maske.gibMaxLaenge());
                        fieldDescriptor.setPattern(maskeStr);
                    }
                    break;
                }
                case 7: {
                    fieldDescriptor.setDataType(2);
                    fieldDescriptor.setMaximumLength(sdfMerkmal.getLaenge());
                    String maskeStr = sdfMerkmal.getMaske();
                    if (maskeStr != null && maskeStr.length() > 0) {
                        PosGanzZahlMaskenParser parser = new PosGanzZahlMaskenParser();
                        PosGanzZahlMaske maske = (PosGanzZahlMaske)parser.parse(maskeStr);
                        fieldDescriptor.setTotalDigits(maske.getStellen());
                        fieldDescriptor.setMaximumLength(maske.gibMaxLaenge());
                        fieldDescriptor.setPattern(maskeStr);
                    }
                    break;
                }
                default: {
                    Contract.verify(false, "Unbekannter SDFDatentyp: " + sdfType);
                    break;
                }
            }
        }
        catch (MaskeException e) {
            throw new RuntimeException(e);
        }
    }

    private DescriptorFactory() {
    }
}

