/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.transfer.https;

import de.destatis.core.connect.GetSurveyResourceRequest;
import de.destatis.core.connect.Response;
import de.destatis.core.connect.ResponseStatus;
import de.destatis.core.connect.ResponseToGetResourceRequest;
import de.destatis.core.connect.transfer.https.HttpsRequestHandler;
import de.destatis.core.connect.util.ClientConfig;
import de.destatis.core.connect.util.ClientLogger;
import de.destatis.core.resource.ResourceType;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.util.EntityUtils;

public class HttpsGetResourceRequestHandler
extends HttpsRequestHandler {
    protected static final String RESPONSE_RESOURCE_ID = "X-ResourceId";
    protected static final String RESPONSE_RESOURCE_FILENAME = "X-FileName";
    protected static final String RESPONSE_RESOURCE_CHARSET = "X-Charset";
    private static final ClientLogger LOG = ClientLogger.getLogger(HttpsGetResourceRequestHandler.class);

    public HttpsGetResourceRequestHandler(GetSurveyResourceRequest request, ClientConfig config) {
        super(request, config);
    }

    @Override
    public String getActionValue() {
        return "get_resource_connect";
    }

    @Override
    public void addParts(Map<String, ContentBody> partList) {
        GetSurveyResourceRequest resourceRequest = (GetSurveyResourceRequest)this.getRequest();
        ResourceType resourceType = resourceRequest.getResourceType();
        int resourceTypeId = resourceType.getTypeId();
        LOG.trace("resource_type=" + resourceTypeId);
        try {
            partList.put("resource_type", (ContentBody)new StringBody(String.valueOf(resourceTypeId)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String statId = resourceRequest.getStatId();
        LOG.trace("statistic_id=" + statId);
        try {
            partList.put("statistic_id", (ContentBody)new StringBody(statId));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String collector = resourceRequest.getCollector();
        LOG.trace("collector=" + collector);
        try {
            partList.put("collector", (ContentBody)new StringBody(collector));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String referencePeriod = resourceRequest.getReferencePeriod();
        LOG.trace("reporting_period=" + referencePeriod);
        try {
            partList.put("reporting_period", (ContentBody)new StringBody(referencePeriod));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String currentResourceId = resourceRequest.getCurrentResourceId();
        if (currentResourceId != null) {
            LOG.trace("current_resource_id=" + currentResourceId);
            try {
                partList.put("current_resource_id", (ContentBody)new StringBody(currentResourceId));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Response getResponse(HttpResponse httpResponse) {
        ResponseToGetResourceRequest response;
        ResponseStatus responseStatus = this.getResponseStatus(httpResponse);
        if (ResponseStatus.OK.equals(responseStatus)) {
            try {
                Header resourceIdHeader = httpResponse.getFirstHeader(RESPONSE_RESOURCE_ID);
                String resourceId = resourceIdHeader.getValue();
                String fileName = null;
                Header fileNameHeader = httpResponse.getFirstHeader(RESPONSE_RESOURCE_FILENAME);
                if (fileNameHeader != null) {
                    fileName = fileNameHeader.getValue();
                }
                String charset = null;
                Header charsetHeader = httpResponse.getFirstHeader(RESPONSE_RESOURCE_CHARSET);
                if (charsetHeader != null) {
                    charset = charsetHeader.getValue();
                }
                HttpEntity entity = httpResponse.getEntity();
                byte[] data = EntityUtils.toByteArray((HttpEntity)entity);
                response = new ResponseToGetResourceRequest(responseStatus, null, resourceId, data, charset, fileName);
            }
            catch (Exception e) {
                LOG.error("Fehler beim Lesen der Ressourcedaten", e);
                response = new ResponseToGetResourceRequest(ResponseStatus.BAD_RESPONSE, e.getMessage(), null, null, null, null);
            }
        } else {
            String responseBody = this.getResponseBody(httpResponse);
            response = new ResponseToGetResourceRequest(responseStatus, responseBody, null, null, null, null);
        }
        return response;
    }
}

