/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.document.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SaxWriter
extends DefaultHandler
implements LexicalHandler {
    public static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    public static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    public static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    public static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    public static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    public static final String LOAD_EXTERNAL_DTD_FEATURE_ID = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    public static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_LOAD_EXTERNAL_DTD = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    private PrintWriter userOut;
    private StringWriter outBuffer;
    private PrintWriter out;
    private boolean canonical = false;
    private int elementDepth = 0;
    private Locator locator = null;
    private boolean xml11 = false;
    private boolean inCDATA = false;
    private boolean xmlHeaderWritten = false;

    public void parse(InputSource source) throws SAXException {
        this.parseDocument(source);
    }

    public void parse(InputStream stream, String encoding) throws SAXException {
        InputSource source = new InputSource(stream);
        source.setEncoding(encoding);
        this.parseDocument(source);
    }

    public void parse(Reader reader) throws SAXException {
        InputSource source = new InputSource(reader);
        this.parseDocument(source);
    }

    public void setCanonical(boolean canonical) {
        this.canonical = canonical;
    }

    public void setOutput(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        OutputStreamWriter writer = new OutputStreamWriter(stream, encoding);
        this.userOut = new PrintWriter(writer);
        this.outBuffer = new StringWriter(1024);
        this.out = new PrintWriter(this.outBuffer);
    }

    public void setOutput(Writer writer) {
        if (writer instanceof PrintWriter) {
            this.userOut = (PrintWriter)writer;
            this.outBuffer = new StringWriter(1024);
            this.out = new PrintWriter(this.outBuffer);
        } else {
            this.userOut = new PrintWriter(writer);
            this.outBuffer = new StringWriter(1024);
            this.out = new PrintWriter(this.outBuffer);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.elementDepth = 0;
        this.xml11 = false;
        this.inCDATA = false;
        this.xmlHeaderWritten = false;
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.out.print("<?");
        this.out.print(target);
        if (data != null && data.length() > 0) {
            this.out.print(' ');
            this.out.print(data);
        }
        this.out.println("?>");
        this.out.flush();
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
        if (!this.xmlHeaderWritten) {
            if (this.locator != null) {
                this.xml11 = "1.1".equals(this.getVersion());
            }
            if (!this.canonical) {
                if (this.xml11) {
                    this.userOut.println("<?xml version=\"1.1\" encoding=\"UTF-8\"?>");
                } else {
                    this.userOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                }
                this.userOut.flush();
            }
            this.out.flush();
            this.userOut.print(this.outBuffer.toString());
            this.out = this.userOut;
            this.out.flush();
            this.xmlHeaderWritten = true;
        }
        ++this.elementDepth;
        this.out.print('<');
        this.out.print(raw);
        if (attrs != null) {
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                this.out.print(' ');
                this.out.print(attrs.getQName(i));
                this.out.print("=\"");
                this.normalizeAndPrint(attrs.getValue(i), true);
                this.out.print('\"');
            }
        }
        this.out.print('>');
        this.out.flush();
    }

    @Override
    public void endElement(String uri, String local, String raw) throws SAXException {
        --this.elementDepth;
        this.out.print("</");
        this.out.print(raw);
        this.out.print('>');
        this.out.flush();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.inCDATA) {
            this.normalizeAndPrint(ch, start, length, false);
        } else {
            for (int i = 0; i < length; ++i) {
                this.out.print(ch[start + i]);
            }
        }
        this.out.flush();
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
        this.out.flush();
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        if (!this.canonical) {
            this.out.print("<![CDATA[");
            this.inCDATA = true;
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (!this.canonical) {
            this.inCDATA = false;
            this.out.print("]]>");
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.canonical) {
            this.out.print("<!--");
            for (int i = 0; i < length; ++i) {
                this.out.print(ch[start + i]);
            }
            this.out.print("-->");
            this.out.flush();
        }
    }

    @Override
    public void warning(SAXParseException exc) throws SAXException {
        this.printError("Warning", exc);
    }

    @Override
    public void error(SAXParseException exc) throws SAXException {
        this.printError("Error", exc);
    }

    @Override
    public void fatalError(SAXParseException exc) throws SAXException {
        this.printError("Fatal Error", exc);
        throw exc;
    }

    protected PrintWriter getPrintWriter() {
        return this.out;
    }

    protected Locator getDocumentLocator() {
        return this.locator;
    }

    protected void errPrintln(String text) {
        System.err.println(text);
    }

    protected void errPrintStackTrace(Exception exc) {
        exc.printStackTrace();
    }

    protected void normalizeAndPrint(String s, boolean isAttValue) {
        int len = s != null ? s.length() : 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            this.normalizeAndPrint(c, isAttValue);
        }
    }

    protected void normalizeAndPrint(char[] ch, int offset, int length, boolean isAttValue) {
        for (int i = 0; i < length; ++i) {
            this.normalizeAndPrint(ch[offset + i], isAttValue);
        }
    }

    protected void normalizeAndPrint(char c, boolean isAttValue) {
        switch (c) {
            case '<': {
                this.out.print("&lt;");
                break;
            }
            case '>': {
                this.out.print("&gt;");
                break;
            }
            case '&': {
                this.out.print("&amp;");
                break;
            }
            case '\"': {
                if (isAttValue) {
                    this.out.print("&quot;");
                    break;
                }
                this.out.print("\"");
                break;
            }
            case '\r': {
                this.out.print("&#xD;");
                break;
            }
            case '\n': {
                if (this.canonical) {
                    this.out.print("&#xA;");
                    break;
                }
            }
            default: {
                if (this.xml11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || isAttValue && (c == '\t' || c == '\n')) {
                    this.out.print("&#x");
                    this.out.print(Integer.toHexString(c).toUpperCase());
                    this.out.print(";");
                    break;
                }
                this.out.print(c);
            }
        }
    }

    protected void printError(String type, SAXParseException ex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(type);
        buffer.append("] ");
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            buffer.append(systemId);
        }
        buffer.append(':');
        buffer.append(ex.getLineNumber());
        buffer.append(':');
        buffer.append(ex.getColumnNumber());
        buffer.append(": ");
        buffer.append(ex.getMessage());
        this.errPrintln(buffer.toString());
    }

    protected String getVersion() {
        if (this.locator == null) {
            return null;
        }
        String version = null;
        Method getXMLVersion = null;
        try {
            getXMLVersion = this.locator.getClass().getMethod("getXMLVersion", new Class[0]);
            if (getXMLVersion != null) {
                version = (String)getXMLVersion.invoke((Object)this.locator, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return version;
    }

    private void parseDocument(InputSource source) throws SAXException {
        if (this.userOut == null) {
            this.setOutput(new OutputStreamWriter(System.out));
        }
        XMLReader parser = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
        try {
            parser.setFeature(NAMESPACES_FEATURE_ID, true);
        }
        catch (SAXException e) {
            this.errPrintln("Warnung: Parser-Feature http://xml.org/sax/features/namespaces konnte nicht gesetzt werden");
        }
        try {
            parser.setFeature(NAMESPACE_PREFIXES_FEATURE_ID, true);
        }
        catch (SAXException e) {
            this.errPrintln("Warnung: Parser-Feature http://xml.org/sax/features/namespace-prefixes konnte nicht gesetzt werden");
        }
        try {
            parser.setFeature(VALIDATION_FEATURE_ID, false);
        }
        catch (SAXException e) {
            this.errPrintln("Warnung: Parser-Feature http://xml.org/sax/features/validation konnte nicht gesetzt werden");
        }
        try {
            parser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, false);
        }
        catch (SAXException e) {
            this.errPrintln("Warnung: Parser-Feature http://apache.org/xml/features/validation/schema konnte nicht gesetzt werden");
        }
        try {
            parser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, false);
        }
        catch (SAXException e) {
            this.errPrintln("Warnung: Parser-Feature http://apache.org/xml/features/validation/schema-full-checking konnte nicht gesetzt werden");
        }
        try {
            parser.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, false);
        }
        catch (SAXException e) {
            this.errPrintln("Warnung: Parser-Feature http://apache.org/xml/features/validation/dynamic konnte nicht gesetzt werden");
        }
        try {
            parser.setFeature(LOAD_EXTERNAL_DTD_FEATURE_ID, false);
        }
        catch (SAXException e) {
            this.errPrintln("Warnung: Parser-Feature http://apache.org/xml/features/nonvalidating/load-external-dtd konnte nicht gesetzt werden");
        }
        parser.setContentHandler(this);
        parser.setErrorHandler(this);
        try {
            parser.setProperty(LEXICAL_HANDLER_PROPERTY_ID, this);
        }
        catch (SAXException exc) {
            this.errPrintStackTrace(exc);
        }
        try {
            parser.parse(source);
        }
        catch (SAXParseException exc) {
            throw exc;
        }
        catch (Exception exc) {
            this.errPrintStackTrace(exc);
            throw new RuntimeException(exc);
        }
        finally {
            if (this.out != null) {
                this.out.close();
            }
        }
    }
}

