/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public final class HttpClientFactory {
    private HttpClientFactory() {
    }

    public static HttpClient createConnection(String scheme, String hostname, int port, String username, String password, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return HttpClientFactory.createConnection(HttpFileSystemConfigBuilder.getInstance(), scheme, hostname, port, username, password, fileSystemOptions);
    }

    public static HttpClient createConnection(HttpFileSystemConfigBuilder builder, String scheme, String hostname, int port, String username, String password, FileSystemOptions fileSystemOptions) throws FileSystemException {
        HttpClient client;
        try {
            MultiThreadedHttpConnectionManager mgr = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams connectionMgrParams = mgr.getParams();
            client = new HttpClient((HttpConnectionManager)mgr);
            HostConfiguration config = new HostConfiguration();
            config.setHost(hostname, port, scheme);
            if (fileSystemOptions != null) {
                Cookie[] cookies;
                UserAuthenticator proxyAuth;
                String proxyHost = builder.getProxyHost(fileSystemOptions);
                int proxyPort = builder.getProxyPort(fileSystemOptions);
                if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
                    config.setProxy(proxyHost, proxyPort);
                }
                if ((proxyAuth = builder.getProxyAuthenticator(fileSystemOptions)) != null) {
                    UserAuthenticationData authData = UserAuthenticatorUtils.authenticate(proxyAuth, new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD});
                    if (authData != null) {
                        UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, null)), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, null)));
                        AuthScope scope = new AuthScope(proxyHost, -1);
                        client.getState().setProxyCredentials(scope, (Credentials)proxyCreds);
                    }
                    if (builder.isPreemptiveAuth(fileSystemOptions)) {
                        HttpClientParams httpClientParams = new HttpClientParams();
                        httpClientParams.setAuthenticationPreemptive(true);
                        client.setParams(httpClientParams);
                    }
                }
                if ((cookies = builder.getCookies(fileSystemOptions)) != null) {
                    client.getState().addCookies(cookies);
                }
            }
            connectionMgrParams.setMaxConnectionsPerHost(config, builder.getMaxConnectionsPerHost(fileSystemOptions));
            connectionMgrParams.setMaxTotalConnections(builder.getMaxTotalConnections(fileSystemOptions));
            connectionMgrParams.setConnectionTimeout(builder.getConnectionTimeout(fileSystemOptions));
            connectionMgrParams.setSoTimeout(builder.getSoTimeout(fileSystemOptions));
            client.setHostConfiguration(config);
            if (username != null) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
                AuthScope scope = new AuthScope(hostname, -1);
                client.getState().setCredentials(scope, (Credentials)creds);
            }
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.http/connect.error", (Throwable)exc, hostname);
        }
        return client;
    }
}

