/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib.tags;

import de.laures.cewolf.CewolfException;
import de.laures.cewolf.ChartHolder;
import de.laures.cewolf.Configuration;
import de.laures.cewolf.Storage;
import de.laures.cewolf.WebConstants;
import de.laures.cewolf.taglib.ChartImageDefinition;
import de.laures.cewolf.taglib.TaglibConstants;
import de.laures.cewolf.taglib.html.HTMLImgTag;
import de.laures.cewolf.taglib.tags.CewolfRootTag;
import de.laures.cewolf.taglib.util.MIMEExtensionHelper;
import de.laures.cewolf.taglib.util.PageUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.JspException;
import java.io.IOException;

public class LegendTag
extends HTMLImgTag
implements CewolfRootTag,
TaglibConstants,
WebConstants {
    private static final String DEFAULT_MIME_TYPE = "image/png";
    private static final int DEFAULT_TIMEOUT = 300;
    private int timeout = 300;
    private transient String sessionKey;
    private transient String renderer;
    private String mimeType = "image/png";

    public int doStartTag() throws JspException {
        ChartHolder cd = PageUtils.getChartHolder(this.getChartId(), this.pageContext);
        ChartImageDefinition cid = new ChartImageDefinition(cd, this.width, this.height, 1, this.mimeType, this.timeout);
        Storage storage = Configuration.getInstance(this.pageContext.getServletContext()).getStorage();
        try {
            this.sessionKey = storage.storeChartImage(cid, this.pageContext);
        }
        catch (CewolfException cwex) {
            throw new JspException(cwex.getMessage());
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        super.doStartTag();
        StringBuffer buffer = new StringBuffer(" src=\"");
        buffer.append(this.getImgURL());
        buffer.append("\"");
        try {
            this.pageContext.getOut().write(buffer.toString());
        }
        catch (IOException ioex) {
            this.reset();
            throw new JspException(ioex.getMessage());
        }
        return super.doEndTag();
    }

    protected String getImgURL() {
        HttpServletResponse response;
        StringBuffer url;
        if (this.renderer.startsWith("/")) {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            String context = request.getContextPath();
            this.renderer = context + this.renderer;
        }
        if ((url = new StringBuffer((response = (HttpServletResponse)this.pageContext.getResponse()).encodeURL(this.renderer))).toString().indexOf("jsessionid") == -1) {
            String sessionId = this.pageContext.getSession().getId();
            url.append(";jsessionid=" + sessionId);
        }
        url.append("?img=" + this.sessionKey);
        url.append("&amp;width=" + this.width);
        url.append("&amp;height=" + this.height);
        url.append("&amp;iehack=" + MIMEExtensionHelper.getExtensionForMimeType(this.mimeType));
        return url.toString();
    }

    protected void reset() {
        int lHeight = this.height;
        int lWidth = this.width;
        int lTimeout = this.timeout;
        super.reset();
        this.height = lHeight;
        this.width = lWidth;
        this.timeout = lTimeout;
    }

    public String getChartId() {
        return this.getId();
    }

    public void setRenderer(String rend) {
        this.renderer = rend;
    }

    public void setMime(String mimeType) {
        this.mimeType = mimeType;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

