/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.storage;

import de.laures.cewolf.CewolfException;
import de.laures.cewolf.ChartImage;
import de.laures.cewolf.Storage;
import de.laures.cewolf.storage.SessionStorageGroup;
import de.laures.cewolf.storage.SessionStorageItem;
import de.laures.cewolf.taglib.util.KeyGenerator;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.PageContext;
import java.io.Serializable;

public class LongTermSessionStorage
implements Storage {
    public final String getKey(ChartImage cid) {
        return String.valueOf(KeyGenerator.generateKey((Serializable)((Object)cid)));
    }

    public String storeChartImage(ChartImage chartImage, PageContext pageContext) throws CewolfException {
        HttpSession session = pageContext.getSession();
        SessionStorageGroup ssg = (SessionStorageGroup)session.getAttribute("CewolfCharts");
        if (ssg == null) {
            ssg = new SessionStorageGroup();
            session.setAttribute("CewolfCharts", (Object)ssg);
        }
        String cid = this.getKey(chartImage);
        SessionStorageItem ssi = new SessionStorageItem(chartImage, cid, chartImage.getTimeoutTime());
        ssg.put(cid, ssi);
        return cid;
    }

    public ChartImage getChartImage(String id, HttpServletRequest request) {
        SessionStorageItem ssi;
        HttpSession session = request.getSession();
        ChartImage chart = null;
        SessionStorageGroup ssg = (SessionStorageGroup)session.getAttribute("CewolfCharts");
        if (ssg != null && (ssi = (SessionStorageItem)ssg.get(id)) != null) {
            chart = ssi.getChart();
        }
        return chart;
    }

    public void init(ServletContext servletContext) throws CewolfException {
    }
}

