/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.client;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.mock.http.MockHttpOutputMessage;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

public class MockClientHttpRequest
extends MockHttpOutputMessage
implements ClientHttpRequest {
    private HttpMethod httpMethod;
    private URI uri;
    @Nullable
    private ClientHttpResponse clientHttpResponse;
    private boolean executed = false;
    @Nullable
    Map<String, Object> attributes;

    public MockClientHttpRequest() {
        this(HttpMethod.GET, URI.create("/"));
    }

    public MockClientHttpRequest(HttpMethod httpMethod, String uriTemplate, Object ... vars) {
        this(httpMethod, UriComponentsBuilder.fromUriString((String)uriTemplate).buildAndExpand(vars).encode().toUri());
    }

    public MockClientHttpRequest(HttpMethod httpMethod, URI uri) {
        this.httpMethod = httpMethod;
        this.uri = uri;
    }

    public void setMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setResponse(ClientHttpResponse clientHttpResponse) {
        this.clientHttpResponse = clientHttpResponse;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public Map<String, Object> getAttributes() {
        Map<String, Object> attributes = this.attributes;
        if (attributes == null) {
            this.attributes = attributes = new ConcurrentHashMap<String, Object>();
        }
        return attributes;
    }

    public final ClientHttpResponse execute() throws IOException {
        this.executed = true;
        return this.executeInternal();
    }

    protected ClientHttpResponse executeInternal() throws IOException {
        Assert.state((this.clientHttpResponse != null ? 1 : 0) != 0, (String)"No ClientHttpResponse");
        return this.clientHttpResponse;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.httpMethod).append(' ').append(this.uri);
        if (!this.getHeaders().isEmpty()) {
            sb.append(", headers: ").append(this.getHeaders());
        }
        return sb.toString();
    }
}

