/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expressions;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.ExpressionVisitor;
import org.springframework.data.relational.core.sql.render.NameRenderer;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.SimpleFunctionVisitor;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;
import org.springframework.lang.Nullable;

class OrderByClauseVisitor
extends TypedSubtreeVisitor<OrderByField>
implements PartRenderer {
    private final RenderContext context;
    private final StringBuilder builder = new StringBuilder();
    @Nullable
    private PartRenderer delegate;
    private boolean first = true;

    OrderByClauseVisitor(RenderContext context) {
        this.context = context;
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(OrderByField segment) {
        if (!this.first) {
            this.builder.append(", ");
        }
        this.first = false;
        return super.enterMatched(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(OrderByField segment) {
        String nullPrecedence;
        if (segment.getDirection() != null) {
            this.builder.append(" ").append(segment.getDirection());
        }
        if (!(nullPrecedence = this.context.getSelectRenderContext().evaluateOrderByNullHandling(segment.getNullHandling())).isEmpty()) {
            this.builder.append(" ").append(nullPrecedence);
        }
        return DelegatingVisitor.Delegation.leave();
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        if (segment instanceof SimpleFunction) {
            this.delegate = new SimpleFunctionVisitor(this.context);
            return DelegatingVisitor.Delegation.delegateTo((SimpleFunctionVisitor)this.delegate);
        }
        if (segment instanceof Expressions.SimpleExpression) {
            this.delegate = new ExpressionVisitor(this.context);
            return DelegatingVisitor.Delegation.delegateTo((ExpressionVisitor)this.delegate);
        }
        return super.enterNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (this.delegate instanceof SimpleFunctionVisitor || this.delegate instanceof ExpressionVisitor) {
            this.builder.append(this.delegate.getRenderedPart());
            this.delegate = null;
        }
        if (segment instanceof Column) {
            this.builder.append(NameRenderer.fullyQualifiedReference(this.context, (Column)segment));
        }
        return super.leaveNested(segment);
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.builder;
    }
}

