/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.MutableAggregateChange;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DeleteAggregateChange<T>
implements MutableAggregateChange<T> {
    private final Class<T> entityType;
    private final List<DbAction<?>> actions = new ArrayList();
    @Nullable
    private final Number previousVersion;

    DeleteAggregateChange(Class<T> entityType, @Nullable Number previousVersion) {
        this.entityType = entityType;
        this.previousVersion = previousVersion;
    }

    @Override
    public void addAction(DbAction<?> action) {
        Assert.notNull(action, (String)"Action must not be null");
        this.actions.add(action);
    }

    @Override
    public AggregateChange.Kind getKind() {
        return AggregateChange.Kind.DELETE;
    }

    @Override
    public Class<T> getEntityType() {
        return this.entityType;
    }

    @Override
    @Nullable
    public Number getPreviousVersion() {
        return this.previousVersion;
    }

    @Override
    public void forEachAction(Consumer<? super DbAction<?>> consumer) {
        Assert.notNull(consumer, (String)"Consumer must not be null");
        this.actions.forEach(consumer);
    }
}

