/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.springframework.dao.DataAccessException;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;

class FunctionCollector<T>
implements Collector<DataAccessStrategy, ResultOrException<T>, T> {
    private final Function<DataAccessStrategy, T> method;

    FunctionCollector(Function<DataAccessStrategy, T> method) {
        this.method = method;
    }

    @Override
    public Supplier<ResultOrException<T>> supplier() {
        return ResultOrException::new;
    }

    @Override
    public BiConsumer<ResultOrException<T>, DataAccessStrategy> accumulator() {
        return (roe, das) -> {
            if (!roe.hasResult()) {
                try {
                    roe.setResult(this.method.apply((DataAccessStrategy)das));
                }
                catch (Exception ex) {
                    roe.add(ex);
                }
            }
        };
    }

    @Override
    public BinaryOperator<ResultOrException<T>> combiner() {
        return (roe1, roe2) -> {
            throw new UnsupportedOperationException("Can't combine method calls");
        };
    }

    @Override
    public Function<ResultOrException<T>, T> finisher() {
        return roe -> {
            if (roe.hasResult) {
                return roe.result;
            }
            throw new CombinedDataAccessException("Failed to perform data access with all available strategies", Collections.unmodifiableList(roe.exceptions));
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    static class ResultOrException<T> {
        private T result;
        private final List<Exception> exceptions = new LinkedList<Exception>();
        private boolean hasResult = false;

        ResultOrException() {
        }

        private boolean hasResult() {
            return this.hasResult;
        }

        private void setResult(T result) {
            this.result = result;
            this.hasResult = true;
        }

        public void add(Exception ex) {
            this.exceptions.add(ex);
        }
    }

    static class CombinedDataAccessException
    extends DataAccessException {
        CombinedDataAccessException(String message, List<Exception> exceptions) {
            super(CombinedDataAccessException.combineMessage(message, exceptions), (Throwable)exceptions.get(exceptions.size() - 1));
        }

        private static String combineMessage(String message, List<Exception> exceptions) {
            return message + exceptions.stream().map(Throwable::getMessage).collect(Collectors.joining("\n\t", "\n\t", ""));
        }
    }
}

